/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.actions;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.report.ReportGenerator;
import com.excentis.products.byteblower.report.ReportPreferences;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public class NewReportAction
extends ByteBlowerNewAction<TestDataReference> {
    private AtomicBoolean readyToGenerate = new AtomicBoolean(true);

    public NewReportAction(ByteBlowerViewerComposite<TestDataReference> iByteBlowerViewerComposite) {
        super("Report", iByteBlowerViewerComposite);
    }

    protected void run(int amount) {
        ArrayList<TestDataReference> toRegenerate = new ArrayList<TestDataReference>();
        for (TestDataReference testDataReference : this.getSelectedObjects()) {
            toRegenerate.add(testDataReference);
        }
        this.readyToGenerate.set(false);
        this.setEnabled(this.readyToGenerate.get());
        final String originalTxt = this.getText();
        this.setText("Busy regenerating...");
        RegenerationJob regenerationJob = new RegenerationJob("Regenerating...", toRegenerate);
        regenerationJob.schedule();
        regenerationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display current = Display.getDefault();
                if (current != null) {
                    current.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).NewReportAction.this.readyToGenerate.set(true);
                            NewReportAction.this.setText(originalTxt);
                            NewReportAction.this.setEnabled((this).NewReportAction.this.readyToGenerate.get());
                        }
                    });
                }
            }
        });
    }

    public void update() {
        if (this.readyToGenerate.get()) {
            for (TestDataReference testDataReference : this.getSelectedObjects()) {
                if (!TestDataReferenceController.create(testDataReference).databaseExists()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private static final class RegenerationJob
    extends Job {
        private final List<TestDataReference> toRegenerate;

        private RegenerationJob(String name, List<TestDataReference> toRegenerate) {
            super(name);
            this.toRegenerate = toRegenerate;
        }

        protected IStatus run(IProgressMonitor progress) {
            progress.beginTask("Regeneration", this.toRegenerate.size());
            ReportPreferences reportPreferences = new ReportPreferences(ByteBlowerGuiResourceController.getProject());
            Set requestedFormats = reportPreferences.getOutputFormats();
            requestedFormats.add(ReportOutputFormat.dynamicHtml);
            reportPreferences.setOutputFormats((Collection)requestedFormats);
            int regenCtr = 0;
            for (TestDataReference testDataReference : this.toRegenerate) {
                progress.setTaskName(String.format("Regenerating report %d of %d", ++regenCtr, this.toRegenerate.size()));
                long testId = testDataReference.getId();
                NullProgressMonitor noMonitor = new NullProgressMonitor();
                try {
                    ReportGenerator.getInstance().generateReport(Long.valueOf(testId), (ReportPreferencesInterface)reportPreferences, (IProgressMonitor)noMonitor);
                }
                catch (Exception e) {
                    System.out.println("NewReportAction : Failed to generate report : " + e);
                }
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                progress.worked(1);
            }
            return Status.OK_STATUS;
        }
    }
}

