/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class ExecutedScenarioLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private static final int COLUMN_TIME = 0;
    private static final int COLUMN_PROJECT = 1;
    private static final int COLUMN_VERSION = 2;
    private static final int COLUMN_SCENARIO = 3;
    private static final int COLUMN_STATUS = 4;
    private static final int COLUMN_BACKUP = 5;
    private static final int COLUMN_RUNTITLE = 6;
    private static final int COLUMN_FILE_SIZE = 7;
    protected static final String[] columnNames = new String[]{"Time", "Project", "Version", "Scenario", "Status", "Backup", "Run Title", "File size"};
    protected static final int[] columnWeights = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
    private final Image scenarioImage = ImageDescriptor.createFromFile(ImageCache.class, (String)"reports/scenario.ico").createImage();

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$results$dataprovider$data$enums$TestStatus = ExecutedScenarioLabelProvider.$SWITCH_TABLE$com$excentis$products$byteblower$results$dataprovider$data$enums$TestStatus();
    }

    ExecutedScenarioLabelProvider() {
    }

    public String getToolTipText(Object element) {
        return "Doubleclick to open the most recent HTML report";
    }

    public Color getForeground(Object element) {
        TestDataReference ref;
        TestDataReferenceController controller;
        if (element != null && !(controller = TestDataReferenceController.create(ref = (TestDataReference)element)).filesExist()) {
            return ExcentisColors.lightgrey;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        try {
            TestDataReference testDataReference = (TestDataReference)element;
            switch (columnIndex) {
                case 0: {
                    Date startTime = testDataReference.getStartTime();
                    result = startTime.toString();
                    break;
                }
                case 1: {
                    result = testDataReference.getProjectName();
                    break;
                }
                case 2: {
                    result = testDataReference.getProjectVersion();
                    break;
                }
                case 3: {
                    result = testDataReference.getTestName();
                    break;
                }
                case 4: {
                    TestStatus testStatus = testDataReference.getStatus();
                    result = this.humanReadable(testStatus);
                    break;
                }
                case 5: {
                    boolean available = ReportViewer.getInstance().backupAvailable(testDataReference);
                    result = available ? "Yes" : "No";
                    break;
                }
                case 6: {
                    result = testDataReference.getTestRunTitle();
                    break;
                }
                case 7: {
                    result = testDataReference.getTestDatabaseSize();
                    break;
                }
                default: {
                    result = "Unknown column";
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            result = "";
        }
        return result;
    }

    private String humanReadable(TestStatus testStatus) {
        switch (testStatus) {
            case CANCELLED: {
                return "Cancelled";
            }
            case CREATED: {
                return "Created";
            }
            case ERROR: {
                return "Error";
            }
            case EXECUTING: {
                return "In progress";
            }
            case FINISHED: {
                return "Finished";
            }
        }
        return "Unknown";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.scenarioImage;
        }
        return image;
    }
}

