/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.gui.views.archive.composites.ExecutedScenariosComposite;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Tag;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.PlatformUI;

class FilterOperation
extends Job {
    private static final AtomicReference<FilterOperation> currentFilterOperation = new AtomicReference<Object>(null);
    private final Pattern filter;
    private final ExecutedScenariosComposite scenarios;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$results$dataprovider$data$enums$TestStatus = FilterOperation.$SWITCH_TABLE$com$excentis$products$byteblower$results$dataprovider$data$enums$TestStatus();
    }

    public FilterOperation(String match, ExecutedScenariosComposite scenarios) {
        super("Filters the available tests");
        this.setPriority(50);
        this.scenarios = scenarios;
        if (match == null || match.isEmpty()) {
            this.filter = null;
        } else {
            String smartFilter = ".*" + match.replace("*", ".*") + ".*";
            this.filter = Pattern.compile(smartFilter.toUpperCase());
        }
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                FilterOperation oldFilter = currentFilterOperation.getAndSet(FilterOperation.this);
                if (oldFilter != null) {
                    oldFilter.cancel();
                }
            }
        });
    }

    private String humanReadable(TestStatus testStatus) {
        switch (testStatus) {
            case CANCELLED: {
                return "Cancelled";
            }
            case CREATED: {
                return "Created";
            }
            case ERROR: {
                return "Error";
            }
            case EXECUTING: {
                return "In progress";
            }
            case FINISHED: {
                return "Finished";
            }
        }
        return "Unknown";
    }

    private StringBuilder buildString(Object start, StringBuilder builder) {
        if (start != null) {
            builder.append(start.toString());
        }
        return builder;
    }

    private boolean filterMatches(TestDataReference ref) {
        if (this.filter == null) {
            return true;
        }
        StringBuilder builder = new StringBuilder();
        this.buildString(ref.getStartTime(), builder);
        this.buildString(ref.getProjectName(), builder);
        this.buildString(ref.getProjectVersion(), builder);
        this.buildString(ref.getTestName(), builder);
        TestStatus testStatus = ref.getStatus();
        String status = this.humanReadable(testStatus);
        this.buildString(status, builder);
        boolean available = ReportViewer.getInstance().backupAvailable(ref);
        String backup = available ? "Yes" : "No";
        this.buildString(backup, builder);
        String runTitle = ref.getTestRunTitle();
        this.buildString(runTitle, builder);
        String smartBlob = builder.toString();
        StringBuilder tagBlob = new StringBuilder();
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Tag tag : ref.getTags()) {
            tagNames.add(tag.getName());
        }
        Collections.sort(tagNames);
        for (String tagName : tagNames) {
            tagBlob.append(tagName);
        }
        smartBlob = tagBlob + smartBlob + tagBlob;
        smartBlob = smartBlob.toUpperCase();
        return this.filter.matcher(smartBlob).matches();
    }

    public boolean shouldRun() {
        return currentFilterOperation.get() == this;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        List<TestDataReference> refs = this.scenarios.getTestDataReferences();
        final ArrayList<TestDataReference> results = new ArrayList<TestDataReference>();
        for (TestDataReference ref : refs) {
            if (!this.shouldRun() || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (!this.filterMatches(ref)) continue;
            results.add(ref);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FilterOperation.this.scenarios.isDisposed() || monitor.isCanceled()) {
                    FilterOperation.this.scenarios.setInput(results);
                    currentFilterOperation.compareAndSet(FilterOperation.this, null);
                }
            }
        });
        return Status.OK_STATUS;
    }
}

