/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.views.archive.composites.GeneratedReportsComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class GeneratedReportsPopupMenu
extends ByteBlowerPopupMenu {
    private static final int POPUP_POS_NEW_REPORT = 0;
    private static final int POPUP_POS_DELETE = 1;
    private static final int POPUP_POS_EXPORT = 2;
    private static final int POPUP_POS_OPEN_CONTAINING_FOLDER = 3;
    private IByteBlowerAction actionInterface;
    private GeneratedReportsComposite composite;

    public GeneratedReportsPopupMenu(Shell shell, IByteBlowerAction actionInterface, GeneratedReportsComposite composite) {
        super(shell);
        this.actionInterface = actionInterface;
        this.composite = composite;
    }

    protected void initializeMenu() {
        MenuItem item = new MenuItem(this.menu, 8, 0);
        item.setText("Generate New Report");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratedReportsPopupMenu.this.generateNewReports();
            }
        });
        item = new MenuItem(this.menu, 8, 1);
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratedReportsPopupMenu.this.actionInterface.doDelete();
            }
        });
        item = new MenuItem(this.menu, 8, 2);
        item.setText("Export...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratedReportsPopupMenu.this.exportSelectedTestResults();
            }
        });
        item = new MenuItem(this.menu, 8, 3);
        item.setText("Open Containing Folder...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Report selectedReport = (Report)GeneratedReportsPopupMenu.this.composite.getFirstSelectedObject();
                try {
                    String fileUrl = selectedReport.getFileUrl();
                    if (fileUrl == null) {
                        return;
                    }
                    if (fileUrl.startsWith("http") && fileUrl.contains("://")) {
                        try {
                            URL g = new URL(fileUrl);
                            String parent = String.valueOf(g.getProtocol()) + "://" + g.getHost();
                            ReportViewer.getInstance().openReport(parent);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        File reportFile = new File(fileUrl);
                        File parentFolder = new File(reportFile.getParent());
                        Desktop.getDesktop().open(parentFolder);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void exportSelectedTestResults() {
        List<String> fileNames = this.getValidSelectedReports();
        TestDataReferenceController.exportReports(fileNames, this.composite.getShell());
    }

    private List<String> getValidSelectedReports() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Report report : this.composite.getSelectedObjects()) {
            String filename = report.getFileUrl();
            File file = new File(filename);
            if (!file.exists() || file.isDirectory()) continue;
            fileNames.add(filename);
        }
        return fileNames;
    }

    private boolean selectionContainsReports() {
        return !this.getValidSelectedReports().isEmpty();
    }

    private void generateNewReports() {
        this.composite.getNewAction().run();
    }

    protected void initializeListeners() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                GeneratedReportsPopupMenu.this.composite.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MenuItem[] items = GeneratedReportsPopupMenu.this.menu.getItems();
                        int selection = (this).GeneratedReportsPopupMenu.this.composite.getStructuredSelection().size();
                        items[0].setEnabled((this).GeneratedReportsPopupMenu.this.actionInterface.isNewEnabled());
                        items[1].setEnabled((this).GeneratedReportsPopupMenu.this.actionInterface.isDeleteEnabled());
                        items[2].setEnabled(GeneratedReportsPopupMenu.this.selectionContainsReports());
                        items[3].setEnabled(selection == 1);
                    }
                });
            }
        });
    }
}

