/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.runner.ReportGenerationJob;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.views.archive.composites.TestDataReferenceController;
import com.excentis.products.byteblower.report.ReportPreferences;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

class NewSingleReportAction
extends ByteBlowerNewAction<Report> {
    private static final Object StartReportLock = new Object();
    private static final ArrayList<WeakReference<ReportGenerationJob>> reportsInProgress = new ArrayList();

    protected NewSingleReportAction(ByteBlowerViewerComposite<Report> composite) {
        super("Report", composite);
    }

    private static void cleanJobs() {
        ArrayList<WeakReference<ReportGenerationJob>> cleaned = new ArrayList<WeakReference<ReportGenerationJob>>();
        for (WeakReference<ReportGenerationJob> testRef : reportsInProgress) {
            if (testRef.get() == null) continue;
            cleaned.add(testRef);
        }
        if (cleaned.size() != reportsInProgress.size()) {
            reportsInProgress.clear();
            reportsInProgress.addAll(cleaned);
        }
    }

    private static void removeJob(long testId) {
        NewSingleReportAction.cleanJobs();
        int ctr = 0;
        while (ctr < reportsInProgress.size()) {
            ReportGenerationJob job = (ReportGenerationJob)reportsInProgress.get(ctr).get();
            if (job != null && job.getTestReference() == testId) {
                reportsInProgress.remove(ctr);
                return;
            }
            ++ctr;
        }
    }

    private static boolean addJob(ReportGenerationJob job) {
        long testId = job.getTestReference();
        NewSingleReportAction.cleanJobs();
        for (WeakReference<ReportGenerationJob> testRef : reportsInProgress) {
            if (testRef.get() == null || ((ReportGenerationJob)testRef.get()).getTestReference() != testId) continue;
            return false;
        }
        reportsInProgress.add(new WeakReference<ReportGenerationJob>(job));
        return true;
    }

    protected void run(int amount) {
        ReportPreferences reportPreferences = new ReportPreferences(ByteBlowerGuiResourceController.getProject());
        ArrayList<ReportOutputFormat> toRegenerate = new ArrayList<ReportOutputFormat>();
        ReportOutputFormat[] reportOutputFormatArray = ReportOutputFormat.values();
        int n = reportOutputFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReportOutputFormat format = reportOutputFormatArray[n2];
            if (this.selectionContains(format)) {
                toRegenerate.add(format);
            }
            ++n2;
        }
        reportPreferences.setOutputFormats(toRegenerate);
        this.generateReports((ReportPreferencesInterface)reportPreferences);
    }

    private boolean selectionContains(ReportOutputFormat format) {
        ReportFileFormat outputFormat = ReportOutputFormat.getReportFileFormat((ReportOutputFormat)format);
        for (Report report : this.getSelectedObjects()) {
            if (report.getFileFormat() != outputFormat) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReports(ReportPreferencesInterface reportPreferences) {
        TestDataReference testDataReference = ((Report)this.getFirstSelectedObject()).getReportGeneration().getTestDataReference();
        if (!TestDataReferenceController.create(testDataReference).databaseExists()) {
            return;
        }
        long testId = testDataReference.getId();
        Object object = StartReportLock;
        synchronized (object) {
            ReportGenerationJob reportGenerationJob = new ReportGenerationJob(testId, reportPreferences);
            boolean didAddJob = NewSingleReportAction.addJob(reportGenerationJob);
            if (didAddJob) {
                reportGenerationJob.addJobChangeListener((IJobChangeListener)new RemoveJobReference(testId));
                reportGenerationJob.schedule();
            }
        }
    }

    public void update() {
        List selectedReports = this.getSelectedObjects();
        if (selectedReports.size() != 1) {
            this.setEnabled(false);
            return;
        }
        Report selectedReport = (Report)this.getFirstSelectedObject();
        TestDataReference ref = selectedReport.getReportGeneration().getTestDataReference();
        TestDataReferenceController reader = TestDataReferenceController.create(ref);
        this.setEnabled(reader.databaseExists());
    }

    private static final class RemoveJobReference
    extends JobChangeAdapter {
        private final long testId;

        private RemoveJobReference(long testId) {
            this.testId = testId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            Object object = StartReportLock;
            synchronized (object) {
                NewSingleReportAction.removeJob(this.testId);
            }
        }
    }
}

