/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import com.excentis.products.byteblower.utils.zip.Zipper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class TestDataReferenceController {
    private static final Logger LOGGER = Logger.getGlobal();
    private TestDataReference ref;

    public TestDataReferenceController(TestDataReference ref) {
        this.ref = ref;
    }

    public static TestDataReferenceController create(TestDataReference ref) {
        return new TestDataReferenceController(ref);
    }

    public String getDatabaseLock() {
        return String.valueOf(this.getDatabaseBase()) + ".lock.db";
    }

    public String getDatabaseTrace() {
        return String.valueOf(this.getDatabaseBase()) + ".trace.db";
    }

    public String getDatabaseFile() {
        return String.valueOf(this.getDatabaseBase()) + ".mv.db";
    }

    private String getDatabaseBase() {
        String testResultsDatabase = this.ref.getPersistenceUrl();
        if (testResultsDatabase == null) {
            return null;
        }
        String deleteFiles = testResultsDatabase.replaceAll("jdbc:h2:file:", "");
        deleteFiles = deleteFiles.replaceAll(";USER=byteblower", "");
        deleteFiles = deleteFiles.replaceAll(";PASSWORD=excentis", "");
        deleteFiles = deleteFiles.replaceAll(";MODE=MySQL", "");
        deleteFiles = deleteFiles.replaceAll(";AUTO_SERVER=TRUE", "");
        return deleteFiles;
    }

    private static String getHome() {
        String home = System.getProperty("user.home");
        return home.replace("\\", "/");
    }

    public static File getFile(String fileUrl) {
        fileUrl = fileUrl.replaceFirst("^~", TestDataReferenceController.getHome());
        return new File(fileUrl);
    }

    public static boolean fileExists(String fileUrl) {
        return TestDataReferenceController.getFile(fileUrl).exists();
    }

    public void delete() {
        this.deleteDatabaseFiles();
        this.deleteAllReports();
    }

    private void deleteAllReports() {
        boolean didDeleteAll = true;
        for (ReportGeneration reportGeneration : this.ref.getReportGenerations()) {
            for (Report report : reportGeneration.getReports()) {
                File file = TestDataReferenceController.getFile(report.getFileUrl());
                try {
                    didDeleteAll = Files.deleteIfExists(file.toPath()) && didDeleteAll;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't delete file", e);
                }
            }
        }
        LOGGER.log(Level.INFO, "Deleted delete all" + didDeleteAll);
    }

    private void deleteDatabaseFiles() {
        TestDataReferenceController.deleteFile(this.getDatabaseFile());
        TestDataReferenceController.deleteFile(this.getDatabaseLock());
        TestDataReferenceController.deleteFile(this.getDatabaseTrace());
    }

    private static void deleteFile(String databaseFile) {
        TestDataReferenceController.getFile(databaseFile).delete();
    }

    public boolean filesExist() {
        return this.databaseFilesExist() || this.reportFilesExist();
    }

    private boolean reportFilesExist() {
        for (ReportGeneration reportGeneration : this.ref.getReportGenerations()) {
            for (Report report : reportGeneration.getReports()) {
                File file = TestDataReferenceController.getFile(report.getFileUrl());
                if (!file.exists()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean databaseFilesExist() {
        return TestDataReferenceController.fileExists(this.getDatabaseFile()) || TestDataReferenceController.fileExists(this.getDatabaseLock()) || TestDataReferenceController.fileExists(this.getDatabaseTrace());
    }

    public boolean databaseExists() {
        return TestDataReferenceController.fileExists(this.getDatabaseFile());
    }

    public static void exportReports(List<String> fileNames, Shell shell) {
        String exportZipFileName = TestDataReferenceController.openExportDialog(shell);
        if (exportZipFileName == null) {
            return;
        }
        File zipFile = new File(exportZipFileName);
        if (zipFile.exists() && !MessageDialog.openQuestion((Shell)shell, (String)"ByteBlower Report Export", (String)"Overwrite the existing zip file ?")) {
            return;
        }
        ByteBlowerPreferences.setExportDir((String)exportZipFileName);
        if (Zipper.zip(fileNames, (String)exportZipFileName)) {
            MessageDialog.openInformation((Shell)shell, (String)"ByteBlower Report Export", (String)"The reports were exported successfully.");
        } else {
            MessageDialog.openError((Shell)shell, (String)"ByteBlower Report Export", (String)"An error occurred while exporting the reports.");
        }
    }

    private static String openExportDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText("Export reports to this location");
        String zipFilename = "ByteBlower Reports.zip";
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFileName(zipFilename);
        return dialog.open();
    }

    public boolean reportExists(ReportFileFormat format) {
        if (format == null) {
            return false;
        }
        for (ReportGeneration generation : this.ref.getReportGenerations()) {
            for (Report report : generation.getReports()) {
                File file;
                if (report == null || !format.equals((Object)report.getFileFormat()) || !(file = new File(report.getFileUrl())).exists()) continue;
                return true;
            }
        }
        return false;
    }

    public String getReportUrl(ReportFileFormat format) {
        if (format == null) {
            return null;
        }
        ArrayList reversedGenerations = new ArrayList(this.ref.getReportGenerations());
        Collections.reverse(reversedGenerations);
        for (ReportGeneration generation : reversedGenerations) {
            ArrayList reversedReports = new ArrayList(generation.getReports());
            Collections.reverse(reversedReports);
            for (Report report : reversedReports) {
                File file;
                if (report == null || !format.equals((Object)report.getFileFormat()) || !(file = new File(report.getFileUrl())).exists()) continue;
                return report.getFileUrl();
            }
        }
        return null;
    }
}

