/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.batch.actions;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerRunTableComposite;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.BatchActionController;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;

public class NewBatch
extends ByteBlowerNewAction<Batch> {
    public NewBatch(ByteBlowerRunTableComposite<Batch> composite) {
        super("New Batch", composite);
    }

    protected void run(int amount) {
        Batch first = (Batch)this.composite.getFirstSelectedObject();
        ByteBlowerProjectController.CommandWithBatchListReference commandWithBatchListReference = this.getByteBlowerProjectController().addBatches(first == null ? null : first.getName(), amount, -1);
        ByteBlowerProjectController project = this.getByteBlowerProjectController();
        if (commandWithBatchListReference != null) {
            CompoundCommandController compound = CompoundCommandController.createInstance();
            compound.appendCommand(commandWithBatchListReference.getCommand());
            EList scenarios = project.getProject().getScenario();
            for (BatchController batch : (List)commandWithBatchListReference.getCommandReference()) {
                BatchController.CommandWithBatchActionListReference batchAction = batch.addBatchAction();
                compound.appendCommand(batchAction.getCommand());
                this.populateActions((List)batchAction.getCommandReference(), (EList<Scenario>)scenarios, project, compound);
            }
            UndoableByteBlowerControllerOperation operation = this.createOperation(amount > 1 ? "New Batches" : "New Batch", (Command)compound.getCompoundCommand());
            operation.run();
        }
    }

    private void populateActions(List<BatchActionController> actions, EList<Scenario> scenarios, ByteBlowerProjectController project, CompoundCommandController compound) {
        boolean obviousScenario;
        boolean bl = obviousScenario = scenarios.size() == 1;
        if (obviousScenario) {
            Scenario defaultscenario = (Scenario)scenarios.get(0);
            for (BatchActionController action : actions) {
                Command scenarioSet = action.setScenario(defaultscenario);
                compound.appendCommand(scenarioSet);
            }
        }
    }
}

