/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.batch.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.TimeCellEditor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.listeners.SimpleSelectionListener;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.UnFocusComboEditor;
import com.excentis.products.byteblower.gui.views.batch.BatchActionCellModifier;
import com.excentis.products.byteblower.gui.views.batch.actions.CopyBatchAction;
import com.excentis.products.byteblower.gui.views.batch.actions.CutBatchAction;
import com.excentis.products.byteblower.gui.views.batch.actions.DeleteBatchAction;
import com.excentis.products.byteblower.gui.views.batch.actions.NewBatchAction;
import com.excentis.products.byteblower.gui.views.batch.actions.PasteBatchAction;
import com.excentis.products.byteblower.gui.views.batch.composites.BatchActionComparator;
import com.excentis.products.byteblower.gui.views.batch.composites.BatchActionTableViewer;
import com.excentis.products.byteblower.gui.views.batch.composites.BatchComposite;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.BatchActionBlockController;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class BatchActionComposite
extends ByteBlowerAmountTableComposite<BatchAction> {
    private static final String[] COLUMN_NAMES = new String[]{"Pause Time", "Scenario", "Duration"};
    private static final int[] COLUMN_WEIGHTS = new int[]{1, 2, 1};
    private ChangeAdapter changeAdapter;
    private String[] scenarioNames = new String[0];
    private Scenario[] scenariosValues = new Scenario[0];
    private UnFocusComboEditor scenarioCellEditor;

    public BatchActionComposite(Composite parent, IByteBlowerAction byteBlowerAction, IByteBlowerFocusDispatcher focusDispatcher, BatchComposite batchComposite) {
        super(parent, "BatchActionComposite", byteBlowerAction, focusDispatcher, (ByteBlowerModelTableComposite)batchComposite);
        this.initializeChildClass();
        this.changeAdapter = new ChangeAdapter();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Batch currentBatch = (Batch)BatchActionComposite.this.getInput();
                if (currentBatch != null) {
                    BatchActionComposite.this.removeAdapter(currentBatch);
                }
            }
        });
    }

    protected TableViewer createTableViewer() {
        return new BatchActionTableViewer(this, this.getColumnNames(), this.getColumnWeights(), this.getViewedClass(), this.getParentClass(), this.getChildFeatureId());
    }

    private void updateScenarioData() {
        int count = 0;
        EList scenarios = null;
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        if (project != null && project != null) {
            scenarios = project.getScenario();
            count = scenarios.size();
        }
        this.scenarioNames = new String[count + 2];
        this.scenarioNames[0] = new String();
        this.scenarioNames[this.scenarioNames.length - 1] = "new Scenario...";
        this.scenariosValues = new Scenario[this.scenarioNames.length];
        if (scenarios != null) {
            int i = 1;
            for (Scenario scenario : scenarios) {
                this.scenarioNames[i] = scenario.getName();
                this.scenariosValues[i] = scenario;
                ++i;
            }
        }
    }

    public void updateScenarioCombo() {
        this.updateScenarioData();
        this.scenarioCellEditor.setItems(this.scenarioNames);
    }

    public void doJump() {
        ScenarioView.showAndSelect(((BatchAction)this.getFirstSelectedObject()).getScenario());
    }

    protected CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        Table table = this.getTable();
        editors[0] = new TimeCellEditor((Composite)table);
        this.updateScenarioData();
        this.scenarioCellEditor = new UnFocusComboEditor((Composite)table, this.scenarioNames, 8);
        this.scenarioCellEditor.setActivationStyle(1);
        this.scenarioCellEditor.addParentSelectionListener((SelectionListener)new SimpleSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BatchActionComposite.this.scenarioCellEditor.focusLost();
            }
        });
        editors[1] = this.scenarioCellEditor;
        editors[2] = null;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new BatchActionCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return COLUMN_WEIGHTS;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return Batch.class;
    }

    public int getChildFeatureId() {
        return 5;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return BatchAction.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        Batch currentBatch;
        Batch batch = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            batch = (Batch)selection.getFirstElement();
        }
        if (batch != (currentBatch = (Batch)this.getInput())) {
            if (currentBatch != null) {
                this.removeAdapter(currentBatch);
            }
            if (batch != null) {
                this.addAdapter(batch);
            }
            this.setInput(batch);
            this.updateWidgets();
        }
    }

    private void removeAdapter(Batch batch) {
        BatchController controller = ControllerFactory.create((Batch)batch);
        BatchActionBlockController blockController = controller.getFirstBatchActionBlockController();
        if (blockController != null) {
            blockController.removeAdapter((Adapter)this.changeAdapter);
        }
    }

    private void addAdapter(Batch batch) {
        BatchController controller = ControllerFactory.create((Batch)batch);
        BatchActionBlockController blockController = controller.getFirstBatchActionBlockController();
        if (blockController != null) {
            blockController.addAdapter((Adapter)this.changeAdapter);
        }
    }

    protected String getTableLabel() {
        return Messages.getString("BatchView.ScenarioAction.Label");
    }

    protected String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    private BatchAction getSelectedBatchAction() {
        return (BatchAction)this.getFirstSelectedObject();
    }

    public boolean isCopyDownEnabled() {
        BatchAction selectedObject = this.getSelectedBatchAction();
        if (selectedObject == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
            case 1: {
                return selectedObject.getScenario() != null;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        BatchAction selectedObject = this.getSelectedBatchAction();
        if (selectedObject == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
            case 1: {
                return selectedObject.getScenario() != null;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        BatchAction selectedObject = this.getSelectedBatchAction();
        if (selectedObject == null) {
            return false;
        }
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return selectedObject.getScenario() != null;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean isJumpEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public Object getInitialInput() {
        return null;
    }

    protected ByteBlowerNewAction<BatchAction> createNewAction() {
        return new NewBatchAction(this);
    }

    protected ByteBlowerCutAction<BatchAction> createCutAction() {
        return new CutBatchAction(this);
    }

    protected ByteBlowerCopyAction<BatchAction> createCopyAction() {
        return new CopyBatchAction(this);
    }

    protected ByteBlowerPasteAction<BatchAction> createPasteAction() {
        return new PasteBatchAction(this);
    }

    protected ByteBlowerDeleteAction<BatchAction> createDeleteAction() {
        return new DeleteBatchAction(this);
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.resetInput();
    }

    public boolean isNewScenario(int index) {
        return this.scenarioNames.length - 1 == index;
    }

    public Scenario getScenario(int index) {
        if (index >= 0 && index < this.scenariosValues.length) {
            return this.scenariosValues[index];
        }
        return null;
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new BatchActionComparator(columnViewer);
    }

    public boolean isSolutionEnabled() {
        BatchAction measurement = (BatchAction)this.getFirstSelectedObject();
        BatchActionBlock block = measurement.getBatchActionBlock();
        BatchReader reader = ReaderFactory.create((Batch)block.getBatch());
        return !reader.getAllStatuses().isEmpty();
    }

    private class ChangeAdapter
    implements Adapter {
        private ChangeAdapter() {
        }

        public void notifyChanged(Notification msg) {
            BatchActionComposite.this.hardRefresh();
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }
}

