/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.dhcp;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerCellModifier;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpComposite;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.TableItem;

class DhcpCellModifier
extends ByteBlowerCellModifier {
    public DhcpCellModifier(DhcpComposite dhcpComposite) {
        super((ByteBlowerModelTableComposite<?>)dhcpComposite);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.getColumnIndex(property);
        Dhcp dhcp = (Dhcp)element;
        switch (columnIndex) {
            case 0: {
                return dhcp.getName();
            }
            case 2: {
                return dhcp.getMaximumDiscoverRetries();
            }
            case 1: {
                return dhcp.getInitialDiscoverTimeout();
            }
            case 4: {
                return dhcp.getMaximumRequestRetries();
            }
            case 3: {
                return dhcp.getInitialRequestTimeout();
            }
            case 5: {
                return dhcp.getRetransmissionPolicy();
            }
        }
        System.err.println("DhcpItemProvider#getValue() : invalid case !");
        return null;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.getColumnIndex(property);
        TableItem item = (TableItem)element;
        Dhcp dhcp = (Dhcp)item.getData();
        if (value == null) {
            return;
        }
        DhcpController controller = ControllerFactory.create((Dhcp)dhcp);
        ByteBlowerSetOperation operation = null;
        switch (columnIndex) {
            case 0: {
                String newName = ((String)value).trim();
                if (!OldNamingTools.nameIsUnique((EObject)dhcp, (String)newName)) break;
                operation = new ByteBlowerSetOperation("Change Dhcp Name", (EByteBlowerObject)dhcp, controller.setName(newName));
                break;
            }
            case 2: {
                Integer intValue = (Integer)value;
                operation = new ByteBlowerSetOperation("Change DHCP Maximum Discover Retries", (EByteBlowerObject)dhcp, controller.setMaximumDiscoverRetries(intValue));
                break;
            }
            case 1: {
                HighResolutionCalendar timeout = (HighResolutionCalendar)value;
                operation = new ByteBlowerSetOperation("Change DHCP Initial Discover Timeout", (EByteBlowerObject)dhcp, controller.setInitialDiscoverTimeout(timeout));
                break;
            }
            case 4: {
                Integer intValue = (Integer)value;
                operation = new ByteBlowerSetOperation("Change DHCP Maximum Request Retries", (EByteBlowerObject)dhcp, controller.setMaximumRequestRetries(intValue));
                break;
            }
            case 3: {
                HighResolutionCalendar timeout = (HighResolutionCalendar)value;
                operation = new ByteBlowerSetOperation("Change DHCP Initial Request Timeout", (EByteBlowerObject)dhcp, controller.setInitialRequestTimeout(timeout));
                break;
            }
            case 5: {
                RetransmissionPolicy policy = (RetransmissionPolicy)value;
                operation = new ByteBlowerSetOperation("Change DHCP Retransmission Policy", (EByteBlowerObject)dhcp, controller.setRetransmissionPolicy(policy));
                break;
            }
            default: {
                return;
            }
        }
        if (operation != null) {
            operation.run();
        }
    }
}

