/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.flow.StyleBuilder;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.BenchmarkFrame;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.reader.AddressableDestinationReader;
import com.excentis.products.byteblower.model.reader.AddressableSourceReader;
import com.excentis.products.byteblower.model.reader.BroadcastReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.FlowTemplateReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.UnicastReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFlowReaderImpl;
import com.excentis.products.byteblower.utils.Pair;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

class FlowSettingsText
extends Composite {
    private StyledText settingsText;
    private Flow flow;
    private final ChangeAdapter changeAdapter = new ChangeAdapter();

    public FlowSettingsText(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.settingsText = new StyledText((Composite)this, 778);
        this.settingsText.setBackground(this.getBackground());
        this.setLayout((Layout)new GridLayout());
        this.settingsText.setLayoutData((Object)new GridData(1808));
    }

    public void setFlow(Flow flow) {
        if (flow != this.flow) {
            if (this.flow != null) {
                this.flow.eAdapters().remove((Object)this.changeAdapter);
            }
            if (flow != null) {
                flow.eAdapters().add((Object)this.changeAdapter);
            }
            this.flow = flow;
            this.updateText();
        }
    }

    private void updateText() {
        if (this.settingsText.isDisposed()) {
            return;
        }
        if (this.flow == null || this.flow.eContainer() == null) {
            this.settingsText.setText("");
        } else {
            StyleBuilder builder = this.prepareFlowDescription();
            builder.styleText(this.settingsText);
        }
    }

    private StyleBuilder prepareFlowDescription() {
        StyleBuilder builder = new StyleBuilder();
        this.prepareFlowTemplate(builder);
        this.prepareSource(builder);
        this.prepareDestination(builder);
        this.prepareEavesDroppers(builder);
        return builder;
    }

    private static void doSubTitle(StyleBuilder builder, String key) {
        builder.startTitle();
        builder.addText(Messages.getString(key));
        builder.endStyle();
    }

    private static void fillDescription(FrameBlastingFlow flowTemplate, ArrayList<Pair<String, String>> settingsDescription) {
        FrameBlastingFlowReaderImpl reader = new FrameBlastingFlowReaderImpl(flowTemplate);
        DataRateUnit dataUnit = reader.getDataRateUnit();
        String throughputDesc = String.valueOf(reader.getThroughputString(dataUnit)) + " " + dataUnit;
        settingsDescription.add((Pair<String, String>)new Pair((Object)"Throughput", (Object)throughputDesc));
    }

    private static void fillDescription(FrameBlastingBenchmark fbBenchmark, ArrayList<Pair<String, String>> settingsDescription) {
        settingsDescription.add((Pair<String, String>)new Pair((Object)"Acceptable loss", (Object)String.format("%.1f %%", 100.0 * fbBenchmark.getAcceptableLoss())));
        StringBuilder frameBuilder = new StringBuilder();
        String seperator = "";
        for (BenchmarkFrame frame : fbBenchmark.getFrames()) {
            frameBuilder.append(seperator);
            frameBuilder.append(frame.getSize());
            seperator = ", ";
        }
        frameBuilder.append(" bytes");
        settingsDescription.add((Pair<String, String>)new Pair((Object)"Frame sizes", (Object)frameBuilder.toString()));
    }

    private static void fillDescription(TcpFlow flowTemplate, ArrayList<Pair<String, String>> settingsDescription) {
        TcpFlowReader reader = ReaderFactory.create((TcpFlow)flowTemplate);
        if (reader.isTimeBased()) {
            settingsDescription.add((Pair<String, String>)new Pair((Object)"Duration", (Object)"Time Based"));
        } else {
            settingsDescription.add((Pair<String, String>)new Pair((Object)"Duration", (Object)"Payload Based"));
        }
        settingsDescription.add((Pair<String, String>)new Pair((Object)"Automatic Restart", (Object)(reader.getProjectReader().isAutomaticTcpRestart() ? "On" : "Off")));
        if ((double)flowTemplate.getRateLimit() != 0.0) {
            String ratelimitDesc = String.format("%.02f %s", Float.valueOf(flowTemplate.getRateLimit()), flowTemplate.getRateLimitUnit());
            settingsDescription.add((Pair<String, String>)new Pair((Object)"Rate Limit", (Object)ratelimitDesc));
        }
    }

    private void prepareFlowTemplate(StyleBuilder builder) {
        String flowTemplateTypeName;
        String flowTemplateName;
        FlowSettingsText.doSubTitle(builder, "FlowView.Settings.FlowTemplate");
        builder.addNewline();
        FlowTemplate flowTemplate = this.flow.getFlowTemplate();
        ArrayList<Pair<String, String>> settingsDescription = new ArrayList<Pair<String, String>>();
        if (flowTemplate == null) {
            flowTemplateName = "";
            flowTemplateTypeName = Messages.getString("FlowView.Settings.ObjectDeleted");
        } else {
            flowTemplateName = flowTemplate.getName();
            if (flowTemplate instanceof TcpFlow) {
                flowTemplateTypeName = Messages.getString("FlowView.Settings.FlowTemplateType_Tcp");
                FlowSettingsText.fillDescription((TcpFlow)flowTemplate, settingsDescription);
            } else if (flowTemplate instanceof FrameBlastingFlow) {
                flowTemplateTypeName = Messages.getString("FlowView.Settings.FlowTemplateType_FrameBlasting");
                FlowSettingsText.fillDescription((FrameBlastingFlow)flowTemplate, settingsDescription);
            } else if (flowTemplate instanceof FrameBlastingBenchmark) {
                flowTemplateTypeName = "Benchmark";
                FlowSettingsText.fillDescription((FrameBlastingBenchmark)flowTemplate, settingsDescription);
            } else {
                flowTemplateTypeName = Messages.getString("FlowView.Settings.Unsupported");
            }
        }
        boolean flowTemplateError = false;
        if (!flowTemplateName.isEmpty()) {
            builder.addText(String.valueOf(Messages.getString("FlowView.Settings.FlowTemplateName")) + " ");
            FlowTemplateReader reader = ReaderFactory.create((FlowTemplate)flowTemplate);
            flowTemplateError = reader.hasErrorStatus();
            if (flowTemplateError) {
                builder.startError();
            } else {
                builder.startNormalBold();
            }
            builder.addText(flowTemplateName);
            builder.addNewline();
            builder.endStyle();
            builder.addText(String.valueOf(Messages.getString("FlowView.Settings.FlowTemplateType")) + " ");
        }
        if (flowTemplateError || flowTemplateName.isEmpty()) {
            builder.startError();
        } else {
            builder.startNormalBold();
        }
        builder.addText(flowTemplateTypeName);
        builder.endStyle();
        builder.addNewline();
        for (Pair<String, String> entry : settingsDescription) {
            builder.addText((String)entry.getFirst());
            builder.addText(" : ");
            builder.startNormalBold();
            builder.addText((String)entry.getSecond());
            builder.endStyle();
            builder.addNewline();
        }
        builder.addNewline();
    }

    private void prepareSource(StyleBuilder builder) {
        String sourceDescription;
        String sourceType;
        String byteBlowerPort = Messages.getString("FlowView.Settings.Port");
        FlowSettingsText.doSubTitle(builder, "FlowView.Settings.Source");
        builder.addNewline();
        AddressableSource addressableSource = this.flow.getSource();
        if (addressableSource == null) {
            sourceType = "";
            sourceDescription = Messages.getString("FlowView.Settings.ObjectDeleted");
        } else if (addressableSource instanceof ByteBlowerGuiPort) {
            sourceType = byteBlowerPort;
            sourceDescription = ((ByteBlowerGuiPort)addressableSource).getName();
        } else {
            sourceType = "";
            sourceDescription = Messages.getString("FlowView.Settings.Unsupported");
        }
        if (!sourceType.isEmpty()) {
            builder.addText(String.valueOf(sourceType) + ": ");
        }
        AddressableSourceReader sourceReader = ReaderFactory.create((AddressableSource)addressableSource);
        if (sourceType.isEmpty() || sourceReader.hasErrorStatus()) {
            builder.startError();
        } else {
            builder.startNormalBold();
        }
        builder.addText(sourceDescription);
        builder.endStyle();
    }

    private void prepareDestination(StyleBuilder builder) {
        String destinationDescription;
        String destinationType;
        builder.addNewline();
        builder.addNewline();
        FlowSettingsText.doSubTitle(builder, "FlowView.Settings.Destination");
        builder.addNewline();
        AddressableDestination addressableDestination = this.flow.getDestination();
        AddressableDestinationReader destReader = ReaderFactory.create((AddressableDestination)addressableDestination);
        if (addressableDestination == null) {
            destinationType = "";
            destinationDescription = Messages.getString("FlowView.Settings.ObjectDeleted");
        } else if (addressableDestination instanceof ByteBlowerGuiPort) {
            destinationType = Messages.getString("FlowView.Settings.Port");
            destinationDescription = ((ByteBlowerGuiPort)addressableDestination).getName();
        } else if (addressableDestination instanceof MulticastGroup) {
            destinationType = Messages.getString("FlowView.Settings.Multicast");
            destinationDescription = ((MulticastGroup)addressableDestination).getName();
        } else if (addressableDestination instanceof Broadcast) {
            destinationType = Messages.getString("FlowView.Settings.Broadcast");
            Broadcast broadcast = (Broadcast)addressableDestination;
            BroadcastReader broadCastReader = ReaderFactory.create((Broadcast)broadcast);
            destinationDescription = broadCastReader.getAddress();
        } else if (addressableDestination instanceof Unicast) {
            destinationType = Messages.getString("FlowView.Settings.Unicast");
            Unicast unicast = (Unicast)addressableDestination;
            UnicastReader unicastReader = ReaderFactory.create((Unicast)unicast);
            destinationDescription = unicastReader.getAddress();
        } else if (addressableDestination instanceof ByteBlowerPortGroup) {
            destinationType = Messages.getString("FlowView.Settings.PortGroup");
            destinationDescription = this.describe((ByteBlowerPortGroup)addressableDestination);
        } else {
            destinationType = "";
            destinationDescription = Messages.getString("FlowView.Settings.Unsupported");
        }
        if (!destinationType.isEmpty()) {
            builder.addText(String.valueOf(destinationType) + ": ");
        }
        if (destinationType.isEmpty() || destReader.hasErrorStatus()) {
            builder.startError();
        } else {
            builder.startNormalBold();
        }
        builder.addText(destinationDescription);
        builder.endStyle();
    }

    private String describe(ByteBlowerPortGroup group) {
        StringBuilder builder = new StringBuilder();
        builder.append(group.getName());
        builder.append("\n");
        builder.append("Members: \n");
        String seperator = "\t";
        for (ByteBlowerGuiPort port : group.getMembers()) {
            builder.append(seperator);
            builder.append(port.getName());
            seperator = "\n\t";
        }
        return builder.toString();
    }

    private void prepareEavesDroppers(StyleBuilder builder) {
        EList eavesDroppers = this.flow.getByteBlowerGuiPort();
        FlowTemplate flowTemplate = this.flow.getFlowTemplate();
        builder.addNewline();
        builder.addNewline();
        FlowSettingsText.doSubTitle(builder, "FlowView.Settings.EavesDroppers");
        builder.addNewline();
        AddressableDestination addressableDestination = this.flow.getDestination();
        if (eavesDroppers.isEmpty()) {
            builder.addText(Messages.getString("FlowView.Settings.EavesDroppers_None"));
        } else if (flowTemplate instanceof TcpFlow) {
            builder.startError();
            builder.addText("not allowed for TCP Flows:\r\n");
            builder.endStyle();
        } else if (addressableDestination instanceof Broadcast) {
            builder.startError();
            builder.addText("not allowed when Broadcasting:\r\n");
            builder.endStyle();
        } else {
            FlowReader flowReader = ReaderFactory.create((Flow)this.flow);
            for (ByteBlowerGuiPort eavesDropper : eavesDroppers) {
                if (flowReader.hasErrorInEavesDropper(eavesDropper)) {
                    builder.startError();
                } else {
                    builder.startNormalBold();
                }
                builder.addText(String.valueOf(eavesDropper.getName()) + "\r\n");
                builder.endStyle();
            }
        }
    }

    private class ChangeAdapter
    implements Adapter {
        private ChangeAdapter() {
        }

        public void notifyChanged(Notification msg) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FlowSettingsText.this.isDisposed()) {
                        FlowSettingsText.this.updateText();
                    }
                }
            });
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }
}

