/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.swt.listeners.SimpleSelectionListener;
import com.excentis.products.byteblower.gui.views.UnFocusComboEditor;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyDescription;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyPortDescription;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class FlowSourcePortEditor
extends UnFocusComboEditor {
    private final List<UserFriendlyPortDescription> ports;

    public FlowSourcePortEditor(Composite composite) {
        super(composite, new String[0], 0);
        this.setActivationStyle(1);
        this.addParentSelectionListener((SelectionListener)new SimpleSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object value = FlowSourcePortEditor.this.getValue();
                if (value instanceof UserFriendlyDescription && ((UserFriendlyDescription)value).isCreation()) {
                    FlowSourcePortEditor.this.focusLost();
                }
            }
        });
        this.ports = new ArrayList<UserFriendlyPortDescription>();
        this.populatePorts();
    }

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        return control;
    }

    private void populatePorts() {
        ProjectSwitchNotifier projectNotifier = ProjectSwitchNotifier.getInstance();
        ByteBlowerProject currentProject = projectNotifier.getCurrentProject();
        this.ports.clear();
        if (currentProject != null) {
            EList configPorts = currentProject.getByteBlowerGuiPort();
            for (ByteBlowerGuiPort port : configPorts) {
                this.ports.add(new UserFriendlyPortDescription(port));
            }
            this.ports.add(new UserFriendlyPortDescription.PortIPv4Create());
            this.ports.add(new UserFriendlyPortDescription.PortIPv6Create());
        }
    }

    protected Object doGetValue() {
        Object superValue = super.doGetValue();
        int nPorts = this.ports.size();
        int index = (Integer)superValue;
        if (index >= 0 && index < nPorts) {
            UserFriendlyPortDescription desc = this.ports.get(index);
            if (desc.isCreation()) {
                return desc;
            }
            return this.ports.get(index).get();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        this.populatePorts();
        String[] names = new String[this.ports.size()];
        int ctr = 0;
        while (ctr < this.ports.size()) {
            names[ctr] = this.ports.get(ctr).toString();
            ++ctr;
        }
        this.setItems(names);
    }
}

