/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.swt.listeners.SimpleSelectionListener;
import com.excentis.products.byteblower.gui.views.UnFocusComboEditor;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

class FlowTemplateEditor
extends UnFocusComboEditor {
    private final List<UserFriendlyTemplateDescription> templates;

    public FlowTemplateEditor(Composite composite) {
        super(composite, new String[0], 0);
        this.setActivationStyle(1);
        this.templates = new ArrayList<UserFriendlyTemplateDescription>();
        this.addParentSelectionListener((SelectionListener)new SimpleSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserFriendlyTemplateDescription desc = (UserFriendlyTemplateDescription)FlowTemplateEditor.this.getValue();
                if (desc != null && desc.isCreate()) {
                    FlowTemplateEditor.this.focusLost();
                }
            }
        });
        this.populateTemplates();
    }

    private void populateTemplates() {
        ProjectSwitchNotifier projectNotifier = ProjectSwitchNotifier.getInstance();
        ByteBlowerProject currentProject = projectNotifier.getCurrentProject();
        this.templates.clear();
        if (currentProject != null) {
            EList configTemplates = currentProject.getFlowTemplate();
            for (FlowTemplate flow : configTemplates) {
                if (!UserFriendlyTemplateDescription.isKnown(flow)) continue;
                this.templates.add(new UserFriendlyTemplateDescription(flow));
            }
            this.templates.add(UserFriendlyTemplateDescription.createNewFB());
            this.templates.add(UserFriendlyTemplateDescription.createNewTCP());
            Collections.sort(this.templates);
        }
        if (this.templates.isEmpty()) {
            this.templates.add(UserFriendlyTemplateDescription.empty());
        }
    }

    protected Object doGetValue() {
        Object superValue = super.doGetValue();
        int index = (Integer)superValue;
        if (index >= 0 && index < this.templates.size()) {
            return this.templates.get(index);
        }
        return null;
    }

    protected void doSetValue(Object value) {
        this.populateTemplates();
        String[] names = new String[this.templates.size()];
        int ctr = 0;
        while (ctr < names.length) {
            names[ctr] = this.templates.get(ctr).toString();
            ++ctr;
        }
        this.setItems(names);
    }

    protected static class UserFriendlyTemplateDescription
    implements Comparable<UserFriendlyTemplateDescription> {
        private final FlowTemplate template;

        private static boolean isKnown(FlowTemplate flow) {
            return flow instanceof TcpFlow || flow instanceof FrameBlastingFlow || flow instanceof FrameBlastingBenchmark;
        }

        private static UserFriendlyTemplateDescription empty() {
            return new UserFriendlyTemplateDescription(null){

                @Override
                public String toString() {
                    return "No flow templates configured";
                }
            };
        }

        private static UserFriendlyTemplateDescription createNewTCP() {
            ClassLoader loader = UserFriendlyTemplateDescription.class.getClassLoader();
            Class[] tcpInterface = new Class[]{TcpFlow.class};
            FlowTemplate emptyFlow = (FlowTemplate)Proxy.newProxyInstance(loader, tcpInterface, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
            return new UserFriendlyTemplateDescription(emptyFlow){

                @Override
                public boolean isCreate() {
                    return true;
                }

                @Override
                public String toString() {
                    return "New TCP...";
                }
            };
        }

        private static UserFriendlyTemplateDescription createNewFB() {
            ClassLoader loader = UserFriendlyTemplateDescription.class.getClassLoader();
            Class[] fbInterface = new Class[]{FrameBlastingFlow.class};
            FlowTemplate emptyFlow = (FlowTemplate)Proxy.newProxyInstance(loader, fbInterface, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
            return new UserFriendlyTemplateDescription(emptyFlow){

                @Override
                public boolean isCreate() {
                    return true;
                }

                @Override
                public String toString() {
                    return "New Frame Blasting...";
                }
            };
        }

        private UserFriendlyTemplateDescription(FlowTemplate template) {
            this.template = template;
        }

        public FlowTemplate getTemplate() {
            return this.template;
        }

        public boolean isCreate() {
            return false;
        }

        public String toString() {
            String typeHint = this.template instanceof FrameBlastingFlow ? "[FB] " : (this.template instanceof TcpFlow ? "[TCP]" : (this.template instanceof FrameBlastingBenchmark ? "[BENCH]" : ""));
            return String.valueOf(typeHint) + " " + this.template.getName();
        }

        private int valueForType(FlowTemplate template) {
            if (template instanceof FrameBlastingFlow) {
                return 0;
            }
            if (template instanceof TcpFlow) {
                return 1;
            }
            return 2;
        }

        @Override
        public int compareTo(UserFriendlyTemplateDescription other) {
            return Integer.compare(this.valueForType(this.template), this.valueForType(other.template));
        }
    }
}

