/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;

class StyleBuilder {
    private final StringBuilder text = new StringBuilder();
    private final ArrayList<StyleRange> styles = new ArrayList();
    private StyleRange lastStyle = new StyleRange();

    StyleBuilder() {
    }

    public void addText(String newTxt) {
        this.text.append(newTxt);
    }

    public void addNewline() {
        this.text.append("\r\n");
    }

    public StyleRange startStyle(int code, Color color) {
        this.lastStyle = new StyleRange();
        this.lastStyle.fontStyle = code;
        this.lastStyle.foreground = color;
        this.lastStyle.start = this.text.length();
        return this.lastStyle;
    }

    public StyleRange endStyle() {
        if (this.lastStyle == null) {
            return new StyleRange();
        }
        StyleRange older = this.lastStyle;
        this.lastStyle.length = this.text.length() - this.lastStyle.start;
        this.styles.add(this.lastStyle);
        this.lastStyle = null;
        return older;
    }

    public StyleRange startTitle() {
        return this.startStyle(1, ExcentisColors.blue);
    }

    public StyleRange startError() {
        return this.startStyle(1, ExcentisColors.red);
    }

    public StyleRange startNormalBold() {
        return this.startStyle(1, null);
    }

    public void styleText(StyledText txt) {
        txt.setText(this.text.toString());
        for (StyleRange range : this.styles) {
            txt.setStyleRange(range);
        }
    }
}

