/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.IntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameCellModifier;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frame.actions.CopyFrameAction;
import com.excentis.products.byteblower.gui.views.frame.actions.CutFrameAction;
import com.excentis.products.byteblower.gui.views.frame.actions.DeleteFrameAction;
import com.excentis.products.byteblower.gui.views.frame.actions.NewFrameAction;
import com.excentis.products.byteblower.gui.views.frame.actions.PasteFrameAction;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Frame;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

class FrameOverviewControl
extends ByteBlowerAmountTableComposite<Frame> {
    private static final String[] COLUMN_NAMES = new String[]{Messages.getString("FrameView.Column.FrameName"), Messages.getString("FrameView.Column.FrameSize"), Messages.getString("FrameView.Column.FrameType")};
    private static final int[] COLUMN_WEIGHTS = new int[]{2, 1, 1};
    private FrameView frameView = null;

    public FrameOverviewControl(Composite parent, FrameView frameView) {
        super(parent, "FrameOverviewControl", (IByteBlowerAction)frameView, (IByteBlowerFocusDispatcher)frameView);
        this.frameView = frameView;
        this.initializeChildClass();
        this.addSelectionListener((IByteBlowerComposite)this);
    }

    public void viewerSelectionChanged(SelectionChangedEvent event) {
        Frame selectedFrame = null;
        if (event == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            selectedFrame = (Frame)selection.getFirstElement();
        }
        this.frameView.setSelectedFrame(selectedFrame);
        super.viewerSelectionChanged(event);
    }

    public boolean isCopyDownIncEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Frame.class;
    }

    public int getChildFeatureId() {
        return 9;
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    protected String getTableLabel() {
        return Messages.getString("FrameView.Overview.Label");
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        editors[0] = new NameCellEditor((Composite)table);
        editors[1] = new IntegerCellEditor((Composite)table, Integer.valueOf(8192), Integer.valueOf(60));
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new FrameCellModifier(this);
    }

    protected String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    protected ByteBlowerNewAction<Frame> createNewAction() {
        return new NewFrameAction(this);
    }

    protected ByteBlowerCutAction<Frame> createCutAction() {
        return new CutFrameAction(this);
    }

    protected ByteBlowerCopyAction<Frame> createCopyAction() {
        return new CopyFrameAction(this);
    }

    protected ByteBlowerPasteAction<Frame> createPasteAction() {
        return new PasteFrameAction(this);
    }

    protected ByteBlowerDeleteAction<Frame> createDeleteAction() {
        return new DeleteFrameAction(this);
    }

    protected int[] getColumnWeights() {
        return COLUMN_WEIGHTS;
    }
}

