/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frameblasting;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frameblasting.FramesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingFrameController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

class FrameCellModifier
implements ICellModifier {
    private FramesComposite framesComposite;

    public FrameCellModifier(FramesComposite framesComposite) {
        this.framesComposite = framesComposite;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.framesComposite.getColumnIndex(property);
        switch (columnIndex) {
            case 2: {
                FrameBlastingFrame frameBlastingFrame = (FrameBlastingFrame)element;
                FrameBlastingFrameReader reader = ReaderFactory.create((FrameBlastingFrame)frameBlastingFrame);
                int siblings = reader.getNofSiblings();
                if (siblings >= 1) break;
                return false;
            }
            case 1: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        FrameBlastingFrame frameBlastingFrame = (FrameBlastingFrame)element;
        int columnIndex = this.framesComposite.getColumnIndex(property);
        switch (columnIndex) {
            case 0: {
                return frameBlastingFrame.getFrame();
            }
            case 2: {
                return frameBlastingFrame.getWeight();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        TableItem item = (TableItem)element;
        if (item == null) {
            return;
        }
        int columnIndex = this.framesComposite.getColumnIndex(property);
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        UndoableByteBlowerOperation operation = null;
        FrameBlastingFrame frameBlastingFrame = (FrameBlastingFrame)item.getData();
        FrameBlastingFrameController controller = ControllerFactory.create((FrameBlastingFrame)frameBlastingFrame);
        switch (columnIndex) {
            case 0: {
                if (value == "New Frame...") {
                    operation = this.createNewFrame(controller);
                    break;
                }
                Frame newFrame = value == "" ? null : (Frame)value;
                operation = new ByteBlowerSetOperation(project, "Change Frame");
                operation.appendCommand(controller.setFrame(newFrame));
                break;
            }
            case 2: {
                Integer newWeight = (Integer)value;
                operation = new ByteBlowerSetOperation(project, "Change Weight");
                operation.appendCommand(controller.setWeight(newWeight));
            }
        }
        if (operation != null) {
            operation.run();
        }
    }

    private UndoableByteBlowerOperation createNewFrame(FrameBlastingFrameController frameBlastingFrameController) {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithFrameListReference commandWithFrameListReference = projectController.addFrame();
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(commandWithFrameListReference.getCommand());
        final Frame newFrame = (Frame)((FrameController)((List)commandWithFrameListReference.getCommandReference()).get(0)).getObject();
        compoundController.appendCommand(frameBlastingFrameController.setFrame(newFrame));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New Frame", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FrameView.showAndSelect(newFrame);
            }
        });
        return operation;
    }
}

