/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AddDataDialog
extends Dialog {
    private int[] result = null;
    private Shell dialog;
    private int type;
    private Text dataSizeText;
    private Text dataValueText;
    private Combo sizeCombo;

    public AddDataDialog(Shell parent, int style, int type) {
        super(parent, style);
        this.type = type;
    }

    public int[] open() {
        this.dialog = new Shell(this.getParent(), this.getStyle());
        this.dialog.setText(this.getText());
        this.dialog.setLayout((Layout)new GridLayout());
        Composite sizePanel = new Composite((Composite)this.dialog, 0);
        GridLayout sizeGrid = new GridLayout();
        sizeGrid.numColumns = 3;
        sizePanel.setLayout((Layout)sizeGrid);
        sizePanel.setLayoutData((Object)new GridData(32));
        Label label = new Label(sizePanel, 0);
        label.setText("Amount of data to " + (this.type == 1 ? "insert:" : "append:"));
        label.setLayoutData((Object)new GridData(768));
        this.dataSizeText = new Text(sizePanel, 2052);
        this.dataSizeText.setTextLimit(8);
        this.dataSizeText.setText("1");
        this.dataSizeText.selectAll();
        this.dataSizeText.setFocus();
        GridData data = new GridData(768);
        data.widthHint = 50;
        this.dataSizeText.setLayoutData((Object)data);
        this.sizeCombo = new Combo(sizePanel, 2060);
        this.sizeCombo.add("B");
        this.sizeCombo.add("kB");
        this.sizeCombo.select(0);
        label = new Label(sizePanel, 0);
        label.setText("Initial hex value:");
        label.setLayoutData((Object)new GridData(768));
        this.dataValueText = new Text(sizePanel, 2052);
        this.dataValueText.setTextLimit(2);
        this.dataValueText.setText("00");
        this.dataValueText.selectAll();
        Composite buttonPanel = new Composite((Composite)this.dialog, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        buttonPanel.setLayout((Layout)grid);
        buttonPanel.setLayoutData((Object)new GridData(128));
        Button ok = new Button(buttonPanel, 8);
        ok.setText("OK");
        data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sDataSize = AddDataDialog.this.dataSizeText.getText().trim();
                String sDataValue = AddDataDialog.this.dataValueText.getText().trim();
                int iDataSize = 0;
                int iDataValue = 0;
                try {
                    iDataSize = Integer.parseInt(sDataSize, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)AddDataDialog.this.getParent().getShell(), (String)"Frame Error", (String)"Amount of data: Incorrect number format!");
                    AddDataDialog.this.dialog.dispose();
                    return;
                }
                if (iDataSize < 0) {
                    MessageDialog.openError((Shell)AddDataDialog.this.getParent().getShell(), (String)"Frame Error", (String)"Amount of data cannot be negative!");
                    AddDataDialog.this.dialog.dispose();
                    return;
                }
                try {
                    iDataValue = Integer.parseInt(sDataValue, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)AddDataDialog.this.getParent().getShell(), (String)"Frame Error", (String)"Initial hex value: Incorrect number format!");
                    AddDataDialog.this.dialog.dispose();
                    return;
                }
                AddDataDialog.this.result = new int[2];
                AddDataDialog.this.result[0] = (int)((double)iDataSize * Math.pow(1024.0, AddDataDialog.this.sizeCombo.getSelectionIndex()));
                AddDataDialog.this.result[1] = iDataValue;
                AddDataDialog.this.dialog.dispose();
            }
        });
        Button cancel = new Button(buttonPanel, 8);
        cancel.setText("Cancel");
        data = new GridData();
        data.widthHint = 75;
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddDataDialog.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(ok);
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.result;
    }
}

