/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.views.hex.gui.HexEditorControl;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableBuffer;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableItem;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTablePointer;
import com.excentis.products.byteblower.gui.views.hex.gui.events.CellEditorKeyListener;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class HexTable
extends Composite {
    private static final HexTableItem[] EMPTY_ITEMS = new HexTableItem[0];
    private Table table;
    private HexTableItem[] items = EMPTY_ITEMS;
    private HexEditorControl hexEditorControl;
    private boolean inDispose = false;
    private static int index = 0;
    private static final int OFFSET_COLUMN_MIN_WIDTH = 80;
    private static final int DATA_COLUMN_MIN_WIDTH = 27;

    HexTable(HexEditorControl hexEditorControl, int style) {
        super((Composite)hexEditorControl, 0);
        this.hexEditorControl = hexEditorControl;
        this.table = new Table((Composite)this, style);
        this.setBackground(this.table.getBackground());
        this.setForeground(this.table.getForeground());
        this.setFont(this.table.getFont());
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                HexTable.this.onResize();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                HexTable.this.onFocusIn();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                HexTable.this.onFocusOut();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                HexTable.this.onDispose();
            }
        });
    }

    public HexEditorControl getHexEditorControl() {
        return this.hexEditorControl;
    }

    void reset() {
        this.remove(0);
        this.resetIndex();
    }

    void resetIndex() {
        index = 0;
    }

    int addItem(HexTableItem item) {
        return this.addItem(item, this.items.length);
    }

    private int addItem(HexTableItem item, int index) {
        if (index < 0 || index > this.items.length) {
            throw new SWTError(5);
        }
        HexTableItem[] newItems = new HexTableItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        if (index == this.items.length - 1) {
            return this.table.getItemCount();
        }
        return this.table.indexOf(this.items[index + 1].getItem());
    }

    public HexTableItem getItem(int index) {
        TableItem tableItem;
        if (index < 0) {
            return null;
        }
        if (index == this.getItemCount()) {
            this.addDummyItem();
        }
        if ((tableItem = this.table.getItem(index)) == null) {
            return null;
        }
        return this.getItem(tableItem);
    }

    public HexTableItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        int i = 0;
        while (i < this.items.length) {
            HexTableItem item = this.items[i].getItem(tableItem);
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void remove(int indexBegin) {
        if (indexBegin >= this.items.length) {
            return;
        }
        this.table.remove(indexBegin, this.items.length - 1);
        int i = indexBegin;
        while (i < this.items.length) {
            this.items[i].dispose();
            ++i;
        }
        HexTableItem[] newItems = new HexTableItem[this.table.getItemCount()];
        System.arraycopy(this.items, 0, newItems, 0, this.table.getItemCount());
        this.items = newItems;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.table.setFont(font);
    }

    public void setHeaderVisible(boolean show) {
        this.table.setHeaderVisible(show);
    }

    public void setLinesVisible(boolean show) {
        this.table.setLinesVisible(show);
    }

    public void setSelection(HexTableItem[] items) {
        TableItem[] tableItems = new TableItem[items.length];
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                throw new SWTError(4);
            }
            tableItems[i] = items[i].getItem();
            ++i;
        }
        this.setSelection(tableItems);
    }

    public void setSelection(TableItem[] items) {
        this.table.setSelection(items);
    }

    public void setSelection(int index) {
        this.table.setSelection(index);
    }

    public HexTableItem[] getSelection() {
        TableItem[] selection = this.table.getSelection();
        HexTableItem[] result = new HexTableItem[selection.length];
        int i = 0;
        while (i < selection.length) {
            result[i] = (HexTableItem)selection[i].getData();
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        return this.table.getSelectionCount();
    }

    public int getSelectionIndex() {
        return this.table.getSelectionIndex();
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isInDispose() {
        return this.inDispose;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(hHint, wHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        super.computeSize(wHint, hHint, changed);
        return this.table.computeSize(wHint, hHint, changed);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.table.computeTrim(x, y, width, height);
    }

    public int getItemHeight() {
        return this.table.getItemHeight();
    }

    public int getTableSize() {
        int lastItemIndex = this.getItemCount() - 1;
        if (lastItemIndex == -1) {
            return 0;
        }
        if (this.getItem(lastItemIndex) == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Hex", (String)("LastItem==NULL!! lastItemIndex=" + lastItemIndex + ", items.len=" + this.items.length + "\n\nPlease report this error to the author. Thanks."));
        }
        return lastItemIndex * 16 + this.getItem(lastItemIndex).getItemSize();
    }

    private int getTableSize(int rowIndex, int columnIndex) {
        int totalSize = this.getTableSize();
        return totalSize - (rowIndex * 16 + columnIndex);
    }

    int getTableSize(int rowIndexBegin, int columnIndexBegin, int rowIndexEnd, int columnIndexEnd) {
        return rowIndexEnd * 16 + columnIndexEnd + 1 - (rowIndexBegin * 16 + columnIndexBegin);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.table.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.table.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.table.setMenu(menu);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.table.setToolTipText(string);
    }

    public void setLayoutData(Object layoutData) {
        super.setLayoutData(layoutData);
        this.table.setLayoutData(layoutData);
    }

    public void setData(Object data) {
        super.setData(data);
        this.table.setData(data);
    }

    public boolean setFocus() {
        super.setFocus();
        return this.table.setFocus();
    }

    public void showSelection() {
        this.table.showSelection();
    }

    public void pack() {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1));
    }

    void onResize() {
        Rectangle area = this.getClientArea();
        this.table.setBounds(0, 0, area.width, area.height);
        int dataColumnWidth = (area.width - 80) / 16;
        if (dataColumnWidth < 27) {
            dataColumnWidth = 27;
        }
        int i = 1;
        while (i < 17) {
            this.table.getColumn(i).setWidth(dataColumnWidth);
            ++i;
        }
        int offsetColumnWidth = area.width - dataColumnWidth * 16;
        if (offsetColumnWidth < 80) {
            offsetColumnWidth = 80;
        }
        this.table.getColumn(0).setWidth(offsetColumnWidth);
    }

    private void onFocusIn() {
        this.table.setFocus();
    }

    private void onFocusOut() {
    }

    private void onDispose() {
        this.inDispose = true;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            ++i;
        }
        this.inDispose = false;
    }

    void addData(int bufferIndex, byte[] buffer, int dataAvailable) {
        if (dataAvailable < 0 || buffer == null || buffer.length == 0) {
            return;
        }
        int dataStartIndex = 0;
        int numRows = this.getItemCount();
        HexTableItem item = this.getItem(numRows - 1);
        if (item != null) {
            dataStartIndex = item.addData(bufferIndex, numRows, buffer, dataAvailable, 0);
        }
        int numCompleteRows = (dataAvailable - dataStartIndex) / 16;
        int lastRowLength = (dataAvailable - dataStartIndex) % 16;
        int i = 0;
        while (i < numCompleteRows) {
            item = new HexTableItem(this, 0, index++);
            item.addData(bufferIndex, i, buffer, dataAvailable, dataStartIndex + i * 16);
            ++i;
        }
        if (lastRowLength > 0) {
            item = new HexTableItem(this, 0, index++);
            item.addData(bufferIndex, numCompleteRows, buffer, dataAvailable, dataStartIndex + numCompleteRows * 16);
        }
    }

    void updateData(int bufferIndex, byte[] buffer, int dataAvailable) {
        HexTableItem item;
        if (dataAvailable < 0 || buffer == null || buffer.length == 0) {
            return;
        }
        int dataStartIndex = 0;
        int numCompleteRows = (dataAvailable - dataStartIndex) / 16;
        int lastRowLength = (dataAvailable - dataStartIndex) % 16;
        int i = 0;
        while (i < numCompleteRows) {
            item = this.getItem(index++);
            item.updateData(bufferIndex, i, buffer, dataAvailable, dataStartIndex + i * 16);
            ++i;
        }
        if (lastRowLength > 0) {
            item = this.getItem(index++);
            item.updateData(bufferIndex, numCompleteRows, buffer, dataAvailable, dataStartIndex + numCompleteRows * 16);
        }
    }

    public void insertData(int dataSize, int dataValue, int rowIndex, int columnIndex, boolean refresh) {
        HexTableBuffer tableBuffer = new HexTableBuffer(this);
        tableBuffer.storeTableRegion(new HexTablePointer(rowIndex, columnIndex));
        Cursor waitCursor = new Cursor((Device)this.table.getDisplay(), 1);
        this.table.getShell().setCursor(waitCursor);
        String dataValueString = Utils.byte2string((byte)((byte)dataValue));
        int row = rowIndex;
        int column = columnIndex + 1;
        HexTableItem item = this.getItem(row);
        int i = 0;
        while (i < dataSize) {
            if (column > 16) {
                item = this.getItem(++row);
                column = 1;
            }
            item.setText(column, dataValueString);
            ++column;
            ++i;
        }
        tableBuffer.restoreTableRegion(new HexTablePointer(rowIndex, columnIndex).move(dataSize));
        if (refresh) {
            this.refreshOffsetColumn();
            this.hexEditorControl.redrawCursor();
        }
        this.table.getShell().setCursor(null);
        this.table.redraw();
        waitCursor.dispose();
    }

    void appendData(int dataSize, int dataValue, int rowIndex, int columnIndex, boolean refresh) {
        String dataValueString = Utils.byte2string((byte)((byte)dataValue));
        HexTableItem lastItem = this.getItem(rowIndex);
        int lastItemSize = lastItem.getItemSize();
        int lastItemFreeSize = 16 - lastItemSize;
        int numNewItemsToAppend = 0;
        int numNewCellsToAppend = 0;
        int i = 0;
        while (i < lastItemFreeSize && lastItem != null && dataSize > 0) {
            int column = lastItemSize + i + 1;
            lastItem.setText(column, dataValueString);
            --dataSize;
            ++i;
        }
        if (dataSize > 0) {
            numNewItemsToAppend = dataSize / 16;
            numNewCellsToAppend = dataSize % 16;
            int style = this.getStyle();
            ++rowIndex;
            int i2 = 0;
            while (i2 < numNewItemsToAppend) {
                HexTableItem newItem = new HexTableItem(this, style, rowIndex++);
                int j = 0;
                while (j < 16 && dataSize > 0) {
                    newItem.setText(j + 1, dataValueString);
                    --dataSize;
                    ++j;
                }
                ++i2;
            }
            if (numNewCellsToAppend > 0) {
                HexTableItem newItem = new HexTableItem(this, style, this.getItemCount());
                int j = 0;
                while (j < dataSize) {
                    newItem.setText(j + 1, dataValueString);
                    ++j;
                }
                newItem.itemFiller();
            }
        }
        if (refresh) {
            this.refreshOffsetColumn();
            this.hexEditorControl.redrawCursor();
        }
    }

    public void deleteData(int delSize, int rowIndex, int columnIndex, boolean refresh) {
        if (delSize == 0) {
            return;
        }
        int tableSizeFromCursor = this.getTableSize(rowIndex, columnIndex);
        if (delSize == -1 || tableSizeFromCursor <= delSize) {
            HexTableItem item = this.getItem(rowIndex);
            item.delete(columnIndex);
            if (columnIndex == 0) {
                int numItems = this.getItemCount();
                if (rowIndex > 0) {
                    this.remove(rowIndex);
                    this.hexEditorControl.setCursorSelection(rowIndex - 1, 1);
                } else {
                    if (numItems > 1) {
                        this.remove(1);
                    }
                    this.hexEditorControl.setCursorSelection(0, 1);
                }
            } else {
                this.remove(rowIndex + 1);
            }
        } else {
            HexTablePointer p1 = new HexTablePointer(rowIndex, columnIndex);
            HexTablePointer p2 = new HexTablePointer(rowIndex, columnIndex).move(delSize);
            HexTableBuffer tableBuffer = new HexTableBuffer(this);
            tableBuffer.storeTableRegion(p2);
            int storedRegionSize = tableBuffer.getTableRegionSize();
            tableBuffer.restoreTableRegion(p1);
            p1.move(storedRegionSize);
            if (p1.getColumnIndex() == 0) {
                this.remove(p1.getRowIndex());
            } else {
                HexTableItem item = this.getItem(p1.getRowIndex());
                item.delete(p1.getColumnIndex());
                this.remove(p1.getRowIndex() + 1);
            }
        }
        if (refresh) {
            this.refreshOffsetColumn();
            this.hexEditorControl.redrawCursor();
        }
    }

    int getRowData(byte[] buffer, int rowIndex) {
        HexTableItem row = this.getItem(rowIndex);
        if (row == null) {
            System.out.println("ERROR : Row is NULL.");
            return 0;
        }
        int i = 0;
        while (i < 16) {
            String hexString = row.getText(i + 1);
            if (hexString.equals("  ")) {
                return i;
            }
            buffer[i] = Utils.string2byte((String)hexString);
            ++i;
        }
        return 16;
    }

    private void refreshOffsetColumn() {
        int i = 0;
        while (i < this.getItemCount()) {
            HexTableItem item = this.getItem(i);
            if (item != null) {
                String offset = Integer.toHexString(i * 16).toUpperCase();
                String offsetZeroPadded = String.valueOf("00000000".substring(offset.length())) + offset;
                item.setText(0, String.valueOf(offsetZeroPadded) + ":");
            }
            ++i;
        }
    }

    void addDummyItem() {
        HexTableItem item = new HexTableItem(this, 0);
        int i = 0;
        while (i < 16) {
            item.setText(i + 1, "  ");
            ++i;
        }
    }

    void unHilite() {
        int numItems = this.getItemCount();
        int row = 0;
        while (row < numItems) {
            HexTableItem item = this.getItem(row);
            int column = 0;
            while (column <= 17) {
                item.setForeground(column, null);
                ++column;
            }
            ++row;
        }
        CellEditorKeyListener.shiftRow = -1;
        CellEditorKeyListener.shiftColumn = -1;
    }

    void hiliteShiftSelection() {
        HexTableItem item;
        int shiftRow = CellEditorKeyListener.shiftRow;
        int shiftCol = CellEditorKeyListener.shiftColumn;
        int selectedRow = CellEditorKeyListener.selectedRow;
        int selectedCol = CellEditorKeyListener.selectedColumn;
        int startRow = Math.min(shiftRow, selectedRow);
        int endRow = Math.max(shiftRow, selectedRow);
        int numItems = this.getItemCount();
        int row = 0;
        while (row < numItems) {
            item = this.getItem(row);
            int column = 0;
            while (column <= 17) {
                item.setForeground(column, null);
                ++column;
            }
            ++row;
        }
        int startCol = 0;
        int endCol = 0;
        int row2 = startRow;
        while (row2 <= endRow) {
            item = this.getItem(row2);
            startCol = row2 == startRow ? (shiftRow > selectedRow ? selectedCol : (shiftRow == selectedRow ? Math.min(shiftCol, selectedCol) : shiftCol)) : 1;
            endCol = row2 == endRow ? (shiftRow > selectedRow ? shiftCol : (shiftRow == selectedRow ? Math.max(shiftCol, selectedCol) : selectedCol)) : 17;
            int column = startCol;
            while (column <= endCol) {
                item.setForeground(column, ExcentisColors.blue);
                ++column;
            }
            ++row2;
        }
    }
}

