/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui.events;

import com.excentis.products.byteblower.gui.views.hex.gui.HexEditorControl;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTable;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CellEditorKeyListener
extends KeyAdapter {
    private final HexEditorControl hexEditorControl;
    private final TableCursor cursor;
    private final Text text;
    public static int selectedRow;
    public static int selectedColumn;
    public static int shiftRow;
    public static int shiftColumn;

    public static void updateShiftPos() {
        shiftRow = selectedRow;
        shiftColumn = selectedColumn;
    }

    CellEditorKeyListener(HexEditorControl hexEditorControl, TableCursor cursor, ControlEditor editor, Text text) {
        this.hexEditorControl = hexEditorControl;
        this.cursor = cursor;
        this.text = text;
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (!('0' <= chars[i] && chars[i] <= '9' || 'A' <= chars[i] && chars[i] <= 'F' || 'a' <= chars[i] && chars[i] <= 'f')) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\r') {
            this.keyPressedEnter();
            this.hexEditorControl.updateStatusPanel();
            return;
        }
        if (e.character == '\u001b') {
            this.text.dispose();
            this.hexEditorControl.updateStatusPanel();
            return;
        }
        if (e.character == '\u007f' || e.character < ' ') {
            return;
        }
        if (e.character >= '0' && e.character <= '9' || e.character >= 'A' && e.character <= 'F' || e.character >= 'a' && e.character <= 'f') {
            if (this.text.getText().length() == 1) {
                String enteredText = "";
                enteredText = this.text.getCaretPosition() == 0 ? String.valueOf(e.character) + this.text.getText() : String.valueOf(this.text.getText()) + e.character;
                this.closeCellEditor(this.hexEditorControl.getHexTable().getItem(this.cursor.getRow()), this.cursor.getColumn(), enteredText);
                this.goToNextCell();
                this.hexEditorControl.saveFrame();
            }
            this.hexEditorControl.updateStatusPanel();
        }
    }

    public void closeCellEditor(HexTableItem row, int column, String str) {
        row.setText(column, str.toUpperCase());
        this.text.dispose();
    }

    private final void goToNextCell() {
        HexTableItem row = this.hexEditorControl.getHexTable().getItem(this.cursor.getRow());
        int column = this.cursor.getColumn();
        if (row == null) {
            System.out.println("ERROR : row is null");
            return;
        }
        HexTable table = row.getParent();
        int rowIndex = table.getSelectionIndex();
        if (rowIndex == -1) {
            rowIndex = selectedRow;
        }
        if (column >= 16) {
            int numTableRows = table.getItemCount();
            if (rowIndex + 1 == numTableRows) {
                return;
            }
            column = 1;
            row = table.getItem(rowIndex + 1);
            selectedRow = rowIndex + 1;
            selectedColumn = 1;
            table.setSelection(rowIndex + 1);
        } else {
            selectedRow = rowIndex;
            selectedColumn = ++column;
        }
        this.cursor.setSelection(row.getItem(), column);
        table.setFocus();
    }

    private void keyPressedEnter() {
        HexTableItem row = this.hexEditorControl.getHexTable().getItem(this.cursor.getRow());
        int column = this.cursor.getColumn();
        String str = this.text.getText();
        if (str.length() == 0) {
            str = "00";
        } else if (str.length() == 1) {
            str = "0" + str;
        }
        if (Character.digit(str.charAt(0), 16) != -1 && Character.digit(str.charAt(1), 16) != -1) {
            this.closeCellEditor(row, column, str);
            this.goToNextCell();
            this.hexEditorControl.saveFrame();
        }
    }
}

