/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.multicast;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.composites.sash.ByteBlowerSashForm;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerViewPart;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastGroupComposite;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastMemberComposite;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastSourceGroupComposite;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastSourceIpAddressesComposite;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastSourceMemberComposite;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class MulticastView
extends ByteBlowerViewPart {
    public static final String ID = "com.excentis.products.byteblower.gui.views.MulticastView";
    private Action showHideSourceSpecificMulticast;
    private static boolean sourceSpecificMulticastEnabled = true;
    private MulticastSourceGroupComposite sourceGroupComposite;
    private static final int[] bottomWeights = new int[]{1, 1, 1};

    @Override
    protected void initToolBar() {
        this.createShowHideActions();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add((IAction)this.showHideSourceSpecificMulticast);
    }

    private void createShowHideActions() {
        this.showHideSourceSpecificMulticast = new Action("Source Specific Multicast", 2){

            public void run() {
                MulticastView.this.showSourceSpecificMulticast(MulticastView.this.showHideSourceSpecificMulticast.isChecked());
            }
        };
        this.showHideSourceSpecificMulticast.setToolTipText("show/hide Source Specific Multicast");
        ImageDescriptor id = ImageDescriptor.createFromFile(ImageCache.class, (String)"view/multicast/e_multicast_ssm.png");
        if (id != null) {
            this.showHideSourceSpecificMulticast.setImageDescriptor(id);
        }
        boolean show = ByteBlowerPreferences.getMulticastViewShowSourceSpecificMulticast();
        this.showHideSourceSpecificMulticast.setChecked(show);
        this.showSourceSpecificMulticast(show);
    }

    private void showSourceSpecificMulticast(boolean show) {
        sourceSpecificMulticastEnabled = show;
        ByteBlowerSashForm bottom = this.getBottomComposites();
        bottom.setVisible(show);
        bottom.getParent().layout();
    }

    @Override
    public void dispose() {
        if (this.showHideSourceSpecificMulticast != null) {
            ByteBlowerPreferences.setMulticastViewShowSourceSpecificMulticast((boolean)sourceSpecificMulticastEnabled);
        }
        super.dispose();
    }

    @Override
    protected ByteBlowerComposite createTopLeftControl(Composite parent) {
        return new MulticastGroupComposite(parent, this, this);
    }

    @Override
    protected ByteBlowerComposite createTopRightControl(Composite parent) {
        return new MulticastMemberComposite(parent, this, this, this.getMulticastGroupComposite());
    }

    private MulticastGroupComposite getMulticastGroupComposite() {
        return (MulticastGroupComposite)this.getTopLeft();
    }

    private MulticastSourceGroupComposite getMulticastSourceGroupComposite() {
        return this.sourceGroupComposite;
    }

    @Override
    protected ByteBlowerComposite createBottomLeftControl(Composite parent) {
        this.sourceGroupComposite = new MulticastSourceGroupComposite(parent, this, this);
        return this.sourceGroupComposite;
    }

    @Override
    protected ByteBlowerComposite createBottomMiddleControl(Composite parent) {
        return new MulticastSourceIpAddressesComposite(parent, this, this, this.sourceGroupComposite);
    }

    @Override
    protected ByteBlowerComposite createBottomRightControl(Composite parent) {
        return new MulticastSourceMemberComposite(parent, this, this, this.sourceGroupComposite);
    }

    public static void showAndSelect(MulticastGroup multicastGroup) {
        MulticastView view = MulticastView.showMulticastView();
        view.getMulticastGroupComposite().selectAndReveal(multicastGroup);
    }

    public static void showAndSelect(MulticastSourceGroup multicastSourceGroup) {
        MulticastView view = MulticastView.showMulticastView();
        view.getMulticastSourceGroupComposite().selectAndReveal(multicastSourceGroup);
    }

    @Override
    protected int[] getBottomWeights() {
        return bottomWeights;
    }
}

