/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Ipv6AddressConfigType;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DHCPv6CellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    private TreeViewer treeViewer;
    static final String DHCP_EDITOR_OPTION_FIXED = "Fixed";
    static final String DHCP_EDITOR_OPTION_AUTO = "Auto Configuration";
    static final String DHCP_EDITOR_OPTION_NEW = "New Dhcp...";
    private static final int NOF_FIXED_ITEMS = 3;
    private static final int POS_FIXED = 0;
    private static final int POS_AUTO = 1;
    private static final int POS_ITEMS = 2;

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        CCombo combo = (CCombo)control;
        combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public DHCPv6CellEditor(TreeViewer treeViewer) {
        super((Composite)treeViewer.getTree(), new String[0], 0);
        this.treeViewer = treeViewer;
        this.setActivationStyle(1);
    }

    private String[] getItemList() {
        ByteBlowerGuiPort selectedPort = (ByteBlowerGuiPort)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        ByteBlowerProject project = selectedPort.getByteBlowerProject();
        EList dhcps = project.getDhcp();
        int itemCount = dhcps.size();
        String[] names = new String[3 + itemCount];
        names[0] = DHCP_EDITOR_OPTION_FIXED;
        names[1] = DHCP_EDITOR_OPTION_AUTO;
        int i = 2;
        for (Dhcp dhcp : dhcps) {
            names[i++] = dhcp.getName();
        }
        names[i] = DHCP_EDITOR_OPTION_NEW;
        return names;
    }

    public Object doGetValue() {
        Object superValue = super.doGetValue();
        Integer intValue = (Integer)superValue;
        int index = intValue;
        if (index == 0) {
            return DHCP_EDITOR_OPTION_FIXED;
        }
        if (index == 1) {
            return DHCP_EDITOR_OPTION_AUTO;
        }
        EList<Dhcp> allDhcps = this.getAllDhcps();
        if ((index -= 2) < allDhcps.size()) {
            return this.getAllDhcps().get(index);
        }
        return DHCP_EDITOR_OPTION_NEW;
    }

    protected void doSetValue(Object value) {
        int index = 0;
        if (value instanceof Dhcp) {
            index = this.getAllDhcps().indexOf(value) + 2;
        } else if (value instanceof Ipv6Configuration) {
            Ipv6Configuration ipv6Configuration = (Ipv6Configuration)value;
            Ipv6AddressConfigType ipv6AddressConfigType = ipv6Configuration.getAddressConfiguration();
            if (ipv6AddressConfigType == Ipv6AddressConfigType.FIXED_LITERAL) {
                index = 0;
            } else if (ipv6AddressConfigType == Ipv6AddressConfigType.AUTO_CONFIGURATION_LITERAL) {
                index = 1;
            }
        }
        this.setItems(this.getItemList());
        super.doSetValue((Object)index);
    }

    private EList<Dhcp> getAllDhcps() {
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        ByteBlowerProject project = (ByteBlowerProject)projectController.getObject();
        return project.getDhcp();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.doGetValue() == DHCP_EDITOR_OPTION_NEW) {
            this.focusLost();
        }
    }
}

