/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerAmountTreeComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerViewPart;
import com.excentis.products.byteblower.gui.views.port.composites.IByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv4PortComposite;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv6PortComposite;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class PortView
extends ByteBlowerViewPart
implements IByteBlowerGroupAction {
    public static final String ID = "com.excentis.products.byteblower.gui.views.PortView";
    private Action showHideIpv4Action;
    private Action showHideIpv6Action;

    @Override
    public void dispose() {
        if (this.showHideIpv4Action != null) {
            ByteBlowerPreferences.setPortViewShowIpv4((boolean)this.showHideIpv4Action.isChecked());
        }
        if (this.showHideIpv6Action != null) {
            ByteBlowerPreferences.setPortViewShowIpv6((boolean)this.showHideIpv6Action.isChecked());
        }
        super.dispose();
    }

    @Override
    protected void initToolBar() {
        this.createShowHideActions();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add((IAction)this.showHideIpv4Action);
        tm.add((IAction)this.showHideIpv6Action);
    }

    private void createShowHideActions() {
        this.showHideIpv4Action = new Action("Show/Hide IPv4", 2){

            public void run() {
                PortView.this.showIpv4(PortView.this.showHideIpv4Action.isChecked());
            }
        };
        this.showHideIpv4Action.setToolTipText("Show/Hide IPv4");
        ImageDescriptor id = ImageDescriptor.createFromFile(ImageCache.class, (String)"view/port/e_port_ipv4.png");
        if (id != null) {
            this.showHideIpv4Action.setImageDescriptor(id);
        }
        boolean show = ByteBlowerPreferences.getPortViewShowIpv4();
        this.showHideIpv4Action.setChecked(show);
        this.showIpv4(show);
        this.showHideIpv6Action = new Action("Show/Hide IPv6", 2){

            public void run() {
                PortView.this.showIpv6(PortView.this.showHideIpv6Action.isChecked());
            }
        };
        this.showHideIpv6Action.setToolTipText("Show/Hide IPv6");
        id = ImageDescriptor.createFromFile(ImageCache.class, (String)"view/port/e_port_ipv6.png");
        if (id != null) {
            this.showHideIpv6Action.setImageDescriptor(id);
        }
        show = ByteBlowerPreferences.getPortViewShowIpv6();
        this.showHideIpv6Action.setChecked(show);
        this.showIpv6(show);
    }

    private void showIpv4(boolean show) {
        Ipv4PortComposite iPv4PortComposite = this.getIPv4PortComposite();
        if (iPv4PortComposite != null) {
            iPv4PortComposite.setVisible(show);
            iPv4PortComposite.getParent().layout();
        }
    }

    private void showIpv6(boolean show) {
        Ipv6PortComposite iPv6PortComposite = this.getIPv6PortComposite();
        if (iPv6PortComposite != null) {
            iPv6PortComposite.setVisible(show);
            iPv6PortComposite.getParent().layout();
        }
    }

    public Ipv4PortComposite getIPv4PortComposite() {
        return (Ipv4PortComposite)this.getTopLeft();
    }

    public Ipv6PortComposite getIPv6PortComposite() {
        return (Ipv6PortComposite)this.getBottomLeft();
    }

    @Override
    protected ByteBlowerComposite createTopLeftControl(Composite parent) {
        return new Ipv4PortComposite(parent, this, this);
    }

    @Override
    protected ByteBlowerComposite createBottomLeftControl(Composite parent) {
        return new Ipv6PortComposite(parent, this, this);
    }

    public static void showAndSelect(ByteBlowerGuiPort port) {
        PortView view = PortView.showPortView();
        view.selectAndReveal(port);
    }

    public static void showAndSelect(ByteBlowerPortGroup group) {
        PortView view = PortView.showPortView();
        view.selectAndReveal(group);
    }

    private void selectAndReveal(ByteBlowerGuiPort port) {
        ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)port);
        ByteBlowerAmountTreeComposite composite = reader.isIPv4() ? this.getIPv4PortComposite() : this.getIPv6PortComposite();
        composite.selectAndReveal((Object)port);
    }

    private void selectAndReveal(ByteBlowerPortGroup group) {
        ByteBlowerPortGroupReader reader = ReaderFactory.create((ByteBlowerPortGroup)group);
        ByteBlowerAmountTreeComposite composite = reader.hasActiveIpv4Configuration() ? this.getIPv4PortComposite() : this.getIPv6PortComposite();
        composite.selectAndReveal((Object)group);
    }

    @Override
    public void group() {
        this.doGroup();
    }

    @Override
    public void ungroup() {
        this.doUngroup();
    }
}

