/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VlanStackCellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    private TreeViewer treeViewer;
    static final String VLAN_STACK_EDITOR_OPTION_NO = "No";
    static final String VLAN_STACK_EDITOR_OPTION_NEW = "New VLAN Stack...";

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        CCombo combo = (CCombo)control;
        combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public VlanStackCellEditor(TreeViewer treeViewer) {
        super((Composite)treeViewer.getTree(), new String[0], 0);
        this.treeViewer = treeViewer;
        this.setActivationStyle(1);
    }

    private String[] getItemList() {
        ByteBlowerGuiPort selectedPort = (ByteBlowerGuiPort)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        ByteBlowerProject project = selectedPort.getByteBlowerProject();
        EList stacks = project.getVlanStack();
        int itemCount = stacks.size();
        String[] vlanNames = new String[2 + itemCount];
        vlanNames[0] = VLAN_STACK_EDITOR_OPTION_NO;
        int i = 1;
        for (VlanStack vlan : stacks) {
            vlanNames[i++] = vlan.getName();
        }
        vlanNames[i] = VLAN_STACK_EDITOR_OPTION_NEW;
        return vlanNames;
    }

    public Object doGetValue() {
        Object superValue = super.doGetValue();
        Integer intValue = (Integer)superValue;
        Object returnValue = VLAN_STACK_EDITOR_OPTION_NO;
        int index = intValue;
        if (index > 0) {
            EList<VlanStack> allVlans = this.getAllVlanStacks();
            returnValue = --index < allVlans.size() ? allVlans.get(index) : VLAN_STACK_EDITOR_OPTION_NEW;
        }
        return returnValue;
    }

    protected void doSetValue(Object value) {
        int index = 0;
        if (value != null) {
            VlanStack vlanStack = (VlanStack)value;
            index = this.getAllVlanStacks().indexOf((Object)vlanStack) + 1;
        }
        this.setItems(this.getItemList());
        super.doSetValue((Object)index);
    }

    private EList<VlanStack> getAllVlanStacks() {
        ByteBlowerProjectReader projectReader = ByteBlowerGuiResourceController.getProjectReader();
        return projectReader.getVlanStacks();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.doGetValue() == VLAN_STACK_EDITOR_OPTION_NEW) {
            this.focusLost();
        }
    }
}

