/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.composites;

import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.dialogs.PcapCaptureDialog;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

final class CaptureMenuItemInteractive
implements MenuListener,
SelectionListener {
    private static final String BASE_TEXT = "Start Capture";
    private final List<ByteBlowerGuiPortReader> toCaptureOn = new ArrayList<ByteBlowerGuiPortReader>();
    private final MenuItem captureMenu;
    private ByteBlowerViewerComposite<EByteBlowerObject> outer;

    CaptureMenuItemInteractive(ByteBlowerViewerComposite<EByteBlowerObject> parent, Menu base) {
        this.captureMenu = new MenuItem(base, 8);
        this.captureMenu.addSelectionListener((SelectionListener)this);
        base.addMenuListener((MenuListener)this);
        this.outer = parent;
    }

    public void widgetSelected(SelectionEvent event) {
        PhysicalConfigurationReader actualServerConfig = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
        for (ByteBlowerGuiPortReader port : this.toCaptureOn) {
            PhysicalDockable dockable = actualServerConfig.getPhysicalDockable(port);
            PcapCaptureDialog captureDialog = new PcapCaptureDialog(this.outer.getShell(), (EByteBlowerServerObject)dockable);
            captureDialog.open();
            captureDialog.startCapture();
        }
    }

    public void menuShown(MenuEvent event) {
        this.toCaptureOn.clear();
        for (EByteBlowerObject port : this.outer.getSelectedObjects()) {
            ByteBlowerGuiPortReader portReader;
            if (!(port instanceof ByteBlowerGuiPort) || !(portReader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)port))).isDocked()) continue;
            this.toCaptureOn.add(portReader);
        }
        if (this.toCaptureOn.isEmpty()) {
            this.captureMenu.setEnabled(false);
            this.captureMenu.setToolTipText("Select a docked ByteBlower Port");
            this.captureMenu.setText("Start Capture ...");
        } else if (this.toCaptureOn.size() == 1) {
            this.captureMenu.setEnabled(true);
            this.captureMenu.setToolTipText("Captures on selected interface");
            this.captureMenu.setText("Start Capture on " + this.toCaptureOn.get(0).getName());
        } else {
            this.captureMenu.setEnabled(true);
            this.captureMenu.setToolTipText("Captures on selected interfaces");
            String txt = String.format("%s on %d Ports", BASE_TEXT, this.toCaptureOn.size());
            this.captureMenu.setText(txt);
        }
    }

    public void menuHidden(MenuEvent arg0) {
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

