/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.composites;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.EByteBlowerObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.widgets.dialogs.IncrementMtuDialog;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.PlatformUI;

class Ipv4PortCopyDown
extends EByteBlowerObjectCopyDown<EByteBlowerObject> {
    protected CopyDownInfo copyDownSpecial(EByteBlowerObject originalObject, EByteBlowerObject affectedObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        ByteBlowerGuiPortController.CommandWithVlanStackOptionReference commandWithReference = null;
        if (originalObject instanceof ByteBlowerGuiPort && affectedObject instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort originalPort = (ByteBlowerGuiPort)originalObject;
            ByteBlowerGuiPort affectedPort = (ByteBlowerGuiPort)affectedObject;
            boolean firstCommand = false;
            if (copyDownInfo == null) {
                firstCommand = true;
                copyDownInfo = new CopyDownInfo();
            }
            ByteBlowerGuiPortController originalPortController = new ByteBlowerGuiPortController(originalPort);
            ByteBlowerGuiPortController affectedPortController = new ByteBlowerGuiPortController(affectedPort);
            switch (translator.getColumn()) {
                case 1: {
                    EthernetConfiguration previousEthernetConfiguration = firstCommand ? (EthernetConfiguration)originalPort.getLayer2Configuration() : (EthernetConfiguration)copyDownInfo.getValue();
                    EthernetConfigurationController affectedEthernetConfigurationController = affectedPortController.getEthernetConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = affectedEthernetConfigurationController.setIncrementedMacAddress(previousEthernetConfiguration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = affectedEthernetConfigurationController.setDecrementedMacAddress(previousEthernetConfiguration);
                        break;
                    }
                    commandWithReference = affectedEthernetConfigurationController.copyMacAddress(previousEthernetConfiguration);
                    break;
                }
                case 2: {
                    Ipv4ConfigurationController ipv4ConfigurationController = affectedPortController.getIpv4ConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        Ipv4Configuration previousIpv4Configuration = firstCommand ? originalPortController.getIpv4Configuration() : (Ipv4Configuration)copyDownInfo.getValue();
                        commandWithReference = ipv4ConfigurationController.copyAddressConfiguration(previousIpv4Configuration);
                        break;
                    }
                    Dhcp previousDhcp = firstCommand ? originalPortController.getDhcpv4() : (Dhcp)copyDownInfo.getValue();
                    commandWithReference = ipv4ConfigurationController.setIncrementedAddressConfiguration(previousDhcp);
                    break;
                }
                case 3: {
                    Ipv4Configuration previousIpv4Configuration = firstCommand ? originalPort.getIpv4Configuration() : (Ipv4Configuration)copyDownInfo.getValue();
                    Ipv4Configuration ipv4Configuration = affectedPort.getIpv4Configuration();
                    Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(ipv4Configuration);
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = ipv4ConfigurationController.setIncrementedIpAddress(previousIpv4Configuration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = ipv4ConfigurationController.setDecrementedIpAddress(previousIpv4Configuration);
                        break;
                    }
                    commandWithReference = ipv4ConfigurationController.copyIpAddress(previousIpv4Configuration);
                    break;
                }
                case 4: {
                    Ipv4Configuration previousIpv4Configuration = firstCommand ? originalPort.getIpv4Configuration() : (Ipv4Configuration)copyDownInfo.getValue();
                    Ipv4Configuration ipv4Configuration = affectedPort.getIpv4Configuration();
                    Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(ipv4Configuration);
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = ipv4ConfigurationController.setIncrementedDefaultGateway(previousIpv4Configuration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = ipv4ConfigurationController.setDecrementedDefaultGateway(previousIpv4Configuration);
                        break;
                    }
                    commandWithReference = ipv4ConfigurationController.copyDefaultGateway(previousIpv4Configuration);
                    break;
                }
                case 5: {
                    Ipv4Configuration previousIpv4Configuration = firstCommand ? originalPort.getIpv4Configuration() : (Ipv4Configuration)copyDownInfo.getValue();
                    Ipv4Configuration ipv4Configuration = affectedPort.getIpv4Configuration();
                    Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(ipv4Configuration);
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = ipv4ConfigurationController.setIncrementedNetmask(previousIpv4Configuration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = ipv4ConfigurationController.setDecrementedNetmask(previousIpv4Configuration);
                        break;
                    }
                    commandWithReference = ipv4ConfigurationController.copyNetmask(previousIpv4Configuration);
                    break;
                }
                case 6: {
                    FeatureInfo featureInfo = translator.getFeatureInfo();
                    boolean portForwarding = originalPortController.usesPortForwarding();
                    if (firstCommand) {
                        copyDownInfo.setValue((Object)originalPortController.getPortForwarding());
                    }
                    if (portForwarding) {
                        featureInfo.setFeatureType(1);
                        featureInfo.setFeature((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__PORT_FORWARDING);
                        copyDownInfo = super.copyDown((EObject)originalPort, (EObject)affectedPort, copyDownInfo, translator, operation, mode, takenNames);
                        featureInfo.setFeatureType(0);
                    } else if (originalPortController.isNatted()) {
                        operation.appendCommand(affectedPortController.setNatAutomaticDiscovery());
                    } else {
                        operation.appendCommand(affectedPortController.clearNat());
                    }
                    return copyDownInfo;
                }
                case 7: {
                    Object vlanOption;
                    Object object = vlanOption = firstCommand ? originalPortController.getVlanStack() : copyDownInfo.getValue();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        commandWithReference = affectedPortController.setVlanStack(vlanOption);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        Object vlanStack = vlanOption;
                        commandWithReference = affectedPortController.setIncrementedVlanStack(vlanStack);
                        break;
                    }
                    commandWithReference = null;
                    break;
                }
                case 8: {
                    Long previousMtu;
                    Long l = previousMtu = firstCommand ? originalPortController.getMTU() : (Long)copyDownInfo.getValue();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        commandWithReference = affectedPortController.setMtu(previousMtu);
                        break;
                    }
                    if (firstCommand) {
                        IncrementMtuDialog dialog = new IncrementMtuDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (dialog.open() != 0) break;
                        copyDownInfo.setAmount((Object)new Long(dialog.getIncrementSize()));
                    }
                    Long incrementValue = (Long)copyDownInfo.getAmount();
                    commandWithReference = affectedPortController.setIncrementedMtu(previousMtu, incrementValue);
                }
            }
        }
        if (commandWithReference != null) {
            operation.appendCommand(commandWithReference.getCommand());
            copyDownInfo.setValue(commandWithReference.getCommandReference());
            return copyDownInfo;
        }
        return null;
    }
}

