/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.composites;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.EByteBlowerObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.widgets.dialogs.IncrementMtuDialog;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv6ConfigurationController;
import java.util.List;
import org.eclipse.ui.PlatformUI;

class Ipv6PortCopyDown
extends EByteBlowerObjectCopyDown<EByteBlowerObject> {
    protected CopyDownInfo copyDownSpecial(EByteBlowerObject originalObject, EByteBlowerObject affectedObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        ByteBlowerGuiPortController.CommandWithVlanStackOptionReference commandWithReference = null;
        if (originalObject instanceof ByteBlowerGuiPort && affectedObject instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort originalPort = (ByteBlowerGuiPort)originalObject;
            ByteBlowerGuiPort affectedPort = (ByteBlowerGuiPort)affectedObject;
            boolean firstCommand = false;
            if (copyDownInfo == null) {
                firstCommand = true;
                copyDownInfo = new CopyDownInfo();
            }
            ByteBlowerGuiPortController originalPortController = new ByteBlowerGuiPortController(originalPort);
            ByteBlowerGuiPortController affectedPortController = new ByteBlowerGuiPortController(affectedPort);
            switch (translator.getColumn()) {
                case 1: {
                    EthernetConfiguration previousEthernetConfiguration = firstCommand ? (EthernetConfiguration)originalPort.getLayer2Configuration() : (EthernetConfiguration)copyDownInfo.getValue();
                    EthernetConfigurationController affectedEthernetConfigurationController = affectedPortController.getEthernetConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = affectedEthernetConfigurationController.setIncrementedMacAddress(previousEthernetConfiguration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = affectedEthernetConfigurationController.setDecrementedMacAddress(previousEthernetConfiguration);
                        break;
                    }
                    commandWithReference = affectedEthernetConfigurationController.copyMacAddress(previousEthernetConfiguration);
                    break;
                }
                case 2: {
                    Ipv6ConfigurationController ipv6ConfigurationController = affectedPortController.getIpv6ConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        Ipv6Configuration previousConfiguration = firstCommand ? originalPortController.getIpv6Configuration() : (Ipv6Configuration)copyDownInfo.getValue();
                        commandWithReference = ipv6ConfigurationController.copyAddressConfiguration(previousConfiguration);
                        break;
                    }
                    Dhcp previousDhcp = firstCommand ? originalPortController.getDhcpv6() : (Dhcp)copyDownInfo.getValue();
                    commandWithReference = ipv6ConfigurationController.setIncrementedDhcp(previousDhcp);
                    break;
                }
                case 3: {
                    Ipv6Configuration previousIpv6Configuration = firstCommand ? originalPort.getIpv6Configuration() : (Ipv6Configuration)copyDownInfo.getValue();
                    Ipv6ConfigurationController ipv6ConfigurationController = affectedPortController.getIpv6ConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = ipv6ConfigurationController.setIncrementedIpAddress(previousIpv6Configuration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = ipv6ConfigurationController.setDecrementedIpAddress(previousIpv6Configuration);
                        break;
                    }
                    commandWithReference = ipv6ConfigurationController.copyIpAddress(previousIpv6Configuration);
                    break;
                }
                case 4: {
                    Ipv6Configuration previousIpv6Configuration = firstCommand ? originalPort.getIpv6Configuration() : (Ipv6Configuration)copyDownInfo.getValue();
                    Ipv6ConfigurationController ipv6ConfigurationController = affectedPortController.getIpv6ConfigurationController();
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        commandWithReference = ipv6ConfigurationController.setIncrementedDefaultRouter(previousIpv6Configuration);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
                        commandWithReference = ipv6ConfigurationController.setDecrementedDefaultRouter(previousIpv6Configuration);
                        break;
                    }
                    commandWithReference = ipv6ConfigurationController.copyDefaultRouter(previousIpv6Configuration);
                    break;
                }
                case 5: {
                    Ipv6Configuration previousIpv6Configuration = firstCommand ? originalPort.getIpv6Configuration() : (Ipv6Configuration)copyDownInfo.getValue();
                    Ipv6ConfigurationController ipv6ConfigurationController = affectedPortController.getIpv6ConfigurationController();
                    if (mode != ICopyDownOperation.ECopyDownMode.normal) break;
                    commandWithReference = ipv6ConfigurationController.copyPrefixLength(previousIpv6Configuration);
                    break;
                }
                case 7: {
                    Object vlanOption;
                    Object object = vlanOption = firstCommand ? originalPortController.getVlanStack() : copyDownInfo.getValue();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        commandWithReference = affectedPortController.setVlanStack(vlanOption);
                        break;
                    }
                    if (mode == ICopyDownOperation.ECopyDownMode.increment) {
                        Object vlanStack = vlanOption;
                        commandWithReference = affectedPortController.setIncrementedVlanStack(vlanStack);
                        break;
                    }
                    commandWithReference = null;
                    break;
                }
                case 8: {
                    Long previousMtu;
                    Long l = previousMtu = firstCommand ? originalPortController.getMTU() : (Long)copyDownInfo.getValue();
                    if (mode == ICopyDownOperation.ECopyDownMode.normal) {
                        commandWithReference = affectedPortController.setMtu(previousMtu);
                        break;
                    }
                    if (firstCommand) {
                        IncrementMtuDialog dialog = new IncrementMtuDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (dialog.open() != 0) break;
                        copyDownInfo.setAmount((Object)new Long(dialog.getIncrementSize()));
                    }
                    Long incrementValue = (Long)copyDownInfo.getAmount();
                    commandWithReference = affectedPortController.setIncrementedMtu(previousMtu, incrementValue);
                    break;
                }
                default: {
                    System.out.println("IPv6PortComposite : copydown : invalid case !");
                    return null;
                }
            }
        }
        if (commandWithReference != null) {
            operation.appendCommand(commandWithReference.getCommand());
            copyDownInfo.setValue(commandWithReference.getCommandReference());
            return copyDownInfo;
        }
        return null;
    }
}

