/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.flow.FlowView;
import com.excentis.products.byteblower.gui.views.scenario.composites.ScenarioActionComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class FlowMeasurementCellModifier
implements ICellModifier {
    private ScenarioActionComposite actionComposite;

    public FlowMeasurementCellModifier(ScenarioActionComposite actionComposite) {
        this.actionComposite = actionComposite;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.actionComposite.getColumnIndex(property);
        FlowMeasurement measurement = (FlowMeasurement)element;
        Flow flow = measurement.getFlow();
        FlowTemplate flowTemplate = flow == null ? null : flow.getFlowTemplate();
        if (columnIndex == 2) {
            if (flowTemplate instanceof FrameBlastingFlow) {
                return true;
            }
            if (flowTemplate instanceof TcpFlow) {
                TcpFlowReader reader = ReaderFactory.create((TcpFlow)((TcpFlow)flowTemplate));
                return reader.isTimeBased();
            }
            if (flowTemplate instanceof FrameBlastingBenchmark) {
                return true;
            }
            return true;
        }
        if (columnIndex == 3) {
            return flowTemplate instanceof FrameBlastingFlow;
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.actionComposite.getColumnIndex(property);
        Object result = null;
        FlowMeasurement action = (FlowMeasurement)element;
        FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)action);
        switch (columnIndex) {
            case 0: {
                result = reader.getStartTime();
                break;
            }
            case 1: {
                HashMap<Flow, Integer> flowMap = this.actionComposite.getFlowMap();
                Flow flow = reader.getFlow();
                if (flow == null) {
                    result = new Integer(0);
                    break;
                }
                if (flowMap.containsKey(flow)) {
                    result = flowMap.get(flow);
                }
                if (result != null) break;
                result = new Integer(0);
                System.out.println("Flow not found in combo");
                break;
            }
            case 2: {
                result = reader.getDuration();
                break;
            }
            case 3: {
                result = reader.getNumberOfFramesBigInteger();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        int columnIndex = this.actionComposite.getColumnIndex(property);
        TableItem item = (TableItem)element;
        if (item == null) {
            return;
        }
        FlowMeasurement measurement = (FlowMeasurement)item.getData();
        if (value == null) {
            return;
        }
        UndoableByteBlowerControllerOperation operation = null;
        FlowMeasurementController controller = ControllerFactory.create((FlowMeasurement)measurement);
        switch (columnIndex) {
            case 0: {
                operation = new UndoableByteBlowerControllerOperation(project, "Change Scenario Action Start Time", controller.delayStartTime((HighResolutionCalendar)value));
                break;
            }
            case 1: {
                int intValue = (Integer)value;
                if (this.actionComposite.isNewFlowIndex(intValue)) {
                    operation = this.createNewFlow(project, controller);
                    break;
                }
                operation = this.changeFlow(project, controller, intValue);
                break;
            }
            case 2: {
                operation = new UndoableByteBlowerControllerOperation(project, "Change Scenario Action Duration", controller.setDuration((HighResolutionCalendar)value));
                break;
            }
            case 3: {
                BigInteger newNofFrames = (BigInteger)value;
                operation = new UndoableByteBlowerControllerOperation(project, "Change Number of Frames", controller.setNumberOfFrames(Long.valueOf(newNofFrames.longValue())));
                break;
            }
            default: {
                System.out.println("invalid case !");
                return;
            }
        }
        if (operation != null) {
            operation.run();
        }
    }

    private UndoableByteBlowerProjectOperation changeFlow(ByteBlowerProject project, FlowMeasurementController controller, int intValue) {
        HashMap<Flow, Integer> flowMap = this.actionComposite.getFlowMap();
        Flow selectedFlow = null;
        for (Map.Entry<Flow, Integer> entry : flowMap.entrySet()) {
            if (intValue != entry.getValue()) continue;
            selectedFlow = entry.getKey();
            break;
        }
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "Change Scenario Action Flow", controller.setFlow(selectedFlow));
        return operation;
    }

    private UndoableByteBlowerProjectOperation createNewFlow(ByteBlowerProject project, FlowMeasurementController controller) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithFlowListReference flowCreation = projectController.addFlow();
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(flowCreation.getCommand());
        final Flow freshFlow = (Flow)((FlowController)((List)flowCreation.getCommandReference()).get(0)).getObject();
        compoundController.appendCommand(controller.setFlow(freshFlow));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New Flow", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                FlowView.showAndSelect(freshFlow);
            }
        });
        return operation;
    }
}

