/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.gui.jface.viewers.CompositeCellEditor;
import com.excentis.products.byteblower.gui.swt.widgets.text.DoubleTextFactory;
import com.excentis.products.byteblower.gui.views.tcp.TcpPayload;
import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.utils.Utils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class PayloadCellEditor
extends CompositeCellEditor {
    private CCombo comboType;
    private Text txtPayload;
    private CCombo comboUnit;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private TcpPayload tcpPayload;

    public PayloadCellEditor(Composite parent) {
        super(parent);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.txtPayload.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Object doGetValue() {
        String txt;
        Float payload = this.comboType.getSelectionIndex() == 0 ? ((txt = this.txtPayload.getText()).isEmpty() ? Float.valueOf(this.tcpPayload.getPayload()) : new Float(txt)) : new Float(0.0f);
        int index = this.comboUnit.getSelectionIndex();
        PayloadUnit unit = PayloadUnit.get((int)(index + 4));
        return new TcpPayload(payload.floatValue(), unit);
    }

    protected void doSetFocus() {
        if (this.txtPayload != null) {
            if (this.tcpPayload.isPayloadBased()) {
                this.txtPayload.setFocus();
                this.txtPayload.selectAll();
            } else {
                this.comboType.setFocus();
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.txtPayload != null && value instanceof TcpPayload ? 1 : 0) != 0);
        this.tcpPayload = (TcpPayload)value;
        this.txtPayload.removeModifyListener(this.getModifyListener());
        this.setValues(this.tcpPayload);
        this.txtPayload.addModifyListener(this.getModifyListener());
    }

    private void setValues(TcpPayload tcpPayload) {
        boolean isPayloadBased = tcpPayload.isPayloadBased();
        float payload = tcpPayload.getPayload();
        this.comboType.select(isPayloadBased ? 0 : 1);
        this.txtPayload.setVisible(isPayloadBased);
        this.comboUnit.setVisible(isPayloadBased);
        if (isPayloadBased) {
            this.txtPayload.setText(Utils.formatFloat((Float)Float.valueOf(payload)));
            int index = tcpPayload.getUnit().getValue() - 4;
            this.comboUnit.select(index);
        } else {
            this.txtPayload.setText("100");
            this.comboUnit.select(2);
        }
    }

    private void editOccured(ModifyEvent e) {
        String value = this.txtPayload.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = 350;
        layoutData.minimumHeight = this.itemHeight;
        return layoutData;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PayloadCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    private void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.txtPayload == null || this.txtPayload.isDisposed()) {
            return false;
        }
        return this.txtPayload.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.txtPayload == null || this.txtPayload.isDisposed()) {
            return false;
        }
        return this.txtPayload.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.txtPayload == null || this.txtPayload.isDisposed()) {
            return false;
        }
        return this.txtPayload.getSelectionCount() > 0 || this.txtPayload.getCaretPosition() < this.txtPayload.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.txtPayload != null && !this.txtPayload.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.txtPayload != null && !this.txtPayload.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.txtPayload == null || this.txtPayload.isDisposed()) {
            return false;
        }
        return this.txtPayload.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.txtPayload != null && !this.txtPayload.isDisposed() && (this.txtPayload.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.txtPayload.copy();
    }

    public void performCut() {
        this.txtPayload.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.txtPayload.getSelectionCount() > 0) {
            this.txtPayload.insert("");
        } else {
            int pos = this.txtPayload.getCaretPosition();
            if (pos < this.txtPayload.getCharCount()) {
                this.txtPayload.setSelection(pos, pos + 1);
                this.txtPayload.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.txtPayload.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.txtPayload.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return ((Object)((Object)this)).getClass() != PayloadCellEditor.class;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected void fillComposite(Composite composite) {
        this.comboType = new CCombo(composite, 2124);
        this.comboType.add("Payload Based");
        this.comboType.add("Time Based");
        this.txtPayload = DoubleTextFactory.instance().create(composite, 0, 6);
        this.txtPayload.setTextLimit(10);
        this.comboUnit = new CCombo(composite, 2124);
        this.comboUnit.add(PayloadUnit.BYTES.getName());
        this.comboUnit.add(PayloadUnit.KBYTES.getName());
        this.comboUnit.add(PayloadUnit.MBYTES.getName());
        this.comboUnit.add(PayloadUnit.GBYTES.getName());
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.comboType.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.txtPayload.setSize(100, this.itemHeight);
        this.txtPayload.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = this.itemHeight;
        gridData.heightHint = this.itemHeight;
        this.comboUnit.setLayoutData((Object)gridData);
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean on = PayloadCellEditor.this.comboType.getSelectionIndex() == 0;
                PayloadCellEditor.this.txtPayload.setVisible(on);
                PayloadCellEditor.this.comboUnit.setVisible(on);
            }
        });
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PayloadCellEditor.this.txtPayload.setFocus();
                PayloadCellEditor.this.txtPayload.selectAll();
            }
        });
        this.txtPayload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PayloadCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.txtPayload.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PayloadCellEditor.this.keyReleaseOccured(e);
                if (PayloadCellEditor.this.getControl() == null || PayloadCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                PayloadCellEditor.this.checkSelection();
                PayloadCellEditor.this.checkDeleteable();
                PayloadCellEditor.this.checkSelectable();
            }
        });
        this.txtPayload.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.txtPayload.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PayloadCellEditor.this.checkSelection();
                PayloadCellEditor.this.checkDeleteable();
                PayloadCellEditor.this.checkSelectable();
            }
        });
        this.txtPayload.addModifyListener(this.getModifyListener());
    }
}

