/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.utils.Utils;

class TcpPayload {
    private float payload;
    private PayloadUnit unit;

    public TcpPayload(float throughput, PayloadUnit unit) {
        this.payload = throughput;
        this.unit = unit;
    }

    public TcpPayload(TcpFlow tcpFlow) {
        this(tcpFlow.getPayloadSize(), tcpFlow.getPayloadUnit());
    }

    private TcpPayload(String payloadSize, PayloadUnit payloadUnit) {
        this(payloadSize.equals("Unlimited") ? 0.0f : Float.valueOf(payloadSize).floatValue(), payloadUnit);
    }

    public float getPayload() {
        return this.payload;
    }

    public void setPayload(float payload) {
        this.payload = payload;
    }

    public PayloadUnit getUnit() {
        return this.unit;
    }

    public void setUnit(PayloadUnit unit) {
        this.unit = unit;
    }

    public boolean isPayloadBased() {
        return this.payload != 0.0f;
    }

    public String getPayloadString() {
        String duration = this.payload == 0.0f ? "Unlimited" : Utils.formatFloat((Float)Float.valueOf(this.payload));
        return duration;
    }
}

