/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.vlan;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerCellModifier;
import com.excentis.products.byteblower.gui.views.vlan.VlanComposite;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.swt.widgets.TableItem;

class VlanCellModifier
extends ByteBlowerCellModifier {
    public VlanCellModifier(VlanComposite vlanComposite) {
        super((ByteBlowerModelTableComposite<?>)vlanComposite);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.getColumnIndex(property);
        Vlan vlan = (Vlan)element;
        switch (columnIndex) {
            case 0: {
                return VlanComposite.getProtocolIdIntegers().indexOf(vlan.getProtocolId());
            }
            case 2: {
                VlanReader reader = ReaderFactory.create((Vlan)vlan);
                return reader.getPriorityCodePointInteger();
            }
            case 3: {
                return vlan.isDropEligible();
            }
            case 1: {
                return vlan.getVlanId();
            }
        }
        System.err.println("VlanItemProvider#getValue() : invalid case !");
        return null;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.getColumnIndex(property);
        TableItem item = (TableItem)element;
        Vlan vlan = (Vlan)item.getData();
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                Integer index = (Integer)value;
                try {
                    Integer intValue = VlanComposite.getProtocolIdIntegers().get(index);
                    ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Vlan Protocol ID", (EByteBlowerObject)vlan, ByteblowerguimodelPackage.Literals.VLAN__PROTOCOL_ID, (Object)intValue);
                    operation.run();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                break;
            }
            case 2: {
                Integer intValue = (Integer)value;
                Byte byteValue = intValue.byteValue();
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Priority Code Point", (EByteBlowerObject)vlan, ByteblowerguimodelPackage.Literals.VLAN__PRIORITY_CODE_POINT, (Object)byteValue);
                operation.run();
                break;
            }
            case 3: {
                Boolean booleanValue = (Boolean)value;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Drop Eligible", (EByteBlowerObject)vlan, ByteblowerguimodelPackage.Literals.VLAN__DROP_ELIGIBLE, (Object)booleanValue);
                operation.run();
                break;
            }
            case 1: {
                Short shortValue = (Short)value;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Vlan Identifier", (EByteBlowerObject)vlan, ByteblowerguimodelPackage.Literals.VLAN__VLAN_ID, (Object)shortValue);
                operation.run();
                break;
            }
            default: {
                return;
            }
        }
    }
}

