/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.vlan.dnd;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.history.operations.ByteBlowerMoveOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TableItem;

public class VlanTableDropAdapter
extends ViewerDropAdapter {
    private int dropIndex;
    private IByteBlowerViewerComposite parentComposite;

    public void dragOver(DropTargetEvent event) {
        TableItem item = (TableItem)event.item;
        if (item != null) {
            Vlan dragOverVlan = (Vlan)item.getData();
            VlanStack stack = (VlanStack)this.parentComposite.getCurrentParentObject();
            EList vlans = stack.getVlans();
            this.dropIndex = vlans.indexOf((Object)dragOverVlan);
            System.out.println("drag over " + this.dropIndex);
        }
        super.dragOver(event);
    }

    public VlanTableDropAdapter(StructuredViewer viewer, IByteBlowerViewerComposite parentComposite) {
        super((Viewer)viewer);
        this.parentComposite = parentComposite;
    }

    public boolean performDrop(Object data) {
        StructuredSelection vlanData = (StructuredSelection)data;
        int draggedVlans = vlanData.size();
        int localDropIndex = this.dropIndex;
        VlanStack stack = (VlanStack)this.parentComposite.getCurrentParentObject();
        EList vlans = stack.getVlans();
        UniqueEList list = new UniqueEList();
        Vlan destination = (Vlan)vlans.get(localDropIndex);
        for (Vlan vlan : vlanData) {
            if (vlan == destination) {
                return false;
            }
            list.add((Object)vlan);
        }
        ByteBlowerMoveOperation operation = new ByteBlowerMoveOperation(ByteBlowerGuiResourceController.getProject(), "Move Vlan" + (draggedVlans > 1 ? "s" : ""), (EObject)stack, ByteblowerguimodelPackage.Literals.VLAN_STACK__VLANS, (EList)list, localDropIndex);
        operation.run();
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return ByteBlowerTransfer.getInstance(Vlan.class).isSupportedType(type);
    }
}

