/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.backtoback;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.backtoback.BackToBackTopology;
import com.excentis.products.byteblower.gui.wizards.backtoback.Messages;
import com.excentis.products.byteblower.gui.wizards.backtoback.composites.BackToBackFlowConfigComposite;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class BackToBackFlowConfigPage
extends WizardPage {
    private BackToBackTopology topology;
    private BackToBackFlowConfigComposite flowConfigComposite;
    private Flow flow;
    private FlowMeasurementController flowMeasurementController;
    int modems;
    int cpes;

    BackToBackFlowConfigPage(Flow flow, FlowMeasurementController flowMeasurementController) {
        super("DevicePage");
        this.flow = flow;
        this.flowMeasurementController = flowMeasurementController;
        this.setTitle(Messages.getString("BackToBackFlowConfigPage.Title"));
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/backtobackwizard.gif"));
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new BackToBackTopology((Composite)container, 2048);
        this.topology.showFlow();
        this.topology.applyChanges();
        this.flowConfigComposite = new BackToBackFlowConfigComposite((Composite)container, this.flow, this.flowMeasurementController);
        this.flowConfigComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackToBackFlowConfigPage.this.onChange();
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
    }

    private void onChange() {
        if (this.flowConfigComposite.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(this.flowConfigComposite.getErrorMessage());
            this.setPageComplete(false);
        }
    }
}

