/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.exp;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.project.EclipseProjectResource;
import com.excentis.products.byteblower.gui.wizards.exp.FrameExportPage;
import com.excentis.products.byteblower.gui.wizards.logger.WizardLogger;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

final class FrameExportPageContent
extends Composite {
    private Label label = null;
    private FrameExportPage page;
    private String location;
    private Button checkButton;
    private Button uncheckButton;
    private TableViewer tableViewer;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Collection<Frame> checkedFrames = new BasicEList();
    private static String frameExportDirProperty = "byteblower.frame.export.dir";
    private Text locationPathField;
    private Button browseButton;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            FrameExportPageContent.this.page.setPageComplete(FrameExportPageContent.this.validatePage());
        }
    };

    FrameExportPageContent(Composite parent, FrameExportPage page, int style) {
        super(parent, style);
        this.page = page;
        this.initialize();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (FrameExportPageContent.this.label != null) {
                    FrameExportPageContent.this.label.dispose();
                }
            }
        });
    }

    private void initialize() {
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        Table frameTable = new Table((Composite)this, 2082);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        frameTable.setLayoutData((Object)gridData);
        Menu menu = this.createPopupMenu((Composite)frameTable);
        frameTable.setMenu(menu);
        this.tableViewer = new TableViewer(frameTable);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public void notifyChanged(Notification notification) {
                int featureID;
                Object notifier = notification.getNotifier();
                if (notifier instanceof Frame) {
                    super.notifyChanged(notification);
                } else if (notifier instanceof ByteBlowerProject && (featureID = notification.getFeatureID(ByteBlowerProject.class)) == 9) {
                    super.notifyChanged(notification);
                }
            }

            public Object[] getElements(Object object) {
                ByteBlowerProject project = (ByteBlowerProject)object;
                return project.getFrame().toArray();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FrameExportPageContent.this.updateButtons();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        this.tableViewer.setInput((Object)project);
        this.checkButton = new Button((Composite)this, 0);
        this.checkButton.setText("Check Selected");
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameExportPageContent.this.checkSelected(true);
            }
        });
        this.uncheckButton = new Button((Composite)this, 0);
        this.uncheckButton.setText("Uncheck Selected");
        this.uncheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameExportPageContent.this.checkSelected(false);
            }
        });
        Button invisiFill = new Button((Composite)this, 0);
        invisiFill.setVisible(false);
        invisiFill.setLayoutData((Object)new GridData(768));
        Composite fileComposiste = new Composite((Composite)this, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        fileComposiste.setLayoutData((Object)gridData);
        fileComposiste.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(fileComposiste, 0);
        label.setText("To file:");
        this.locationPathField = new Text(fileComposiste, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.locationPathField.setLayoutData((Object)gridData);
        this.locationPathField.setEditable(false);
        this.browseButton = new Button(fileComposiste, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FrameExportPageContent.this.handleLocationBrowseButtonPressed();
            }
        });
        this.locationPathField.addListener(24, this.locationModifyListener);
        this.updateButtons();
    }

    private void checkSelected(boolean check) {
        Table table = this.tableViewer.getTable();
        int[] selectionIndices = table.getSelectionIndices();
        int selectionSize = selectionIndices.length;
        int i = 0;
        while (i < selectionSize) {
            table.getItem(selectionIndices[i]).setChecked(check);
            ++i;
        }
        this.updateButtons();
    }

    private Menu createPopupMenu(Composite parent) {
        Menu popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                boolean selectionEmpty = FrameExportPageContent.this.tableViewer.getSelection().isEmpty();
                boolean checkSelected = !selectionEmpty;
                boolean uncheckSelected = !selectionEmpty;
                items[0].setEnabled(checkSelected);
                items[1].setEnabled(uncheckSelected);
            }
        });
        MenuItem item = new MenuItem(popUpMenu, 8);
        item.setText("Check");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameExportPageContent.this.checkSelected(true);
            }
        });
        item = new MenuItem(popUpMenu, 8);
        item.setText("Uncheck");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameExportPageContent.this.checkSelected(false);
            }
        });
        return popUpMenu;
    }

    private void updateButtons() {
        boolean enableCheck = false;
        boolean enableUncheck = false;
        TableItem[] sel = this.tableViewer.getTable().getSelection();
        int selPorts = sel.length;
        int i = 0;
        while (i < selPorts) {
            TableItem selectedItem = sel[i];
            if (selectedItem.getChecked()) {
                enableUncheck = true;
            } else {
                enableCheck = true;
            }
            ++i;
        }
        this.checkButton.setEnabled(enableCheck);
        this.uncheckButton.setEnabled(enableUncheck);
        this.page.setPageComplete(this.validatePage());
    }

    private Collection<Frame> updateAndGetSelectedByteBlowerFrames() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        int nofFrames = project.getFrame().size();
        this.checkedFrames.clear();
        int i = 0;
        while (i < nofFrames) {
            Frame frame = (Frame)this.tableViewer.getElementAt(i);
            if (this.tableViewer.getTable().getItem(i).getChecked()) {
                this.checkedFrames.add(frame);
            }
            ++i;
        }
        return this.checkedFrames;
    }

    public String getFilename() {
        this.location = this.locationPathField.getText().trim();
        return this.location;
    }

    public void addControlListener(ControlListener listener) {
        super.addControlListener(listener);
    }

    private void handleLocationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.locationPathField.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.bbf"});
        String curDir = ByteBlowerPreferences.getPreferences().get(frameExportDirProperty, null);
        if (curDir != null && curDir.length() != 0) {
            dialog.setFilterPath(curDir);
        } else {
            dialog.setFilterPath(EclipseProjectResource.getDefaultProjectLocation());
        }
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.location = selectedFile;
            this.locationPathField.setText(this.location);
            Path path = new Path(selectedFile);
            path = path.removeLastSegments(1);
            if (path.toFile().exists()) {
                ByteBlowerPreferences.getPreferences().put(frameExportDirProperty, path.toOSString());
            }
        }
    }

    private boolean validatePage() {
        if (!ByteBlowerGuiResourceController.getInstance().isOpen()) {
            this.page.setErrorMessage("Please open a project first.");
            return false;
        }
        if (ByteBlowerGuiResourceController.getProjectController().getFrameControllers().isEmpty()) {
            this.page.setErrorMessage("The current project contains no Frames.");
            return false;
        }
        this.page.setMessage("Export Frames to a file on the local file system");
        boolean checkedFrames = !this.updateAndGetSelectedByteBlowerFrames().isEmpty();
        boolean locationKnown = false;
        this.location = this.locationPathField.getText().trim();
        boolean bl = locationKnown = this.location.length() > 0;
        return checkedFrames && locationKnown;
    }

    void performFinish() {
        this.location = this.locationPathField.getText().trim();
        Collection<Frame> frames = this.updateAndGetSelectedByteBlowerFrames();
        File testOverwrite = new File(this.location);
        if (testOverwrite.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite ?", (String)("\"" + this.location + "\" already exists.\n\n" + "Would you like to overwrite it ?"))) {
            return;
        }
        XMIResourceImpl resource = new XMIResourceImpl(URI.createFileURI((String)this.location));
        Collection frameCopies = EcoreUtil.copyAll(frames);
        resource.getContents().addAll(frameCopies);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Export", (String)"Failed to export the Frames");
            e.printStackTrace();
            WizardLogger.log("Failed to export Frames : " + e.getMessage());
        }
    }
}

