/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.ByteBlowerWizardPortConfigComposite;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizTopology;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizTopologyPage;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizard;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.Layer2Configuration;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.ByteController;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class FrameSizeWizPortConfigPage
extends FrameSizeWizTopologyPage {
    private ByteBlowerWizardPortConfigComposite portConfigComposite;
    private boolean isSource = true;
    int modems;
    int cpes;
    private String portName;

    public void dispose() {
        this.wizard.removeTakenName(this.portName);
        super.dispose();
    }

    FrameSizeWizPortConfigPage(FrameSizeWizard wizard, boolean isSource, int destinationIndex) {
        super("FrameSizePortConfigPage", wizard, isSource);
        ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
        this.port = factory.createByteBlowerGuiPort();
        ByteBlowerGuiPortConfiguration portConfig = factory.createByteBlowerGuiPortConfiguration();
        this.port.setByteBlowerGuiPortConfiguration(portConfig);
        this.portName = OldNamingTools.getIncrementedName((String)("Frame Size " + (isSource ? "Source " : "Destination ")), wizard.getTakenPortNames());
        this.port.setName(this.portName);
        wizard.addTakenName(this.portName);
        EthernetConfiguration ethernet = factory.createEthernetConfiguration();
        MacAddress mac = factory.createMacAddress();
        EList macBytes = mac.getBytes();
        macBytes.clear();
        String hexMac = Integer.toString(destinationIndex + 1, 16);
        byte[] bytes = Utils.hexStringToBuffer((String)hexMac);
        int macDef = bytes.length;
        int i = 0;
        while (i < 6 - macDef) {
            macBytes.add((Object)Byte.valueOf("0"));
            ++i;
        }
        i = 0;
        while (i < macDef) {
            macBytes.add((Object)ByteController.byteToByte((byte)bytes[i]));
            ++i;
        }
        ethernet.setMacAddress(mac);
        this.port.setLayer2Configuration((Layer2Configuration)ethernet);
        Ipv4Configuration ipv4 = factory.createIpv4Configuration();
        this.initIpv4(ipv4, isSource, destinationIndex);
        this.port.setIpv4Configuration(ipv4);
        this.init(isSource);
    }

    private void initIpv4(Ipv4Configuration iPv4Configuration, boolean isSource, int destinationIndex) {
        ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
        Ipv4Address ip = factory.createIpv4Address();
        int ip3 = (1 + destinationIndex) / 255;
        int ip4 = 1 + (1 + destinationIndex) % 255;
        String ipString = isSource ? "10.0.0.2" : "10.0." + ip3 + "." + ip4;
        Ipv4AddressController.setAddress((Ipv4Address)ip, (String)ipString);
        iPv4Configuration.setIpAddress(ip);
        ip = factory.createIpv4Address();
        Ipv4AddressController.setAddress((Ipv4Address)ip, (String)"10.0.0.1");
        iPv4Configuration.setDefaultGateway(ip);
        ip = factory.createIpv4Address();
        Ipv4AddressController.setAddress((Ipv4Address)ip, (String)"255.255.255.0");
        iPv4Configuration.setNetmask(ip);
        iPv4Configuration.setIsActive(Boolean.TRUE);
        iPv4Configuration.setAddressConfiguration(Ipv4AddressConfigType.FIXED);
    }

    private void init(boolean isSource) {
        if (isSource) {
            this.setTitle("Source Port configuration");
        } else {
            this.setTitle("Destination Port configuration");
        }
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/framesizewizard.gif"));
        this.isSource = isSource;
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new FrameSizeWizTopology((Composite)container, 2048);
        this.portConfigComposite = new ByteBlowerWizardPortConfigComposite((Composite)container, 2048, this.port, this.isSource);
        this.portConfigComposite.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FrameSizeWizPortConfigPage.this.onChange();
            }
        });
        this.portConfigComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FrameSizeWizPortConfigPage.this.onChange();
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
        this.onChange(false);
        this.updateTopologyIfNecessary(false);
    }

    private void onChange() {
        this.onChange(true);
    }

    private void onChange(boolean showErrorMessage) {
        if (this.portConfigComposite.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            if (showErrorMessage) {
                this.setErrorMessage(this.portConfigComposite.getErrorMessage());
            }
            this.setPageComplete(false);
        }
    }

    public PhysicalDockable getDockable() {
        return this.portConfigComposite.getDockable();
    }

    public ByteBlowerGuiPort getPort() {
        return this.port;
    }

    public FrameSizeWizTopology getTopology() {
        return this.topology;
    }
}

