/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize.composites;

import com.excentis.products.byteblower.gui.wizards.framesize.composites.FrameSizeWizGeneralConfigComposite;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.math.BigInteger;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

class FrameSizeWizCellModifier
implements ICellModifier {
    private FrameSizeWizGeneralConfigComposite generalConfig;

    FrameSizeWizCellModifier(FrameSizeWizGeneralConfigComposite generalConfig) {
        this.generalConfig = generalConfig;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.generalConfig.getColumnNames().indexOf(property);
        return columnIndex == 1 && FrameSizeWizGeneralConfigComposite.allowEdit;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.generalConfig.getColumnNames().indexOf(property);
        Object result = null;
        Frame frame = (Frame)element;
        FrameReader reader = ReaderFactory.create((Frame)frame);
        switch (columnIndex) {
            case 0: {
                result = frame.getName();
                break;
            }
            case 1: {
                result = new BigInteger(Integer.toString(reader.getByteSize(ThroughputType.FRAME_ONLY)));
                break;
            }
            default: {
                System.out.println("invalid case !");
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.generalConfig.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        Frame frame = (Frame)item.getData();
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                int size = ((BigInteger)value).intValue();
                this.generalConfig.resizeFrame(frame, size);
                break;
            }
            default: {
                return;
            }
        }
    }
}

