/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard;

import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.composites.FlowConfigurationPage;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.FullMeshWizard;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.Messages;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites.TopologyOverview;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

class FlowConfigurationWizardPage
extends WizardPage {
    private Composite container;
    private Composite configurationContainer;
    private TopologyOverview topology;
    private FlowConfigurationPage flowConfiguration;

    public FlowConfigurationWizardPage() {
        super(Messages.getString("FlowConfigurationWizardPage.Name"));
        this.setTitle(Messages.getString("FlowConfigurationWizardPage.Title"));
        this.setDescription(Messages.getString("FlowConfigurationWizardPage.Description"));
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.fill = false;
        this.container.setLayout((Layout)rowLayout);
        this.setControl((Control)this.container);
        this.configurationContainer = new Composite(this.container, 0);
        this.configurationContainer.setLayoutData((Object)new RowData());
        RowLayout fillLayout = new RowLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        fillLayout.fill = false;
        this.configurationContainer.setLayout((Layout)fillLayout);
        this.topology = new TopologyOverview(this.configurationContainer, 2048);
        this.topology.setLayoutData(new RowData());
        this.flowConfiguration = new FlowConfigurationPage(this.configurationContainer, 0);
        this.flowConfiguration.setLayoutData(new RowData());
        this.setPageComplete(false);
        this.flowConfiguration.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FlowConfigurationWizardPage.this.onChange();
            }
        });
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FlowConfigurationWizardPage.this.onResize();
            }
        });
        this.container.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                FlowConfigurationWizardPage.this.onDispose();
            }
        });
        this.configurationContainer.pack();
        this.container.pack();
        Rectangle bounds = parent.getClientArea();
        this.container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        this.onResize();
        this.onChange();
    }

    private void onResize() {
        Rectangle bounds = this.container.getBounds();
        ((RowData)this.configurationContainer.getLayoutData()).width = bounds.width - 10;
        ((RowData)this.configurationContainer.getLayoutData()).height = bounds.height - 10;
        ((RowData)this.topology.getLayoutData()).width = (bounds.width - 10) / 2 - 10;
        ((RowData)this.flowConfiguration.getLayoutData()).width = (bounds.width - 10) / 2 - 10;
        ((RowData)this.topology.getLayoutData()).height = bounds.height - 24;
        ((RowData)this.flowConfiguration.getLayoutData()).height = bounds.height - 24;
        this.configurationContainer.layout();
        this.container.layout();
    }

    private void onChange() {
        if (this.flowConfiguration.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(this.flowConfiguration.getErrorMessage());
            this.setPageComplete(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.topology.setNumberOfPorts(((FullMeshWizard)this.getWizard()).getNumberOfPorts());
            this.topology.applyChanges();
        }
        super.setVisible(visible);
    }

    private void onDispose() {
    }
}

