/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites;

import com.excentis.products.byteblower.gui.wizards.topology.PortDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import com.excentis.products.byteblower.gui.wizards.topology.layout.MeshLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TopologyOverview
extends Composite {
    private static final int maxNumberOfPorts = 20;
    private Canvas canvas = null;
    private GridData canvasData = null;
    private LightweightSystem lws = null;
    Figure contents = null;
    private TopologyLayout topologyLayout = null;
    private List<PortDevice> portList = new ArrayList<PortDevice>();
    private boolean changes = false;

    public TopologyOverview(Composite parent, int style) {
        super(parent, style);
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 1;
        localGridlayout.marginWidth = 0;
        localGridlayout.marginHeight = 0;
        localGridlayout.horizontalSpacing = 0;
        localGridlayout.verticalSpacing = 0;
        localGridlayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)localGridlayout);
        this.canvas = new Canvas((Composite)this, 0);
        this.canvasData = new GridData(4, 4, false, false);
        this.canvas.setLayoutData((Object)this.canvasData);
        this.lws = new LightweightSystem(this.canvas);
        this.contents = new Figure();
        XYLayout contentsLayout = new XYLayout();
        this.contents.setLayoutManager((LayoutManager)contentsLayout);
        this.topologyLayout = new MeshLayout(this.contents);
        this.lws.setContents((IFigure)this.contents);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = TopologyOverview.this.getBounds();
                TopologyOverview.this.canvasData.widthHint = bounds.width;
                TopologyOverview.this.canvasData.heightHint = bounds.height;
                TopologyOverview.this.layout();
                TopologyOverview.this.Redraw();
            }
        });
    }

    private void Redraw() {
        this.topologyLayout.Update(false);
    }

    public void applyChanges() {
        if (this.changes) {
            this.topologyLayout.Update(true);
        }
        this.changes = false;
    }

    public void setNumberOfPorts(int numberOfPorts) {
        this.changes = true;
        if (numberOfPorts > 20) {
            numberOfPorts = 20;
        }
        int i = this.portList.size();
        while (i < numberOfPorts) {
            System.out.println("Adding Port " + i);
            PortDevice newPort = new PortDevice();
            newPort.setLayoutManager(this.topologyLayout);
            for (TopologyDevice topologyDevice : this.portList) {
                topologyDevice.addChild(newPort);
            }
            newPort.setLocation(new Point(this.contents.getBounds().width / 2, this.contents.getBounds().height / 2));
            this.portList.add(newPort);
            ++i;
        }
        i = this.portList.size() - 1;
        while (i >= numberOfPorts) {
            System.out.println("Removing Port " + i);
            TopologyDevice victim = this.portList.get(i);
            int j = 0;
            while (j < numberOfPorts) {
                TopologyDevice topologyDevice = this.portList.get(j);
                topologyDevice.removeChild(victim);
                ++j;
            }
            this.portList.remove((Object)victim);
            victim.remove();
            --i;
        }
    }

    public void setFocusOnPort(int position) {
        if (position < this.portList.size()) {
            ((TopologyDevice)this.portList.get(position)).Focus();
        }
    }
}

