/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.saveasproject;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.ImageDataFactory;
import com.excentis.products.byteblower.gui.widgets.project.EclipseProjectResource;
import com.excentis.products.byteblower.gui.wizards.saveasproject.Messages;
import com.excentis.products.byteblower.gui.wizards.saveasproject.SaveAsProjectPage;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

final class SaveAsProjectPageContent
extends Composite {
    private SaveAsProjectPage page;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Label label = null;
    private ImageData imageData = null;
    private Image image = null;
    private Canvas imageGroup = null;
    private Group labelGroup = null;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;

    SaveAsProjectPageContent(Composite parent, SaveAsProjectPage page, int style, String imageFile) {
        super(parent, style);
        this.page = page;
        this.initialize();
        this.setImage(imageFile);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = SaveAsProjectPageContent.this.getBounds();
                double imageRelation = (double)bounds.height * (double)SaveAsProjectPageContent.this.imageData.width / (double)SaveAsProjectPageContent.this.imageData.height / (double)bounds.width;
                ((GridData)SaveAsProjectPageContent.this.imageGroup.getLayoutData()).widthHint = (int)((double)bounds.width * imageRelation) - 7;
                ((GridData)SaveAsProjectPageContent.this.labelGroup.getLayoutData()).widthHint = (int)((double)bounds.width * (1.0 - imageRelation)) - 7;
                SaveAsProjectPageContent.this.layout();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (SaveAsProjectPageContent.this.label != null) {
                    SaveAsProjectPageContent.this.label.dispose();
                }
                if (SaveAsProjectPageContent.this.image != null) {
                    SaveAsProjectPageContent.this.image.dispose();
                }
                if (SaveAsProjectPageContent.this.imageGroup != null) {
                    SaveAsProjectPageContent.this.imageGroup.dispose();
                }
                if (SaveAsProjectPageContent.this.labelGroup != null) {
                    SaveAsProjectPageContent.this.labelGroup.dispose();
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (!SaveAsProjectPageContent.this.imageGroup.isDisposed()) {
                    SaveAsProjectPageContent.this.imageGroup.setFocus();
                }
            }
        });
        this.locationPathField.setText(ByteBlowerGuiResourceController.getInstance().getActiveFileName());
    }

    private void initialize() {
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 2;
        localGridlayout.marginWidth = 5;
        localGridlayout.marginHeight = 5;
        localGridlayout.horizontalSpacing = 5;
        localGridlayout.verticalSpacing = 5;
        this.setLayout((Layout)localGridlayout);
        this.imageGroup = new Canvas((Composite)this, 0);
        this.imageGroup.setBackground(ColorConstants.white);
        this.imageGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.labelGroup = new Group((Composite)this, 0);
        this.labelGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout labelGridlayout = new GridLayout();
        labelGridlayout.numColumns = 1;
        this.labelGroup.setLayout((Layout)labelGridlayout);
        this.createProjectLocationGroup((Composite)this.labelGroup);
    }

    private void setImage(String imageFile) {
        this.imageData = ImageDataFactory.instance().create(imageFile);
        this.imageGroup.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                Rectangle r = SaveAsProjectPageContent.this.imageGroup.getClientArea();
                Image image = new Image((Device)event.display, SaveAsProjectPageContent.this.imageData);
                int x = (r.width - 106) / 2;
                int y = (r.height - 208) / 2;
                gc.drawImage(image, x, y);
            }
        });
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = this.getFont();
        Group projectGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        projectGroup.setFont(font);
        projectGroup.setText(Messages.getString("SaveAsProjectPageContent.ProjectGroupLabel"));
        this.createUserSpecifiedProjectLocationGroup((Composite)projectGroup);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(Messages.getString("SaveAsProjectPageContent.LocationLabel"));
        this.locationLabel.setFont(font);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.locationPathField.setEditable(true);
        this.locationPathField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SaveAsProjectPageContent.this.page.setPageComplete(SaveAsProjectPageContent.this.validatePage());
            }
        });
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(Messages.getString("SaveAsProjectPageContent.BrowseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveAsProjectPageContent.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setFont(font);
    }

    public String getFilePath() {
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.locationPathField.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.bbp"});
        String location = this.locationPathField.getText().trim();
        if (Path.ROOT.isValidPath(location)) {
            Path saveaspath = new Path(location);
            dialog.setFilterPath(saveaspath.makeAbsolute().removeLastSegments(1).toOSString());
        } else {
            dialog.setFilterPath(EclipseProjectResource.getDefaultProjectLocation());
        }
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.locationPathField.setText(selectedFile);
        }
    }

    private boolean validatePage() {
        String location = this.locationPathField.getText().trim();
        if (!Path.ROOT.isValidPath("location")) {
            this.page.setErrorMessage(Messages.getString("SaveAsProjectPageContent.InvalidPathError"));
            return false;
        }
        Path saveasPath = new Path(location);
        if (saveasPath.isEmpty()) {
            this.page.setErrorMessage(Messages.getString("SaveAsProjectPageContent.EmptyPathError"));
            return false;
        }
        if (saveasPath.getFileExtension() == null || !saveasPath.getFileExtension().equals("bbp")) {
            this.page.setErrorMessage(Messages.getString("SaveAsProjectPageContent.ExtensionError"));
            return false;
        }
        this.page.setErrorMessage(null);
        return true;
    }
}

