/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.throughput.Messages;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputTopology;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizard;
import com.excentis.products.byteblower.gui.wizards.throughput.composites.ThroughputFlowDurationConfigComposite;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class ThroughputFlowSizeConfigPage
extends WizardPage {
    private ThroughputTopology topology;
    private ThroughputWizard wizard;
    private ThroughputFlowDurationConfigComposite flowDurationConfigComposite;

    public ThroughputFlowSizeConfigPage(ThroughputWizard wizard) {
        super("ThroughputFlowSizeConfigPage");
        this.wizard = wizard;
        this.setTitle(Messages.getString("FlowSizeConfigPage.Title"));
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/throughputwizard.gif"));
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new ThroughputTopology((Composite)container, 2048);
        this.topology.showFlow();
        this.topology.applyChanges();
        this.flowDurationConfigComposite = new ThroughputFlowDurationConfigComposite((Composite)container, this.wizard);
        this.flowDurationConfigComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThroughputFlowSizeConfigPage.this.onChange();
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
    }

    private void onChange() {
        if (this.flowDurationConfigComposite.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(this.flowDurationConfigComposite.getErrorMessage());
            this.setPageComplete(false);
        }
    }

    public void flowCountChanged() {
        if (this.flowDurationConfigComposite != null) {
            this.flowDurationConfigComposite.flowCountChanged();
            this.onChange();
        }
    }

    public boolean getIsFixedNofFrames() {
        return this.flowDurationConfigComposite.getIsFixedNofFrames();
    }

    public HighResolutionCalendar getDuration() {
        return this.flowDurationConfigComposite.getDuration();
    }

    public String getNofFrames() {
        return this.flowDurationConfigComposite.getNofFrames();
    }

    public HighResolutionCalendar getPauseTime() {
        return this.flowDurationConfigComposite.getPauseTime();
    }
}

