/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput;

import com.excentis.products.byteblower.gui.wizards.topology.PortDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import com.excentis.products.byteblower.gui.wizards.topology.layout.CroppedTreeLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

class ThroughputTopology
extends Composite {
    private Canvas canvas = null;
    private GridData canvasData = null;
    private LightweightSystem lws = null;
    private Figure contents = null;
    private PortDevice sourcePort = null;
    private PortDevice destinationPort = null;
    private TopologyLayout topologyLayout = null;
    private boolean changes = false;

    public ThroughputTopology(Composite parent, int style) {
        super(parent, style);
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 1;
        localGridlayout.marginWidth = 0;
        localGridlayout.marginHeight = 0;
        localGridlayout.horizontalSpacing = 0;
        localGridlayout.verticalSpacing = 0;
        localGridlayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)localGridlayout);
        this.canvas = new Canvas((Composite)this, 0);
        this.canvasData = new GridData(4, 4, false, false);
        this.canvas.setLayoutData((Object)this.canvasData);
        this.canvas.setBackground(ColorConstants.white);
        this.lws = new LightweightSystem(this.canvas);
        this.contents = new Figure();
        XYLayout contentsLayout = new XYLayout();
        this.contents.setLayoutManager((LayoutManager)contentsLayout);
        this.topologyLayout = new CroppedTreeLayout(this.contents);
        this.sourcePort = new PortDevice("SOURCE PORT");
        this.sourcePort.setLayoutManager(this.topologyLayout);
        this.destinationPort = new PortDevice("DESTINATION PORT");
        this.destinationPort.setLayoutManager(this.topologyLayout);
        this.sourcePort.addChild(this.destinationPort);
        this.lws.setContents((IFigure)this.contents);
        this.initialize();
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = ThroughputTopology.this.getBounds();
                ThroughputTopology.this.canvasData.widthHint = bounds.width;
                ThroughputTopology.this.canvasData.heightHint = bounds.height;
                ThroughputTopology.this.layout();
                ThroughputTopology.this.Redraw();
            }
        });
    }

    private void Redraw() {
        this.topologyLayout.Update(false);
    }

    private void initialize() {
    }

    public void applyChanges() {
        if (this.changes) {
            this.topologyLayout.Update(true);
        }
        this.changes = false;
    }

    public void setFocusOnDestinationPort() {
        this.destinationPort.Focus();
    }

    public void showFlow() {
        this.sourcePort.addFlow(this.destinationPort);
    }

    public void focusOnSource() {
        this.sourcePort.Focus();
    }
}

