/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput.composites;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.widgets.composites.IRateCompositeListener;
import com.excentis.products.byteblower.gui.widgets.composites.RateComposite;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizard;
import com.excentis.products.byteblower.gui.wizards.throughput.composites.SpeedIncrementComposite;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.impl.FrameReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ThroughputFlowSpeedConfigComposite
extends Composite
implements ModifyListener,
IRateCompositeListener {
    private String errorMessage;
    private ThroughputWizard wizard;
    private Text txtFrameSize;
    private RateComposite minSpeedComposite;
    private SpeedIncrementComposite incrSpeedComposite;
    private RateComposite maxSpeedComposite;
    private Text txtFlowCount;
    private Frame throughputFrame;
    private FrameBlastingFlowController minSpeedFlowTemplateController;
    private FrameBlastingFlowController incrSpeedFlowTemplateController;
    private FrameBlastingFlowController maxSpeedFlowTemplateController;
    private BigInteger flowCountBigInteger = null;
    private static BigInteger maxFlowCount = new BigInteger("10000");

    public ThroughputFlowSpeedConfigComposite(Composite parent, Frame throughputFrame, FrameBlastingFlow minSpeedFlowTemplate, FrameBlastingFlow incrSpeedFlowTemplate, FrameBlastingFlow maxSpeedFlowTemplate, ThroughputWizard wizard) {
        super(parent, 2048);
        this.wizard = wizard;
        this.throughputFrame = throughputFrame;
        this.minSpeedFlowTemplateController = ControllerFactory.create((FrameBlastingFlow)minSpeedFlowTemplate);
        this.incrSpeedFlowTemplateController = ControllerFactory.create((FrameBlastingFlow)incrSpeedFlowTemplate);
        this.maxSpeedFlowTemplateController = ControllerFactory.create((FrameBlastingFlow)maxSpeedFlowTemplate);
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText("Frame");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblFrameSize = new Label((Composite)group, 0);
        lblFrameSize.setText("Size (bytes):");
        this.txtFrameSize = IntegerTextFactory.instance().create((Composite)group, 9999L);
        this.txtFrameSize.setLayoutData((Object)new GridData(768));
        this.txtFrameSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int frameSize = Integer.parseInt(ThroughputFlowSpeedConfigComposite.this.txtFrameSize.getText());
                    if (frameSize >= 60 && frameSize <= 8192) {
                        ThroughputFlowSpeedConfigComposite.this.updateSpeedComposite(frameSize);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        group = new Group((Composite)this, 0);
        group.setText("Minimum Speed");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new FillLayout());
        this.minSpeedComposite = new RateComposite((Composite)group, 0, this.getProjectReader(), this.minSpeedFlowTemplateController);
        this.minSpeedComposite.addRateModificationListener((IRateCompositeListener)this);
        group = new Group((Composite)this, 0);
        group.setText("Speed Increment");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new FillLayout());
        this.incrSpeedComposite = new SpeedIncrementComposite((Composite)group, 0, this.incrSpeedFlowTemplateController);
        this.incrSpeedComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThroughputFlowSpeedConfigComposite.this.updateFlowCount();
            }
        });
        this.incrSpeedComposite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ThroughputFlowSpeedConfigComposite.this.updateFlowCount();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        group = new Group((Composite)this, 0);
        group.setText("Maximum Speed");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new FillLayout());
        this.maxSpeedComposite = new RateComposite((Composite)group, 0, this.getProjectReader(), this.maxSpeedFlowTemplateController);
        this.maxSpeedComposite.addRateModificationListener((IRateCompositeListener)this);
        group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblFlowCount = new Label((Composite)group, 0);
        lblFlowCount.setText("Amount of resulting Flows:");
        this.txtFlowCount = new Text((Composite)group, 2048);
        this.txtFlowCount.setLayoutData((Object)new GridData(768));
        this.txtFlowCount.setEditable(false);
        this.initializeValues();
    }

    private ByteBlowerProjectReader getProjectReader() {
        return ByteBlowerGuiResourceController.getProjectReader();
    }

    private void updateSpeedComposite(int frameSize) {
        String newBytes;
        FrameController controller = ControllerFactory.create((Frame)this.throughputFrame);
        Command command = controller.setFrameSize(frameSize);
        if (command != null) {
            command.execute();
        }
        if ((newBytes = controller.getHexBytes()) != null) {
            this.throughputFrame.setBytesHexString(newBytes);
            this.minSpeedFlowTemplateController.setStatusUnknown();
            this.maxSpeedFlowTemplateController.setStatusUnknown();
        }
    }

    private void initializeValues() {
        FrameReaderImpl reader = new FrameReaderImpl(this.throughputFrame);
        int byteSize = reader.getByteSize(ThroughputType.FRAME_ONLY);
        this.txtFrameSize.setText(Integer.toString(byteSize));
    }

    public void addModifyListener(ModifyListener listener) {
        this.txtFrameSize.addModifyListener(listener);
        this.incrSpeedComposite.addModifyListener(listener);
        this.minSpeedComposite.addModifyListener(false, listener);
        this.maxSpeedComposite.addModifyListener(false, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.incrSpeedComposite.addSelectionListener(listener);
    }

    private void updateFlowCount() {
        SpeedIncrementComposite.ESpeedIncrementType speedIncrementType = this.incrSpeedComposite.getSpeedIncrementType();
        if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_FRAME_RATE) {
            BigDecimal max;
            BigDecimal min = this.minSpeedComposite.getFrameRate();
            if (min.compareTo(max = this.maxSpeedComposite.getFrameRate()) <= 0) {
                String incrRate = this.incrSpeedComposite.getFrameRate();
                try {
                    BigDecimal incr = new BigDecimal(incrRate);
                    if (incr.compareTo(BigDecimal.ZERO) == 1) {
                        BigDecimal biFlowCount = max.subtract(min).divide(incr, 0, 1).add(BigDecimal.ONE);
                        this.flowCountBigInteger = biFlowCount.toBigInteger();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_INTENDED_LOAD) {
            BigDecimal max;
            BigDecimal min = this.minSpeedComposite.getThroughput(ThroughputType.FRAME_ONLY);
            if (min.compareTo(max = this.maxSpeedComposite.getThroughput(ThroughputType.FRAME_ONLY)) <= 0) {
                String incrThroughput = this.incrSpeedComposite.getThroughput();
                try {
                    BigDecimal incr = new BigDecimal(incrThroughput);
                    incr = Utils.convertToBps((BigDecimal)incr, (int)this.incrSpeedComposite.getThroughputUnit());
                    if (incr.compareTo(BigDecimal.ZERO) == 1) {
                        BigDecimal biFlowCount = max.subtract(min).divide(incr, 0, 1).add(BigDecimal.ONE);
                        this.flowCountBigInteger = biFlowCount.toBigInteger();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.DECREMENT_FRAME_INTERVAL) {
            HighResolutionCalendar minInterval = this.minSpeedComposite.getFrameInterval();
            HighResolutionCalendar maxInterval = this.maxSpeedComposite.getFrameInterval();
            BigDecimal minNanos = new BigDecimal(minInterval.getTimeInNanoseconds());
            BigDecimal maxNanos = new BigDecimal(maxInterval.getTimeInNanoseconds());
            if (maxNanos.compareTo(minNanos) <= 0) {
                HighResolutionCalendar decrInterval = this.incrSpeedComposite.getFrameInterval();
                try {
                    BigDecimal incr = new BigDecimal(decrInterval.getTimeInNanoseconds());
                    if (incr.compareTo(BigDecimal.ZERO) == 1) {
                        BigDecimal biFlowCount = minNanos.subtract(maxNanos).divide(incr, 0, 1).add(BigDecimal.ONE);
                        this.flowCountBigInteger = biFlowCount.toBigInteger();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else {
            System.err.println("ThroughputFlowSpeedConfigComposite::updateFlowCount : unknown speedIncrementType");
        }
        this.txtFlowCount.setText(this.flowCountBigInteger.toString());
        this.wizard.flowCountChanged();
    }

    public boolean isComplete() {
        BigDecimal maxRate;
        int frameSize = 0;
        this.incrSpeedComposite.setFrameRateColor(null);
        this.incrSpeedComposite.setFrameIntervalColor(null);
        this.txtFlowCount.setForeground(null);
        try {
            frameSize = Integer.parseInt(this.txtFrameSize.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        this.txtFrameSize.setForeground(null);
        if (frameSize < 60) {
            this.txtFrameSize.setForeground(ColorConstants.red);
            this.errorMessage = "The Frame size is too small. The minimum Frame size is 60 bytes.";
            return false;
        }
        if (frameSize > 8192) {
            this.txtFrameSize.setForeground(ColorConstants.red);
            this.errorMessage = "The Frame size is too big. The maximum Frame size is 8192 bytes.";
            return false;
        }
        if (!this.minSpeedComposite.isComplete()) {
            this.errorMessage = this.minSpeedComposite.getErrorMessage();
            return false;
        }
        if (!this.incrSpeedComposite.isComplete()) {
            this.errorMessage = this.incrSpeedComposite.getErrorMessage();
            return false;
        }
        if (!this.maxSpeedComposite.isComplete()) {
            this.errorMessage = this.maxSpeedComposite.getErrorMessage();
            return false;
        }
        BigDecimal minRate = this.minSpeedComposite.getFrameRate();
        if (minRate.compareTo(maxRate = this.maxSpeedComposite.getFrameRate()) >= 0) {
            this.errorMessage = "The Minimum Frame Rate has to be smaller than the Maximum Frame Rate.";
            return false;
        }
        SpeedIncrementComposite.ESpeedIncrementType speedIncrementType = this.incrSpeedComposite.getSpeedIncrementType();
        if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_FRAME_RATE) {
            BigDecimal maxIncrementRate = maxRate.subtract(minRate);
            BigDecimal incrRate = new BigDecimal(this.incrSpeedComposite.getFrameRate());
            if (incrRate.compareTo(maxIncrementRate) == 1) {
                this.errorMessage = "The Maximum Increment Frame Rate is " + Utils.trim((String)maxIncrementRate.toString()) + " (Frames/s).";
                this.incrSpeedComposite.setFrameRateColor(ColorConstants.red);
                return false;
            }
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.DECREMENT_FRAME_INTERVAL) {
            HighResolutionCalendar maxInterval = this.minSpeedComposite.getFrameInterval();
            HighResolutionCalendar minInterval = this.maxSpeedComposite.getFrameInterval();
            HighResolutionCalendar maxIncrementInterval = maxInterval.subtractRelative(minInterval);
            HighResolutionCalendar incrInterval = this.incrSpeedComposite.getFrameInterval();
            if (incrInterval.compareTo((Calendar)maxIncrementInterval) == 1) {
                String strIntervalLength = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)maxIncrementInterval, (boolean)false, (boolean)true);
                this.errorMessage = "The Maximum Decrement Frame Interval is " + strIntervalLength + ".";
                this.incrSpeedComposite.setFrameIntervalColor(ColorConstants.red);
                return false;
            }
        } else {
            DataRateUnit unit = this.incrSpeedComposite.getDataRateUnit();
            ThroughputType type = this.getProjectReader().getThroughputType();
            BigDecimal incrLoad = this.incrSpeedFlowTemplateController.getThroughput(type, unit);
            BigDecimal minLoad = this.minSpeedFlowTemplateController.getThroughput(type, unit);
            BigDecimal maxLoad = this.maxSpeedFlowTemplateController.getThroughput(type, unit);
            BigDecimal maxAllowedIncr = maxLoad.subtract(minLoad);
            if (incrLoad.compareTo(maxAllowedIncr) == 1) {
                this.errorMessage = "The Maximum Increment Intended Load is " + Utils.trim((String)maxAllowedIncr.toString()) + " (" + unit.toString() + ").";
                this.incrSpeedComposite.setFrameIntervalColor(ColorConstants.red);
                return false;
            }
        }
        if (this.flowCountBigInteger.compareTo(maxFlowCount) == 1) {
            this.errorMessage = "The Maximum amount of resulting Flows is " + maxFlowCount.toString() + ".";
            this.txtFlowCount.setForeground(ColorConstants.red);
            return false;
        }
        this.errorMessage = "";
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        control.isFocusControl();
    }

    public int getFlowCount() {
        if (this.flowCountBigInteger == null) {
            this.updateFlowCount();
        }
        return this.flowCountBigInteger.intValue();
    }

    public BigInteger getMinimumFlowDuration() {
        BigInteger ret = BigInteger.valueOf(this.minSpeedFlowTemplateController.getFrameInterval().getTimeInNanoseconds());
        ret = ret.multiply(new BigInteger("2"));
        return ret;
    }

    public SpeedIncrementComposite.ESpeedIncrementType getSpeedIncrementType() {
        return this.incrSpeedComposite.getSpeedIncrementType();
    }

    public void rateChanged() {
        if (this.isDisposed()) {
            return;
        }
        this.updateFlowCount();
    }
}

