/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.topology;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

class MoreDecoration
extends Figure
implements RotatableDecoration {
    private static final PointList ETCETERA = new PointList();
    private PointList template = ETCETERA;
    private Transform transform = new Transform();
    private Point location = new Point();
    private PointList points = null;

    static {
        ETCETERA.addPoint(0, 0);
        ETCETERA.addPoint(0, 0);
        ETCETERA.addPoint(-1, 0);
        ETCETERA.addPoint(-2, 0);
        ETCETERA.addPoint(-3, 0);
        ETCETERA.addPoint(-4, 0);
        ETCETERA.addPoint(-5, 0);
    }

    public MoreDecoration() {
        this.setBackgroundColor(ColorConstants.black);
        this.setScale(5.0, 5.0);
    }

    public void setLocation(Point p) {
        this.points = null;
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
    }

    public PointList getPoints() {
        if (this.points == null) {
            this.points = new PointList();
            int i = 0;
            while (i < this.template.size()) {
                this.points.addPoint(this.transform.getTransformed(this.template.getPoint(i)));
                ++i;
            }
        }
        return this.points;
    }

    private void setScale(double x, double y) {
        this.transform.setScale(x, y);
    }

    public void setTemplate(PointList pl) {
        this.erase();
        this.template = pl;
        this.points = null;
        this.bounds = null;
        this.repaint();
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.points = null;
        this.bounds = null;
        this.transform.setRotation(angle);
        this.repaint();
    }

    private void addPoint(Point pt) {
        this.points.addPoint(pt);
        this.bounds = null;
        this.repaint();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.getPoints().getBounds().getExpanded(0, 0);
        }
        return this.bounds;
    }

    public boolean isOpaque() {
        return false;
    }

    public void primTranslate(int x, int y) {
    }

    public void removeAllPoints() {
        this.erase();
        this.bounds = null;
        this.points.removeAllPoints();
    }

    public void removePoint(int index) {
        this.erase();
        this.bounds = null;
        this.points.removePoint(index);
    }

    public void setEnd(Point end) {
        if (this.points.size() < 2) {
            this.addPoint(end);
        } else {
            this.setPoint(end, this.points.size() - 1);
        }
    }

    public void setEndpoints(Point start, Point end) {
        this.setStart(start);
        this.setEnd(end);
    }

    private void setPoint(Point pt, int index) {
        this.erase();
        this.points.setPoint(pt, index);
        this.bounds = null;
        this.repaint();
    }

    public void setPoints(PointList points) {
        this.erase();
        this.points = points;
        this.bounds = null;
        this.firePropertyChange("points", null, points);
        this.repaint();
    }

    public void setStart(Point start) {
        if (this.points.size() == 0) {
            this.addPoint(start);
        } else {
            this.setPoint(start, 0);
        }
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public void paintFigure(Graphics graphics) {
        int i = 0;
        while (i < this.points.size()) {
            graphics.drawPoint(this.points.getPoint((int)i).x, this.points.getPoint((int)i).y);
            ++i;
        }
    }
}

