/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.swt.widgets.text.IpAddressTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressTextFactory_ForByteBlowerGuiPort;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.gui.widgets.dialogs.SelectByteBlowerPortDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.SelectMulticastDialog;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.Ipv6AddressController;
import com.excentis.products.byteblower.model.reader.impl.BroadcastReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.UnicastReaderImpl;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FlowDestinationDialog
extends TitleAreaDialog
implements SelectionListener,
ModifyListener {
    private Button okButton;
    private Flow flow;
    private DestinationInfo destinationInfo;
    private ByteBlowerGuiPort destPort;
    private MulticastGroup destMulticast;
    private String destBroadcast;
    private String destUnicast;
    private Image dlgTitleImage = null;
    private Button radioDestUnicast;
    private Button radioDestPort;
    private Button radioDestMulticast;
    private Button radioDestBroadcast;
    private Text txtDestUnicast;
    private Text txtDestPort;
    private Button btnDestPort;
    private Text txtDestMulticast;
    private Button btnDestMulticast;
    private Text txtDestBroadcast;
    private boolean noValidation = false;
    private static final int INVALIDRADIO = Integer.MAX_VALUE;
    private int prefferredRadio = Integer.MAX_VALUE;

    public FlowDestinationDialog(Shell parentShell, Flow flow) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.flow = flow;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("FlowDestinationDialog.title"));
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(String.valueOf(Messages.getString("FlowDestinationDialog.title.info")) + " " + this.flow.getName());
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/FlowDestination.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        this.validatePage();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.noValidation = true;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        parentComposite.setLayout((Layout)layout);
        parentComposite.setLayoutData((Object)new GridData(1808));
        parentComposite.setFont(parentComposite.getFont());
        Composite destinationComposite = new Composite(parentComposite, 0);
        destinationComposite.setLayoutData((Object)new GridData(768));
        this.fillDestinationComposite(destinationComposite);
        this.initializeControls();
        this.noValidation = false;
        return parentComposite;
    }

    private void fillDestinationComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Group destinationGroup = new Group(parent, 0);
        destinationGroup.setText(Messages.getString("FlowSettingsDialog.destination.group"));
        destinationGroup.setLayoutData((Object)new GridData(768));
        destinationGroup.setLayout((Layout)new GridLayout(3, false));
        this.radioDestPort = new Button((Composite)destinationGroup, 16);
        this.radioDestPort.addSelectionListener((SelectionListener)this);
        this.radioDestPort.setText(Messages.getString("FlowSettingsDialog.radio.port"));
        this.txtDestPort = new Text((Composite)destinationGroup, 2048);
        this.txtDestPort.setEditable(false);
        this.txtDestPort.setLayoutData((Object)new GridData(768));
        this.btnDestPort = new Button((Composite)destinationGroup, 0);
        this.btnDestPort.addSelectionListener((SelectionListener)this);
        this.btnDestPort.setText("...");
        this.radioDestMulticast = new Button((Composite)destinationGroup, 16);
        this.radioDestMulticast.addSelectionListener((SelectionListener)this);
        this.radioDestMulticast.setText(Messages.getString("FlowSettingsDialog.radio.multicast"));
        this.txtDestMulticast = new Text((Composite)destinationGroup, 2048);
        this.txtDestMulticast.setLayoutData((Object)new GridData(768));
        this.txtDestMulticast.setEditable(false);
        this.btnDestMulticast = new Button((Composite)destinationGroup, 0);
        this.btnDestMulticast.addSelectionListener((SelectionListener)this);
        this.btnDestMulticast.setText("...");
        this.radioDestBroadcast = new Button((Composite)destinationGroup, 16);
        this.radioDestBroadcast.addSelectionListener((SelectionListener)this);
        this.radioDestBroadcast.setText(Messages.getString("FlowSettingsDialog.radio.broadcast"));
        this.txtDestBroadcast = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create((Composite)destinationGroup, 2048);
        String defaultBroadcast = "255.255.255.255";
        this.txtDestBroadcast.setText(defaultBroadcast);
        this.destBroadcast = defaultBroadcast;
        this.txtDestBroadcast.setLayoutData((Object)new GridData(768));
        this.txtDestBroadcast.addModifyListener((ModifyListener)this);
        this.radioDestPort.setSelection(true);
        Label dummy = new Label((Composite)destinationGroup, 0);
        dummy.setVisible(false);
        this.radioDestUnicast = new Button((Composite)destinationGroup, 16);
        this.radioDestUnicast.addSelectionListener((SelectionListener)this);
        this.radioDestUnicast.setText(Messages.getString("FlowSettingsDialog.radio.unicast"));
        this.txtDestUnicast = IpAddressTextFactory.instance().create((Composite)destinationGroup, 2048);
        String defaultUnicast = "1.1.1.1";
        this.txtDestUnicast.setText(defaultUnicast);
        this.destUnicast = defaultUnicast;
        this.txtDestUnicast.setLayoutData((Object)new GridData(768));
        this.txtDestUnicast.addModifyListener((ModifyListener)this);
    }

    public void overrideSelection(int type) {
        switch (type) {
            case 1: {
                this.prefferredRadio = 0;
                break;
            }
            case 2: {
                this.prefferredRadio = 1;
                break;
            }
            case 3: {
                this.prefferredRadio = 2;
                break;
            }
            case 4: {
                this.prefferredRadio = 3;
                break;
            }
            default: {
                this.prefferredRadio = Integer.MAX_VALUE;
            }
        }
    }

    private void initializeControls() {
        int destinationType = 0;
        Object value = null;
        AddressableDestination destination = this.flow.getDestination();
        this.updateTcp();
        int radio = 0;
        if (destination instanceof ByteBlowerGuiPort) {
            radio = 0;
            destinationType = 1;
            value = this.destPort = (ByteBlowerGuiPort)destination;
            this.txtDestPort.setText(this.destPort.getName());
        } else if (destination instanceof MulticastGroup) {
            radio = 1;
            destinationType = 2;
            this.destMulticast = (MulticastGroup)destination;
            value = this.destMulticast;
            this.txtDestMulticast.setText(this.destMulticast.getName());
        } else if (destination instanceof Broadcast) {
            radio = 2;
            destinationType = 3;
            BroadcastReaderImpl reader = new BroadcastReaderImpl((Broadcast)destination);
            this.destBroadcast = reader.getAddress();
            value = this.destBroadcast;
            this.txtDestBroadcast.setText(this.destBroadcast);
        } else if (destination instanceof Unicast) {
            radio = 3;
            destinationType = 4;
            UnicastReaderImpl reader = new UnicastReaderImpl((Unicast)destination);
            this.destUnicast = reader.getAddress();
            value = this.destUnicast;
            this.txtDestUnicast.setText(this.destUnicast);
        }
        if (Integer.MAX_VALUE == this.prefferredRadio) {
            this.setRadio(radio);
        } else {
            destinationType = this.prefferredRadio + 1;
            this.setRadio(this.prefferredRadio);
            switch (destinationType) {
                case 3: {
                    value = this.destBroadcast;
                    break;
                }
                case 2: {
                    value = this.destMulticast;
                    break;
                }
                case 1: {
                    value = this.destPort;
                    break;
                }
                case 4: {
                    value = this.destUnicast;
                    break;
                }
            }
        }
        this.destinationInfo = new DestinationInfo(destinationType, value);
    }

    private void setRadio(int radio) {
        this.radioDestPort.setSelection(radio == 0);
        this.txtDestPort.setEnabled(radio == 0);
        this.btnDestPort.setEnabled(radio == 0);
        this.radioDestMulticast.setSelection(radio == 1);
        this.txtDestMulticast.setEnabled(radio == 1);
        this.btnDestMulticast.setEnabled(radio == 1);
        this.radioDestBroadcast.setSelection(radio == 2);
        this.txtDestBroadcast.setEnabled(radio == 2);
        this.radioDestUnicast.setSelection(radio == 3);
        this.txtDestUnicast.setEnabled(radio == 3);
        this.validatePage();
    }

    private void updateTcp() {
        boolean tcp = this.flow.getFlowTemplate() instanceof TcpFlow;
        this.radioDestMulticast.setEnabled(!tcp);
        this.radioDestBroadcast.setEnabled(!tcp);
    }

    public DestinationInfo getDestinationInfo() {
        return this.destinationInfo;
    }

    private void validatePage() {
        if (this.noValidation) {
            return;
        }
        if (this.flow == null) {
            this.okButton.setEnabled(false);
            return;
        }
        Object selectedDestination = this.destinationInfo.getValue();
        boolean ok = false;
        switch (this.destinationInfo.getType()) {
            case 0: {
                break;
            }
            case 1: {
                ok = true;
                break;
            }
            case 2: {
                ok = true;
                break;
            }
            case 3: {
                ok = Ipv4AddressController.isValidNonZero((String)((String)selectedDestination));
                break;
            }
            case 4: {
                ok = Ipv4AddressController.isValid((String)((String)selectedDestination)) || Ipv6AddressController.isValid((String)((String)selectedDestination), (boolean)false, (boolean)true);
            }
        }
        this.okButton.setEnabled(ok);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.radioDestPort) {
            this.destinationInfo.setType(1);
            this.destinationInfo.setValue(this.destPort);
            this.setRadio(0);
        } else if (e.widget == this.radioDestMulticast) {
            this.destinationInfo.setType(2);
            this.destinationInfo.setValue(this.destMulticast);
            this.setRadio(1);
        } else if (e.widget == this.radioDestBroadcast) {
            this.destinationInfo.setType(3);
            this.destinationInfo.setValue(this.destBroadcast);
            this.setRadio(2);
        } else if (e.widget == this.radioDestUnicast) {
            this.destinationInfo.setType(4);
            this.destinationInfo.setValue(this.destUnicast);
            this.setRadio(3);
        } else if (e.widget == this.btnDestPort) {
            ByteBlowerGuiPort dest = (ByteBlowerGuiPort)this.destinationInfo.getValue();
            SelectByteBlowerPortDialog dialog = new SelectByteBlowerPortDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("FlowDestinationDialog.title"), dest);
            if (dialog.open() == 0) {
                this.destPort = dialog.getSelectedByteBlowerPort();
                this.destinationInfo.setType(1);
                this.destinationInfo.setValue(this.destPort);
                this.txtDestPort.setText(this.destPort.getName());
                this.validatePage();
                this.close();
            }
        } else if (e.widget == this.btnDestMulticast) {
            MulticastGroup dest = (MulticastGroup)this.destinationInfo.getValue();
            SelectMulticastDialog dialog = new SelectMulticastDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("FlowDestinationDialog.title"), dest);
            if (dialog.open() == 0) {
                this.destMulticast = dialog.getSelectedMulticast();
                this.destinationInfo.setValue(this.destMulticast);
                this.destinationInfo.setType(2);
                this.txtDestMulticast.setText(this.destMulticast.getName());
                this.validatePage();
                this.close();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent event) {
        if (this.destinationInfo == null) {
            return;
        }
        if (event.widget == this.txtDestBroadcast) {
            this.destinationInfo.value = this.txtDestBroadcast.getText();
        } else if (event.widget == this.txtDestUnicast) {
            this.destinationInfo.value = this.txtDestUnicast.getText();
        }
        this.validatePage();
    }

    public class DestinationInfo {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_PORT = 1;
        public static final int TYPE_MULTICAST = 2;
        public static final int TYPE_BROADCAST = 3;
        public static final int TYPE_UNICAST = 4;
        private int type;
        private Object value;

        private DestinationInfo(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

