/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.IProjectProperties;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OutputPropertiesComposite
extends PropertiesComposite
implements VerifyListener,
IProjectProperties {
    protected IWorkbench workbench;
    private Button checkDynamicHtml;
    private Button checkHtml;
    private Button checkExcel;
    private Button checkCsv;
    private Button checkPdf;
    private Button checkJson;
    private Button checkResultsOverTime;
    private Button checkBackup;
    private Combo throughputUnit;
    private Spinner throughputDecimals;
    private Combo latencyUnitCombo;
    private Spinner latencyDecimals;
    private Button checkDeprecatedHtml;
    private static String editPattern = "^(((\\d?\\d?)?([.]\\d?\\d?)?)?)$";

    private void createOutputTab(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        Group outputSelectGroup = new Group(composite, 0);
        outputSelectGroup.setLayoutData((Object)new GridData(768));
        outputSelectGroup.setLayout((Layout)new GridLayout());
        outputSelectGroup.setText("Generate these files after each Scenario. You can also re-generate reports in the Archive View.");
        this.checkDynamicHtml = new Button((Composite)outputSelectGroup, 32);
        this.checkDynamicHtml.setText("Dynamic HTML Report (R3)");
        if (currentProject == null) {
            this.checkDynamicHtml.setSelection(ByteBlowerPreferences.getOutputToDynamicHtml());
        } else {
            this.checkDynamicHtml.setSelection(currentProject.isReportOutputToDynamicHtml());
        }
        this.checkHtml = new Button((Composite)outputSelectGroup, 32);
        this.checkHtml.setText("Old Style HTML Report (R2)");
        if (currentProject == null) {
            this.checkHtml.setSelection(ByteBlowerPreferences.getOutputToHtml());
        } else {
            this.checkHtml.setSelection(currentProject.isReportOutputToHtml());
        }
        this.checkJson = new Button((Composite)outputSelectGroup, 32);
        this.checkJson.setText("JSON Report");
        if (currentProject == null) {
            this.checkJson.setSelection(ByteBlowerPreferences.getOutputToJson());
        } else {
            this.checkJson.setSelection(currentProject.isReportOutputToJson());
        }
        this.checkCsv = new Button((Composite)outputSelectGroup, 32);
        this.checkCsv.setText("CSV Report");
        if (currentProject == null) {
            this.checkCsv.setSelection(ByteBlowerPreferences.getOutputToCsv());
        } else {
            this.checkCsv.setSelection(currentProject.isReportOutputToCsv());
        }
        this.checkBackup = new Button((Composite)outputSelectGroup, 32);
        this.checkBackup.setText("Project Backup");
        if (currentProject == null) {
            this.checkBackup.setSelection(ByteBlowerPreferences.getOutputProjectBackup());
        } else {
            this.checkBackup.setSelection(currentProject.isReportProjectBackup());
        }
        Group deprecatedGroup = new Group(composite, 0);
        deprecatedGroup.setLayoutData((Object)new GridData(768));
        deprecatedGroup.setLayout((Layout)new GridLayout(2, false));
        deprecatedGroup.setText("Deprecated options");
        this.checkDeprecatedHtml = new Button((Composite)deprecatedGroup, 32);
        this.checkDeprecatedHtml.setText("Deprecated HTML Report (R1)");
        if (currentProject == null) {
            this.checkDeprecatedHtml.setSelection(ByteBlowerPreferences.isReportOutputToDeprecatedHtml());
        } else {
            this.checkDeprecatedHtml.setSelection(currentProject.isReportOutputToDeprecatedHtml());
        }
        Button deprecatedHtmlHelp = new Button((Composite)deprecatedGroup, 0);
        deprecatedHtmlHelp.setText("?");
        deprecatedHtmlHelp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/306"));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.checkExcel = new Button((Composite)deprecatedGroup, 32);
        this.checkExcel.setText("XLSX Report");
        if (currentProject == null) {
            this.checkExcel.setSelection(ByteBlowerPreferences.getOutputToExcel());
        } else {
            this.checkExcel.setSelection(currentProject.isReportOutputToExcel());
        }
        Button deprecatedXlsxHelp = new Button((Composite)deprecatedGroup, 0);
        deprecatedXlsxHelp.setText("?");
        deprecatedXlsxHelp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/305"));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.checkPdf = new Button((Composite)deprecatedGroup, 32);
        this.checkPdf.setText("PDF Report");
        if (currentProject == null) {
            this.checkPdf.setSelection(ByteBlowerPreferences.getOutputToPdf());
        } else {
            this.checkPdf.setSelection(currentProject.isReportOutputToPdf());
        }
        Button deprecatedPdfHelp = new Button((Composite)deprecatedGroup, 0);
        deprecatedPdfHelp.setText("?");
        deprecatedPdfHelp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/305"));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Group graphsGroup = new Group(composite, 0);
        graphsGroup.setLayoutData((Object)new GridData(768));
        graphsGroup.setLayout((Layout)new GridLayout(2, false));
        graphsGroup.setText("Graphs");
        this.checkResultsOverTime = new Button((Composite)graphsGroup, 32);
        this.checkResultsOverTime.setText("Enable graphs with results over time.");
        if (currentProject == null) {
            this.checkResultsOverTime.setSelection(ByteBlowerPreferences.getDefaultResultsOverTimeEnabled());
        } else {
            this.checkResultsOverTime.setSelection(currentProject.isResultsOverTimeEnabled());
        }
        Button help = new Button((Composite)graphsGroup, 0);
        help.setText("?");
        help.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/running-big-scenarios"));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Group throughputGroup = new Group(composite, 0);
        throughputGroup.setLayoutData((Object)new GridData(768));
        throughputGroup.setLayout((Layout)new GridLayout(1, true));
        throughputGroup.setText("Express Throughput in");
        this.throughputUnit = new Combo((Composite)throughputGroup, 76);
        DataRateUnit[] dataRateUnitArray = DataRateUnit.values();
        int n = dataRateUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataRateUnit dataRateUnit = dataRateUnitArray[n2];
            this.throughputUnit.add(dataRateUnit.getName());
            ++n2;
        }
        if (currentProject == null) {
            this.throughputUnit.select(ByteBlowerPreferences.getThroughputUnit());
        } else {
            this.throughputUnit.select(currentProject.getThroughputUnit().getValue());
        }
        Composite throughputDecimalsGroup = new Composite((Composite)throughputGroup, 0);
        throughputDecimalsGroup.setLayoutData((Object)new GridData(768));
        throughputDecimalsGroup.setLayout((Layout)new GridLayout(2, false));
        Label throughputDecimalsLabel = new Label(throughputDecimalsGroup, 0);
        throughputDecimalsLabel.setText("Decimal numbers:");
        this.throughputDecimals = new Spinner(throughputDecimalsGroup, 2056);
        this.throughputDecimals.setMinimum(0);
        this.throughputDecimals.setIncrement(1);
        this.throughputDecimals.setDigits(0);
        this.throughputDecimals.setMaximum(9);
        if (currentProject == null) {
            this.throughputDecimals.setSelection(ByteBlowerPreferences.getNumberOfDecimals());
        } else {
            this.throughputDecimals.setSelection(currentProject.getNumberOfDecimals());
        }
        Label info = new Label((Composite)throughputGroup, 0);
        info.setText("Note these preferences determine the precision of throughput results.");
        Group latencyGroup = new Group(composite, 0);
        latencyGroup.setLayoutData((Object)new GridData(768));
        latencyGroup.setLayout((Layout)new GridLayout(1, true));
        latencyGroup.setText("Express Latency in");
        this.latencyUnitCombo = new Combo((Composite)latencyGroup, 76);
        this.latencyUnitCombo.add("ms");
        this.latencyUnitCombo.add("\u03bcs");
        this.latencyUnitCombo.add("ns");
        int unit = currentProject == null ? ByteBlowerPreferences.getLatencyUnit() : currentProject.getLatencyUnit();
        this.selectLatencyUnit(unit);
        Composite latencyDecimalsGroup = new Composite((Composite)latencyGroup, 0);
        latencyDecimalsGroup.setLayoutData((Object)new GridData(768));
        latencyDecimalsGroup.setLayout((Layout)new GridLayout(2, false));
        Label latencyDecimalsLabel = new Label(latencyDecimalsGroup, 0);
        latencyDecimalsLabel.setText("Decimal numbers:");
        this.latencyDecimals = new Spinner(latencyDecimalsGroup, 2056);
        this.latencyDecimals.setMinimum(0);
        this.latencyDecimals.setIncrement(1);
        this.latencyDecimals.setDigits(0);
        this.latencyDecimals.setMaximum(9);
        if (currentProject == null) {
            this.latencyDecimals.setSelection(ByteBlowerPreferences.getNumberOfLatencyDecimals());
        } else {
            this.latencyDecimals.setSelection(currentProject.getNumberOfLatencyDecimals());
        }
        info = new Label((Composite)latencyGroup, 0);
        info.setText("Note these preferences determine the precision of latency results.");
    }

    private int getSelectedLatencyUnit() {
        switch (this.latencyUnitCombo.getSelectionIndex()) {
            case 0: {
                return 14;
            }
            case 1: {
                return 17;
            }
            case 2: {
                return 18;
            }
        }
        return 0;
    }

    private void selectLatencyUnit(int unit) {
        int index = 0;
        switch (unit) {
            case 14: {
                index = 0;
                break;
            }
            case 17: {
                index = 1;
                break;
            }
            case 18: {
                index = 2;
            }
        }
        this.latencyUnitCombo.select(index);
    }

    public void verifyText(VerifyEvent e) {
        Text t = (Text)e.widget;
        String previous = t.getText();
        String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
        e.doit = Pattern.matches(editPattern, result);
    }

    public OutputPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    protected void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.createOutputTab(this);
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        boolean html = this.checkHtml.getSelection();
        boolean dynamicHtml = this.checkDynamicHtml.getSelection();
        boolean deprecatedHtml = this.checkDeprecatedHtml.getSelection();
        boolean xlsx = this.checkExcel.getSelection();
        boolean csv = this.checkCsv.getSelection();
        boolean pdf = this.checkPdf.getSelection();
        boolean json = this.checkJson.getSelection();
        boolean rot = this.checkResultsOverTime.getSelection();
        boolean backup = this.checkBackup.getSelection();
        DataRateUnit dataRateUnit = DataRateUnit.get((int)this.throughputUnit.getSelectionIndex());
        int numberOfDecimals = this.throughputDecimals.getSelection();
        int latencyUnit = this.getSelectedLatencyUnit();
        int numberOfLatencyDecimals = this.latencyDecimals.getSelection();
        boolean updateScenarioStatuses = currentProject.isResultsOverTimeEnabled() ^ rot;
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToDynamicHtml(dynamicHtml));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToHtml(html));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToDeprecatedHtml(deprecatedHtml));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToExcel(xlsx));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToCsv(csv));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToPdf(pdf));
        compCommCtlr.appendCommand(projectCtlr.setReportOutputToJson(json));
        compCommCtlr.appendCommand(projectCtlr.setReportProjectBackup(backup));
        compCommCtlr.appendCommand(projectCtlr.setThroughputUnit(dataRateUnit));
        compCommCtlr.appendCommand(projectCtlr.setNumberOfDecimals(numberOfDecimals));
        compCommCtlr.appendCommand(projectCtlr.setLatencyUnit(latencyUnit));
        compCommCtlr.appendCommand(projectCtlr.setNumberOfLatencyDecimals(numberOfLatencyDecimals));
        compCommCtlr.appendCommand(projectCtlr.setIsResultsOverTimeEnabled(rot));
        if (updateScenarioStatuses) {
            for (ScenarioController controller : projectCtlr.getScenarioControllers()) {
                compCommCtlr.appendCommand(controller.createSetStatusUnknownCommand());
            }
        }
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "Report Properties", compCommCtlr.unwrap());
        operation.run();
    }

    @Override
    public void setAsDefault() {
        ByteBlowerPreferences.setOutputToHtml((boolean)this.checkHtml.getSelection());
        ByteBlowerPreferences.setOutputToDynamicHtml((boolean)this.checkDynamicHtml.getSelection());
        ByteBlowerPreferences.setOutputToDeprecatedHtml((boolean)this.checkDeprecatedHtml.getSelection());
        ByteBlowerPreferences.setOutputToExcel((boolean)this.checkExcel.getSelection());
        ByteBlowerPreferences.setOutputToCsv((boolean)this.checkCsv.getSelection());
        ByteBlowerPreferences.setOutputToPdf((boolean)this.checkPdf.getSelection());
        ByteBlowerPreferences.setOutputToJson((boolean)this.checkJson.getSelection());
        ByteBlowerPreferences.setOutputProjectBackup((boolean)this.checkBackup.getSelection());
        ByteBlowerPreferences.setThroughputUnit((int)this.throughputUnit.getSelectionIndex());
        ByteBlowerPreferences.setNumberOfDecimals((int)this.throughputDecimals.getSelection());
        ByteBlowerPreferences.setLatencyUnit((int)this.getSelectedLatencyUnit());
        ByteBlowerPreferences.setNumberOfLatencyDecimals((int)this.latencyDecimals.getSelection());
        ByteBlowerPreferences.setDefaultResultsOverTimeEnabled((boolean)this.checkResultsOverTime.getSelection());
    }
}

