/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import org.eclipse.emf.common.command.Command;

final class BroadcastController
extends EByteBlowerObjectController<Broadcast> {
    BroadcastController(Broadcast myBroadcast) {
        super(myBroadcast);
    }

    private final Command setIpAddress(NetworkAddressBytes newBroadcastIpAddress) {
        Broadcast myBroadcast = (Broadcast)this.getObject();
        if (myBroadcast != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myBroadcast.getIpAddress());
            return ipv4AddressController.setAddress(newBroadcastIpAddress);
        }
        return null;
    }

    final Command setIpAddress(String newBroadcastIpAddress) {
        NetworkAddressBytes newNetworkAddressBytes;
        try {
            newNetworkAddressBytes = Ipv4AddressController.createBytesFromString(newBroadcastIpAddress);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.setIpAddress(newNetworkAddressBytes);
    }

    protected static Broadcast create() {
        Broadcast broadcast = EByteBlowerObjectController.getByteblowerguimodelFactory().createBroadcast();
        Ipv4Address ipv4Address = Ipv4AddressController.createBroadcast();
        broadcast.setIpAddress(ipv4Address);
        return broadcast;
    }

    protected static Broadcast createFromString(String newBroadcastAddress) {
        Broadcast broadcast = EByteBlowerObjectController.getByteblowerguimodelFactory().createBroadcast();
        Ipv4Address ipv4Address = Ipv4AddressController.createFromString(newBroadcastAddress);
        broadcast.setIpAddress(ipv4Address);
        return broadcast;
    }
}

