/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteBlowerServerType;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.control.BroadcastController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.UnicastController;
import com.excentis.products.byteblower.model.reader.AddressableDestinationReader;
import com.excentis.products.byteblower.model.reader.AddressableSourceReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.FlowTemplateReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFlowReaderImpl;
import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class FlowController
extends EByteBlowerObjectController<Flow>
implements FlowReader {
    private static final String newFlowPrefix = "FLOW_";

    FlowController(Flow myFlow) {
        super(myFlow);
    }

    private static final Flow create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createFlow();
    }

    protected static final Flow create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newFlowName;
        Flow newFlow = FlowController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newFlow, (String)(newFlowName = referenceName))) {
            newFlowName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newFlow, (String)newFlowName, (String)newFlowPrefix);
        }
        newFlow.setName(newFlowName);
        return newFlow;
    }

    private EReference getFlowTemplateEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE;
    }

    public Command setFlowTemplate(FlowTemplate flowTemplate) {
        return this.createSetCommand((EStructuralFeature)this.getFlowTemplateEReference(), flowTemplate);
    }

    private EReference getSourceEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__SOURCE;
    }

    public Command setSource(AddressableSource source) {
        return this.createSetCommand((EStructuralFeature)this.getSourceEReference(), source);
    }

    private final EReference getDestinationEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__DESTINATION;
    }

    private final Command createSetAddressableDestinationCommand(AddressableDestination destination) {
        return this.createSetCommand((EStructuralFeature)this.getDestinationEReference(), destination);
    }

    private final Command createDeleteBroadcastDestinationCommand(Broadcast broadcast) {
        BroadcastController broadcastController = new BroadcastController(broadcast);
        return broadcastController.createDeleteCommand();
    }

    private final Command createDeleteUnicastDestinationCommand(Unicast unicast) {
        UnicastController unicastController = new UnicastController(unicast);
        return unicastController.createDeleteCommand();
    }

    private final Command createDeleteOldAddressableDestinationCommand(AddressableDestination newAddressableDestination) {
        AddressableDestination oldDestination;
        Flow myFlow = (Flow)this.getObject();
        if (myFlow != null && (oldDestination = myFlow.getDestination()) != null && newAddressableDestination != oldDestination && (newAddressableDestination == null || newAddressableDestination.eClass() != oldDestination.eClass())) {
            if (oldDestination instanceof Broadcast) {
                return this.createDeleteBroadcastDestinationCommand((Broadcast)oldDestination);
            }
            if (oldDestination instanceof Unicast) {
                return this.createDeleteUnicastDestinationCommand((Unicast)oldDestination);
            }
        }
        return null;
    }

    private final Command createReplaceAddressableDestinationCommand(Command deleteAddressableDestinationCommand, Command createAddressableDestinationCommand, final AddressableDestination newAddressableDestination) {
        CompoundCommandController compoundCommandController;
        if (deleteAddressableDestinationCommand != null) {
            compoundCommandController = CompoundCommandController.createStrictInstance((boolean)true);
            if (createAddressableDestinationCommand != null) {
                compoundCommandController.appendCommand(createAddressableDestinationCommand);
            }
            compoundCommandController.appendCommand(deleteAddressableDestinationCommand);
            compoundCommandController.appendCommand((Command)new CommandWrapper(){

                protected Command createCommand() {
                    return FlowController.this.createSetAddressableDestinationCommand(newAddressableDestination);
                }
            });
        } else {
            compoundCommandController = CompoundCommandController.createInstance();
            if (createAddressableDestinationCommand != null) {
                compoundCommandController.appendCommand(createAddressableDestinationCommand);
            }
            compoundCommandController.appendCommand(this.createSetAddressableDestinationCommand(newAddressableDestination));
        }
        return compoundCommandController.unwrap();
    }

    public final Command createSetBroadcastDestinationCommand(String newBroadcastIpAddress) {
        Flow myFlow = (Flow)this.getObject();
        if (myFlow != null) {
            AddressableDestination oldDestination = myFlow.getDestination();
            if (oldDestination instanceof Broadcast) {
                BroadcastController broadcastController = new BroadcastController((Broadcast)oldDestination);
                return broadcastController.setIpAddress(newBroadcastIpAddress);
            }
            ByteBlowerProjectController byteblowerProjectController = new ByteBlowerProjectController(myFlow.getByteBlowerProject());
            Broadcast broadcast = BroadcastController.createFromString(newBroadcastIpAddress);
            Command addBroadcastCommand = byteblowerProjectController.createAddBroadcastCommand(broadcast);
            Command deleteAddressableDestinationCommand = oldDestination instanceof Unicast ? this.createDeleteUnicastDestinationCommand((Unicast)oldDestination) : null;
            return this.createReplaceAddressableDestinationCommand(deleteAddressableDestinationCommand, addBroadcastCommand, (AddressableDestination)broadcast);
        }
        return null;
    }

    public final Command createSetUnicastDestinationCommand(String newIpAddress) {
        Flow myFlow = (Flow)this.getObject();
        if (myFlow != null) {
            AddressableDestination oldDestination = myFlow.getDestination();
            if (oldDestination instanceof Unicast) {
                UnicastController unicastController = new UnicastController((Unicast)oldDestination);
                return unicastController.setIpAddress(newIpAddress);
            }
            ByteBlowerProjectController byteblowerProjectController = new ByteBlowerProjectController(myFlow.getByteBlowerProject());
            Unicast unicast = UnicastController.createFromString(newIpAddress);
            Command addUnicastCommand = byteblowerProjectController.createAddUnicastCommand(unicast);
            Command deleteAddressableDestinationCommand = oldDestination instanceof Broadcast ? this.createDeleteBroadcastDestinationCommand((Broadcast)oldDestination) : null;
            return this.createReplaceAddressableDestinationCommand(deleteAddressableDestinationCommand, addUnicastCommand, (AddressableDestination)unicast);
        }
        return null;
    }

    public final Command createSetDestinationCommand(AddressableDestination newAddressableDestination) {
        Flow myFlow = (Flow)this.getObject();
        if (myFlow != null) {
            Command deleteAddressableDestinationCommand = this.createDeleteOldAddressableDestinationCommand(newAddressableDestination);
            return this.createReplaceAddressableDestinationCommand(deleteAddressableDestinationCommand, null, newAddressableDestination);
        }
        return null;
    }

    public final Command setDestination(AddressableDestination newAddressableDestination) {
        return this.createSetAddressableDestinationCommand(newAddressableDestination);
    }

    private EAttribute getLatencyAndJitterTypeEAttribute() {
        return ByteblowerguimodelPackage.Literals.FLOW__LATENCY_AND_JITTER_TYPE;
    }

    public Command setLatencyAndJitterType(LatencyAndJitterType latencyAndJitterType) {
        return this.createSetCommand((EStructuralFeature)this.getLatencyAndJitterTypeEAttribute(), latencyAndJitterType);
    }

    private EAttribute getOutOfSequenceDetectionEAttribute() {
        return ByteblowerguimodelPackage.Literals.FLOW__OUT_OF_SEQUENCE_DETECTION;
    }

    public Command setOutOfSequenceDetection(OutOfSequenceType outOfSequenceDetection) {
        return this.createSetCommand((EStructuralFeature)this.getOutOfSequenceDetectionEAttribute(), outOfSequenceDetection);
    }

    private boolean isPayloadBasedTcp() {
        if (this.isTcpFlow()) {
            TcpFlowReader tcpReader = ReaderFactory.create((TcpFlow)((TcpFlow)this.getFlowTemplate()));
            return tcpReader.isPayloadBased();
        }
        return false;
    }

    @Override
    public void createStatuses() {
        EList<ByteBlowerGuiPort> eavesdroppers;
        PhysicalDockableReader dockedOn;
        ByteBlowerGuiPort port;
        List supportedFlowTemplateTypes = null;
        boolean sourceIsNatted = false;
        boolean destinationIsNatted = false;
        AddressableSource source = this.getAddressableSource();
        AddressableDestination destination = this.getAddressableDestination();
        FlowTemplate flowTemplate = this.getFlowTemplate();
        if (flowTemplate == null) {
            this.addErrorStatus("Flow Template is missing");
        } else {
            FlowTemplateReader reader = ReaderFactory.create((FlowTemplate)flowTemplate);
            supportedFlowTemplateTypes = reader.getSupportedLayer3Types();
            this.addDependingStatus("Flow Template", (EByteBlowerObjectReader<?>)reader);
            if (!reader.hasErrorStatus()) {
                if (this.isFrameBlastingFlow()) {
                    FrameBlastingFlowReaderImpl fbReader = (FrameBlastingFlowReaderImpl)reader;
                    if (fbReader.getRepeatedFrameReaders().size() > 1 && this.doesOosMeasurement()) {
                        this.addErrorStatus("Out of Sequence is not possible. Only one Frame is allowed in " + reader.getName());
                    }
                } else if (this.isTcpFlow()) {
                    if (destination != null && !(destination instanceof ByteBlowerGuiPort) && !(destination instanceof ByteBlowerPortGroup)) {
                        this.addErrorStatus("TCP Flows must have a ByteBlower Port as destination");
                    }
                } else if (this.isRfc2544Flow() && destination != null && !(destination instanceof ByteBlowerGuiPort)) {
                    this.addErrorStatus("RFC 2544 Flows must have a ByteBlower Port as destination. PortGroups are not yet supported as destination of a RFC 2544 flow");
                }
            }
        }
        boolean sourceWirelessEndpoint = false;
        boolean destinationWirelessEndpoint = false;
        if (source == null) {
            this.addErrorStatus("Source is missing");
        } else if (source instanceof ByteBlowerGuiPort) {
            port = (ByteBlowerGuiPort)source;
            sourceWirelessEndpoint = port.getByteBlowerGuiPortConfiguration().getPhysicalServerType() == ByteBlowerServerType.MEETING_POINT;
            ByteBlowerGuiPortReader sourceReader = ReaderFactory.create((ByteBlowerGuiPort)port);
            this.addDependingStatus("Source", (EByteBlowerObjectReader<?>)sourceReader);
            if (!this.sourceMatchesWithFlowTemplate()) {
                this.addLayer3Mismatch("Source (" + sourceReader.getName() + ") should use the same IP version as the Flow Template (" + flowTemplate.getName() + "), ", supportedFlowTemplateTypes);
            }
            sourceIsNatted = port.isNatted();
            dockedOn = sourceReader.getPhysicalDockableReader();
            if (dockedOn != null && dockedOn.isStatusOk()) {
                if (this.doesOosMeasurement() && !dockedOn.hasCapability(CapabilityReader.TYPE.TxOutOfSequence)) {
                    this.addErrorStatus("Out of Sequence detection is not supported where the source port is docked");
                }
                if (this.doesL4S() && !dockedOn.hasCapability(CapabilityReader.TYPE.L4S)) {
                    this.addErrorStatus("L4S is not supported where the source port is docked");
                }
                if (this.doesLatencyMeasurement() && !sourceReader.hasError() && dockedOn != null && !dockedOn.hasCapability(CapabilityReader.TYPE.TxLatency)) {
                    this.addErrorStatus("Latency measurements are not supported where the source port is docked");
                }
                if (this.isPayloadBasedTcp() && sourceReader.isDockedOnMobileDevice()) {
                    this.addErrorStatus("Payload based TCP is not supported where the source port is docked, on a mobile device");
                }
            }
        }
        if (destination == null) {
            this.addErrorStatus("Destination is missing");
        } else if (!this.destinationMatchesWithFlowTemplate()) {
            this.addLayer3Mismatch("Destination (" + destination.getName() + ") should use the same IP version as the Flow Template (" + flowTemplate.getName() + "), ", supportedFlowTemplateTypes);
        }
        if (destination instanceof ByteBlowerGuiPort) {
            port = (ByteBlowerGuiPort)destination;
            destinationWirelessEndpoint = port.getByteBlowerGuiPortConfiguration().getPhysicalServerType() == ByteBlowerServerType.MEETING_POINT;
            ByteBlowerGuiPortReader destinationReader = ReaderFactory.create((ByteBlowerGuiPort)port);
            destinationIsNatted = port.isNatted();
            this.addDependingStatus("Destination", (EByteBlowerObjectReader<?>)destinationReader);
            dockedOn = destinationReader.getPhysicalDockableReader();
            if (dockedOn != null && dockedOn.isStatusOk()) {
                if (this.doesBasicLatencyMeasurement() && !dockedOn.hasCapability(CapabilityReader.TYPE.RxLatencyBasic)) {
                    this.addErrorStatus("Latency measurements are not supported where the destination port is docked");
                } else if (!(!this.doesDistributionLatencyMeasurement() || dockedOn.hasCapability(CapabilityReader.TYPE.RxLatencyBasic) && dockedOn.hasCapability(CapabilityReader.TYPE.RxLatencyDistribution))) {
                    this.addErrorStatus("Latency histogram measurements are not supported where the destination port is docked");
                }
                if (this.doesL4S() && !dockedOn.hasCapability(CapabilityReader.TYPE.L4S)) {
                    this.addErrorStatus("L4S is not supported where the destination port is docked");
                }
                if (this.doesOosMeasurement() && !dockedOn.hasCapability(CapabilityReader.TYPE.RxOutOfSequenceBasic)) {
                    this.addErrorStatus("Out of Sequence measurements are not supported where the destination port is docked");
                }
            }
            if (this.isPayloadBasedTcp() && destinationReader.isDockedOnMobileDevice()) {
                this.addErrorStatus("A mobile device cannot be used as destination of payload-based TCP sessions");
            }
        } else if (destination instanceof MulticastGroup) {
            MulticastGroup multicast = (MulticastGroup)destination;
            MulticastGroupReader reader = ReaderFactory.create((MulticastGroup)multicast);
            this.addDependingStatus("Destination", (EByteBlowerObjectReader<?>)reader);
            if (reader.getMulticastMemberPorts().isEmpty() && this.getEavesdroppers().isEmpty()) {
                this.addErrorStatus("Destination (" + reader.getName() + ") contains no members and no Eavesdroppers were added");
            }
        }
        if (sourceWirelessEndpoint && destinationWirelessEndpoint) {
            this.addErrorStatus("Source and destination can't be both Wireless Endpoints");
        }
        if (sourceIsNatted && destinationWirelessEndpoint) {
            this.addErrorStatus("This flow requires NAT Discovery. This isn't yet supported on the Wireless Endpoints");
        }
        if (!(eavesdroppers = this.getEavesdroppers()).isEmpty()) {
            if (flowTemplate instanceof TcpFlow) {
                this.addErrorStatus("Eavesdroppers are not allowed on TCP flows");
            } else if (flowTemplate instanceof FrameBlastingFlow) {
                if (destination instanceof Broadcast) {
                    this.addErrorStatus("Eavesdroppers are not allowed on Broadcast flows");
                } else {
                    if (!this.eavesdroppersMatchWithFlowTemplate()) {
                        this.addLayer3Mismatch("All eavesdroppers should use the same IP version as the Flow Template (" + flowTemplate.getName() + "), ", supportedFlowTemplateTypes);
                    }
                    for (ByteBlowerGuiPort eavesDropper : eavesdroppers) {
                        ByteBlowerGuiPortReader eavesReader = ReaderFactory.create((ByteBlowerGuiPort)eavesDropper);
                        if (!eavesReader.hasErrorStatus()) continue;
                        this.addErrorStatus("Eavesdroppers not correctly configured");
                        break;
                    }
                }
            }
        }
    }

    public boolean destinationMatchesWithSource(AddressableDestinationReader<?> reader) {
        return this.getReader().destinationMatchesWithSource(reader);
    }

    private void addLayer3Mismatch(String message, List<SupportedLayer3Configuration> supportedTypes) {
        if (supportedTypes == null) {
            return;
        }
        String types = "";
        for (SupportedLayer3Configuration supported : supportedTypes) {
            if (!types.isEmpty()) {
                types = String.valueOf(types) + " or";
            }
            types = String.valueOf(types) + " " + supported.getName();
        }
        this.addErrorStatus(String.valueOf(message) + types);
    }

    public boolean doesDistributionLatencyMeasurement() {
        return this.getReader().doesDistributionLatencyMeasurement();
    }

    public boolean doesBasicLatencyMeasurement() {
        return this.getReader().doesLatencyMeasurement();
    }

    private FlowReader getReader() {
        return ReaderFactory.create((Flow)((Flow)this.getObject()));
    }

    public AddressableSource getAddressableSource() {
        return this.getReader().getAddressableSource();
    }

    public AddressableSourceReader<?> getAddressableSourceReader() {
        return this.getReader().getAddressableSourceReader();
    }

    public ByteBlowerGuiPortReader getSourceReader() {
        return this.getReader().getSourceReader();
    }

    public FrameBlastingFlowReader getFrameBlastingFlowReader() {
        return this.getReader().getFrameBlastingFlowReader();
    }

    public TcpFlowReader getTcpFlowReader() {
        return this.getReader().getTcpFlowReader();
    }

    public boolean isLatencyEnabled() {
        return this.getReader().isLatencyEnabled();
    }

    public boolean isRfc2544Flow() {
        return this.getReader().isRfc2544Flow();
    }

    public boolean isFrameBlastingFlow() {
        return this.getReader().isFrameBlastingFlow();
    }

    public boolean isTcpFlow() {
        return this.getReader().isTcpFlow();
    }

    public boolean doesLatencyMeasurement() {
        return this.getReader().doesLatencyMeasurement();
    }

    public boolean doesOosMeasurement() {
        return this.getReader().doesOosMeasurement();
    }

    public FlowTemplate getFlowTemplate() {
        return this.getReader().getFlowTemplate();
    }

    public AddressableDestination getAddressableDestination() {
        return this.getReader().getAddressableDestination();
    }

    public boolean supportsLatencyMeasurement() {
        return this.getReader().supportsLatencyMeasurement();
    }

    public boolean supportsOosMeasurement() {
        return this.getReader().supportsOosMeasurement();
    }

    public String getFlowTemplateName() {
        return this.getReader().getFlowTemplateName();
    }

    public String getAddressableSourceName() {
        return this.getReader().getAddressableSourceName();
    }

    public String getAddressableDestinationName() {
        return this.getReader().getAddressableDestinationName();
    }

    public EList<ByteBlowerGuiPort> getEavesdroppers() {
        return this.getReader().getEavesdroppers();
    }

    public Byte getTos() {
        return this.getReader().getTos();
    }

    public boolean hasFlowTemplate() {
        return this.getReader().hasFlowTemplate();
    }

    public boolean canEditTos() {
        return this.getReader().canEditTos();
    }

    public String getTosString() {
        return this.getReader().getTosString();
    }

    public boolean isUnicast() {
        return this.getReader().isUnicast();
    }

    public boolean isMulticast() {
        return this.getReader().isMulticast();
    }

    public boolean isBroadcast() {
        return this.getReader().isBroadcast();
    }

    public boolean hasEavesDroppers() {
        return this.getReader().hasEavesDroppers();
    }

    public boolean hasIPv6EavesDroppers() {
        return this.getReader().hasIPv6EavesDroppers();
    }

    public boolean hasIPv4EavesDroppers() {
        return this.getReader().hasIPv4EavesDroppers();
    }

    public boolean hasErrorInFlowTemplate() {
        return this.getReader().hasErrorInFlowTemplate();
    }

    public FlowTemplateReader<?> getFlowTemplateReader() {
        return this.getReader().getFlowTemplateReader();
    }

    public boolean hasErrorInSource() {
        return this.getReader().hasErrorInSource();
    }

    public boolean hasErrorInDestination() {
        return this.getReader().hasErrorInDestination();
    }

    public AddressableDestinationReader<?> getAddressableDestinationReader() {
        return this.getReader().getAddressableDestinationReader();
    }

    public boolean sourceMatchesWithFlowTemplate() {
        return this.getReader().sourceMatchesWithFlowTemplate();
    }

    public boolean destinationMatchesWithFlowTemplate() {
        return this.getReader().destinationMatchesWithFlowTemplate();
    }

    public boolean eavesdroppersMatchWithFlowTemplate() {
        return this.getReader().eavesdroppersMatchWithFlowTemplate();
    }

    public boolean hasInvalidOoS() {
        return this.getReader().hasInvalidOoS();
    }

    public boolean hasSource() {
        return this.getReader().hasSource();
    }

    public boolean hasErrorInEavesDropper(ByteBlowerGuiPort eavesDropper) {
        return this.getReader().hasErrorInEavesDropper(eavesDropper);
    }

    public boolean doesL4S() {
        return this.getReader().doesL4S();
    }
}

