/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.AlternateModifier;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.SequenceModifier;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FlowTemplateController;
import com.excentis.products.byteblower.model.control.FrameBlastingFrameController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.impl.FrameBlastingFrameImpl;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFlowReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ThroughputReader;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class FrameBlastingFlowController
extends FlowTemplateController<FrameBlastingFlow>
implements FrameBlastingFlowReader {
    public static final int frameRateScale = 12;
    private static final String newFrameBlastingFlowPrefix = "FRAME_BLASTING_";

    FrameBlastingFlowController(FrameBlastingFlow myFrameBlastingFlow) {
        super(myFrameBlastingFlow);
    }

    private static final FrameBlastingFlow create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createFrameBlastingFlow();
    }

    protected static final FrameBlastingFlow create(ByteBlowerProject byteblowerProject, String referenceFrameBlastingFlowName) {
        DataRateUnit preferredUnit;
        String newFrameBlastingFlowName;
        FrameBlastingFlow newFrameBlastingFlow = FrameBlastingFlowController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newFrameBlastingFlow, (String)(newFrameBlastingFlowName = referenceFrameBlastingFlowName))) {
            newFrameBlastingFlowName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newFrameBlastingFlow, (String)newFrameBlastingFlowName, (String)newFrameBlastingFlowPrefix);
        }
        if ((preferredUnit = byteblowerProject.getThroughputUnit()) != null) {
            newFrameBlastingFlow.setDataRateUnit(preferredUnit);
        }
        newFrameBlastingFlow.setName(newFrameBlastingFlowName);
        return newFrameBlastingFlow;
    }

    public final Object[] copyFrameBlastingFrames(Collection<FrameBlastingFrame> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (FrameBlastingFrame object : objects) {
            FrameBlastingFrame copy = (FrameBlastingFrame)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        FrameBlastingFrame[] array = (FrameBlastingFrame[])copiedObjects.toArray((Object[])new FrameBlastingFrame[objects.size()]);
        return new Object[]{array};
    }

    public final CommandWithFrameBlastingFrameListReference pasteFrameBlastingFrames(FrameBlastingFrame[] copiedFrameBlastingFrames, int pasteIndex) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        CompoundCommand referenceSetCompound = new CompoundCommand();
        BasicEList pastedFrameblastingFramesControllers = new BasicEList();
        BasicEList pastedFrameBlastingFrames = new BasicEList();
        if (copiedFrameBlastingFrames != null) {
            FrameBlastingFrame[] frameBlastingFrameArray = copiedFrameBlastingFrames;
            int n = copiedFrameBlastingFrames.length;
            int n2 = 0;
            while (n2 < n) {
                FrameBlastingFrame copiedFrameBlastingFrame = frameBlastingFrameArray[n2];
                FrameBlastingFrame frameBlastingFrame = (FrameBlastingFrame)this.duplicate(referenceSetCompound, (EByteBlowerObject)copiedFrameBlastingFrame);
                if (frameBlastingFrame != null) {
                    FrameBlastingFrameController FrameBlastingFrameController2 = new FrameBlastingFrameController(frameBlastingFrame);
                    pastedFrameBlastingFrames.add((Object)frameBlastingFrame);
                    pastedFrameblastingFramesControllers.add((Object)FrameBlastingFrameController2);
                }
                ++n2;
            }
            compound.appendCommand(this.createAddCommand((Collection<FrameBlastingFrame>)pastedFrameBlastingFrames, pasteIndex));
            compound.appendCommand((Command)referenceSetCompound);
        }
        return new CommandWithFrameBlastingFrameListReference(compound.unwrap(), (List<FrameBlastingFrameController>)pastedFrameblastingFramesControllers);
    }

    public Command setFrameInterval(HighResolutionCalendar newFrameInterval) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_INTERVAL, newFrameInterval);
        return setCommand;
    }

    public Command checkAndSetFrameInterval(HighResolutionCalendar newFrameInterval) {
        Command setCommand = this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_INTERVAL, newFrameInterval);
        return setCommand;
    }

    public Command setFrameRate(BigDecimal rate) {
        FrameBlastingFlowReader reader = this.getReader();
        BigInteger frameInterval = reader.getFrameInterval_ToGetFrameRate(rate);
        if (this.frameIntervalTooSmall(frameInterval)) {
            return null;
        }
        return this.setFrameInterval(new HighResolutionCalendar(Long.valueOf(frameInterval.longValue())));
    }

    public Command checkAndSetFrameRate(BigDecimal rate) {
        FrameBlastingFlowReader reader = this.getReader();
        BigInteger frameInterval = reader.getFrameInterval_ToGetFrameRate(rate);
        if (this.frameIntervalTooSmall(frameInterval)) {
            return null;
        }
        return this.checkAndSetFrameInterval(new HighResolutionCalendar(Long.valueOf(frameInterval.longValue())));
    }

    private boolean frameIntervalTooSmall(BigInteger frameInterval) {
        return frameInterval.compareTo(BigInteger.ONE) == -1;
    }

    public Command setThroughput(BigDecimal throughput) {
        ThroughputType throughputType = this.getProjectThroughputType();
        return this.setThroughput(throughput, throughputType);
    }

    public Command setThroughput(BigDecimal throughput, ThroughputType throughputType) {
        return this.setThroughput(throughput, throughputType, true);
    }

    public Command setThroughput(BigDecimal throughput, ThroughputType throughputType, boolean check) {
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        DataRateUnit unit = frameBlastingFlow.getDataRateUnit();
        return this.setThroughput(throughput, unit, throughputType, check);
    }

    public Command setThroughput(BigDecimal throughput, DataRateUnit unit, ThroughputType throughputType, boolean check) {
        throughput = ThroughputReader.convertThroughput((BigDecimal)throughput, (DataRateUnit)unit, (DataRateUnit)DataRateUnit.BPS);
        return this.setThroughputInBitsPerSecond(throughput, throughputType, check);
    }

    private FrameBlastingFlow getFrameBlastingFlow() {
        return (FrameBlastingFlow)this.getObject();
    }

    private Command setThroughputInBitsPerSecond(BigDecimal bps, ThroughputType throughputType, boolean check) {
        FrameBlastingFlowReader reader = this.getReader();
        BigInteger frameInterval = reader.getFrameInterval_ToGetThroughput(bps, throughputType);
        if (this.frameIntervalTooSmall(frameInterval)) {
            System.out.println("Frame Interval is smaller than 1 ns !");
            return null;
        }
        if (check) {
            return this.checkAndSetFrameInterval(new HighResolutionCalendar(Long.valueOf(frameInterval.longValue())));
        }
        return this.setFrameInterval(new HighResolutionCalendar(Long.valueOf(frameInterval.longValue())));
    }

    private ThroughputType getProjectThroughputType() {
        ByteBlowerProject project = this.getProject();
        return project.getThroughputType();
    }

    public Command setDataRateUnit(DataRateUnit dataRateUnit) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__DATA_RATE_UNIT, dataRateUnit);
        return setCommand;
    }

    public Command setFrameModifier(FrameModifier frameModifier) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, frameModifier);
        return setCommand;
    }

    private static final GrowingSizeModifier createGrowingSizeModifier() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createGrowingSizeModifier();
    }

    private static final MultipleBurst createMultipleBurstModifier() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createMultipleBurst();
    }

    private static final AlternateModifier createAlternateModifier() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createAlternateModifier();
    }

    private static final RandomSizeModifier createRandomSizeModifier() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createRandomSizeModifier();
    }

    public CommandWithGrowingSizeModifierReference setGrowingSizeModifier() {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        GrowingSizeModifier growingSizeModifier = FrameBlastingFlowController.createGrowingSizeModifier();
        compoundCommandController.appendCommand(this.addGrowingSizeModifier(growingSizeModifier));
        return new CommandWithGrowingSizeModifierReference(compoundCommandController.unwrap(), growingSizeModifier);
    }

    public CommandWithRandomSizeModifierReference setRandomSizeModifier() {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        RandomSizeModifier randomSizeModifier = FrameBlastingFlowController.createRandomSizeModifier();
        compoundCommandController.appendCommand(this.addRandomSizeModifier(randomSizeModifier));
        return new CommandWithRandomSizeModifierReference(compoundCommandController.unwrap(), randomSizeModifier);
    }

    public CommandWithSequenceModifierReference setAlternateModifier() {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        AlternateModifier alternateModifier = FrameBlastingFlowController.createAlternateModifier();
        compoundCommandController.appendCommand(this.addAlternateModifier(alternateModifier));
        return new CommandWithSequenceModifierReference(compoundCommandController.unwrap(), (SequenceModifier)alternateModifier);
    }

    private Command addGrowingSizeModifier(GrowingSizeModifier growingSizeModifier) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, growingSizeModifier);
        return setCommand;
    }

    private Command addAlternateModifier(AlternateModifier alternateModifier) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__SEQUENCE_MODIFIER, alternateModifier);
        return setCommand;
    }

    private Command addRandomSizeModifier(RandomSizeModifier randomSizeModifier) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, randomSizeModifier);
        return setCommand;
    }

    public Command setMultipleBurstModifier(MultipleBurst multipleBurst) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__TIMING_MODIFIER, multipleBurst);
        return setCommand;
    }

    public CommandWithMultipleBurstReference setMultipleBurst() {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        MultipleBurst multipleBurst = FrameBlastingFlowController.createMultipleBurstModifier();
        compoundCommandController.appendCommand(this.setMultipleBurstModifier(multipleBurst));
        return new CommandWithMultipleBurstReference(compoundCommandController.unwrap(), multipleBurst);
    }

    CommandWithFrameBlastingFrameListReference addFrameBlastingFrame(int amount) {
        return this.addFrameBlastingFrame(amount, -1);
    }

    public final CommandWithFrameBlastingFrameListReference addFrameBlastingFrame(int amount, int index) {
        Command addCommand;
        FrameBlastingFlow myFrameBlastingFlow = (FrameBlastingFlow)this.getObject();
        if (amount <= 0 || myFrameBlastingFlow == null) {
            return null;
        }
        UniqueEList controllers = new UniqueEList();
        if (amount == 1) {
            FrameBlastingFrame newObject = this.createFrameBlastingFrame();
            controllers.add((Object)FrameBlastingFrameController.getInstance(newObject));
            addCommand = index == -1 ? this.createAddCommand(newObject) : this.createAddCommand(newObject, index);
        } else {
            UniqueEList newObjects = new UniqueEList();
            int i = 0;
            while (i < amount) {
                FrameBlastingFrame newObject = this.createFrameBlastingFrame();
                newObjects.add((Object)newObject);
                controllers.add((Object)ControllerFactory.create(newObject));
                ++i;
            }
            addCommand = index == -1 ? this.createAddCommand((Collection<FrameBlastingFrame>)newObjects) : this.createAddCommand((Collection<FrameBlastingFrame>)newObjects, index);
        }
        return new CommandWithFrameBlastingFrameListReference(addCommand, (List<FrameBlastingFrameController>)controllers);
    }

    private FrameBlastingFrame createFrameBlastingFrame() {
        FrameBlastingFrame result = ByteblowerguimodelFactoryImpl.eINSTANCE.createFrameBlastingFrame();
        return result;
    }

    private Command createAddCommand(Collection<FrameBlastingFrame> objects) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_BLASTING_FRAMES, objects);
    }

    private Command createAddCommand(Collection<FrameBlastingFrame> objects, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_BLASTING_FRAMES, objects, index);
    }

    private final Command createAddCommand(FrameBlastingFrame frameBlastingFrame) {
        return this.createAddCommand(frameBlastingFrame, -1);
    }

    private final Command createAddCommand(FrameBlastingFrame frameBlastingFrame, int index) {
        FrameBlastingFlow myFrameBlastingFlow = (FrameBlastingFlow)this.getObject();
        if (myFrameBlastingFlow != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_BLASTING_FRAMES, frameBlastingFrame, index);
        }
        return null;
    }

    @Override
    public FrameBlastingFlow copy() {
        FrameBlastingFlow copy = (FrameBlastingFlow)super.copy();
        EList<FrameBlastingFrame> fromList = this.getFrameBlastingFrames();
        int size = fromList.size();
        EList toList = copy.getFrameBlastingFrames();
        int i = 0;
        while (i < size) {
            FrameBlastingFrame from = (FrameBlastingFrame)fromList.get(i);
            FrameBlastingFrameImpl to = (FrameBlastingFrameImpl)toList.get(i);
            to.basicSetFrame(from.getFrame(), null);
            ++i;
        }
        return copy;
    }

    private FrameBlastingFlowReader getReader() {
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        return new FrameBlastingFlowReaderImpl(frameBlastingFlow);
    }

    public List<FrameReader> getRepeatedFrameReaders() {
        return this.getReader().getRepeatedFrameReaders();
    }

    public UniqueEList<FrameReader> getUniqueFrames() {
        return this.getReader().getUniqueFrames();
    }

    public BigDecimal getThroughput() {
        return this.getReader().getThroughput();
    }

    public BigDecimal getThroughput(DataRateUnit dataRateUnit) {
        return this.getReader().getThroughput(dataRateUnit);
    }

    public BigDecimal getThroughput(ThroughputType throughputType) {
        return this.getReader().getThroughput(throughputType);
    }

    public BigDecimal getThroughput(ThroughputType throughputType, DataRateUnit unit) {
        return this.getReader().getThroughput(throughputType, unit);
    }

    public String getThroughputString(DataRateUnit dataRateUnit) {
        return this.getReader().getThroughputString(dataRateUnit);
    }

    public String getThroughputString(ThroughputType throughputType) {
        return this.getReader().getThroughputString(throughputType);
    }

    public DataRateUnit getDataRateUnit() {
        return this.getReader().getDataRateUnit();
    }

    public String getThroughputString(ThroughputType throughputType, DataRateUnit dataRateUnit) {
        return this.getReader().getThroughputString(throughputType, dataRateUnit);
    }

    public BigInteger getFrameInterval_ToGetThroughput(BigDecimal bps, ThroughputType throughputType) {
        return this.getReader().getFrameInterval_ToGetThroughput(bps, throughputType);
    }

    public BigInteger getFrameInterval_ToGetFrameRate(BigDecimal rate) {
        return this.getReader().getFrameInterval_ToGetFrameRate(rate);
    }

    public EList<FrameBlastingFrame> getFrameBlastingFrames() {
        return this.getReader().getFrameBlastingFrames();
    }

    public BigDecimal getFrameRate() {
        return this.getReader().getFrameRate();
    }

    public HighResolutionCalendar getFrameInterval() {
        return this.getReader().getFrameInterval();
    }

    public String getFrameInterval_HumanReadable() {
        return this.getReader().getFrameInterval_HumanReadable();
    }

    public FrameModifier getFrameModifier() {
        return this.getReader().getFrameModifier();
    }

    public TimingModifier getTimingModifier() {
        return this.getReader().getTimingModifier();
    }

    public Command addFrame(Frame frame) {
        CommandWithFrameBlastingFrameListReference ref = this.addFrameBlastingFrame();
        FrameBlastingFrameController controller = (FrameBlastingFrameController)((Object)((List)ref.getCommandReference()).get(0));
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(ref.getCommand());
        compound.appendCommand(controller.setFrame(frame));
        return compound.unwrap();
    }

    public CommandWithFrameBlastingFrameListReference addFrameBlastingFrame() {
        return this.addFrameBlastingFrame(1);
    }

    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        return this.getReader().getSupportedLayer3Types();
    }

    @Override
    public String getName() {
        return this.getReader().getName();
    }

    public List<FrameController> getUniqueFrameControllers() {
        ArrayList<FrameController> frameControllers = new ArrayList<FrameController>();
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        for (FrameBlastingFrame frameBlastingFrame : frameBlastingFlow.getFrameBlastingFrames()) {
            Frame frame = frameBlastingFrame.getFrame();
            if (frame == null) continue;
            int weight = frameBlastingFrame.getWeight();
            int i = 0;
            while (i < weight) {
                FrameController controller = ControllerFactory.create(frame);
                frameControllers.add(controller);
                ++i;
            }
        }
        return frameControllers;
    }

    public List<FrameBlastingFrameReader> getFrameBlastingFrameReaders() {
        return this.getReader().getFrameBlastingFrameReaders();
    }

    public long getFrameIntervalInNanoseconds() {
        return this.getReader().getFrameIntervalInNanoseconds();
    }

    @Override
    public void createStatuses() {
        EList<FrameBlastingFrame> frameBlastingFrames = this.getFrameBlastingFrames();
        if (frameBlastingFrames == null || frameBlastingFrames.isEmpty()) {
            this.addErrorStatus("Missing Frames");
        } else {
            FrameReader.Layer3Type layer3Type = null;
            for (FrameBlastingFrame frameBlastingFrame : frameBlastingFrames) {
                FrameBlastingFrameReader frameReader = ReaderFactory.create((FrameBlastingFrame)frameBlastingFrame);
                Frame frame = frameBlastingFrame.getFrame();
                if (frame == null) {
                    this.addErrorStatus("Missing Frames");
                    continue;
                }
                FrameReader reader = ReaderFactory.create((Frame)frame);
                FrameReader.Layer3Type type = reader.getLayer3Type();
                if (layer3Type == null) {
                    layer3Type = type;
                } else if (!layer3Type.isCompatible(type)) {
                    this.addErrorStatus("All Frames must either be IPv4 or IPv6");
                }
                if (!frameReader.hasOverweight()) continue;
                this.addWarningStatus("Frame repeat values above 100 may cause the GUI to become unresponsive.");
            }
        }
    }

    public boolean dataRateTooBig() {
        return this.getReader().dataRateTooBig();
    }

    public static final class CommandWithFrameBlastingFrameListReference
    extends CommandWithListReference<FrameBlastingFrameController> {
        private CommandWithFrameBlastingFrameListReference(Command myCommand, List<FrameBlastingFrameController> myFrameBlastingFrameListCommandReference) {
            super(myCommand, myFrameBlastingFrameListCommandReference);
        }
    }

    private final class CommandWithGrowingSizeModifierReference
    extends CommandWithReference<GrowingSizeModifier> {
        private CommandWithGrowingSizeModifierReference(Command myCommand, GrowingSizeModifier myGrowingSizeModifier) {
            super(myCommand, (Object)myGrowingSizeModifier);
        }
    }

    private final class CommandWithMultipleBurstReference
    extends CommandWithReference<MultipleBurst> {
        private CommandWithMultipleBurstReference(Command myCommand, MultipleBurst myMultipleBurst) {
            super(myCommand, (Object)myMultipleBurst);
        }
    }

    private final class CommandWithRandomSizeModifierReference
    extends CommandWithReference<RandomSizeModifier> {
        private CommandWithRandomSizeModifierReference(Command myCommand, RandomSizeModifier myRandomSizeModifier) {
            super(myCommand, (Object)myRandomSizeModifier);
        }
    }

    private final class CommandWithSequenceModifierReference
    extends CommandWithReference<SequenceModifier> {
        private CommandWithSequenceModifierReference(Command myCommand, SequenceModifier sequenceModifier) {
            super(myCommand, (Object)sequenceModifier);
        }
    }
}

