/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.frame.ARPPacket;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.FlagsField;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.frame.VlanPacket;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameFieldModifier;
import com.excentis.products.byteblower.model.FrameL3TosType;
import com.excentis.products.byteblower.model.FrameL3Type;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.IncrementalFieldModifier;
import com.excentis.products.byteblower.model.RandomFieldModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.UniqueFieldModifier;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FrameFieldModifierController;
import com.excentis.products.byteblower.model.control.IncrementalFieldModifierController;
import com.excentis.products.byteblower.model.control.RandomFieldModifierController;
import com.excentis.products.byteblower.model.control.UniqueFieldModifierController;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.impl.FrameReaderImpl;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CommandWithStringReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class FrameController
extends EByteBlowerObjectController<Frame>
implements FrameReader {
    private static final String newFramePrefix = "FRAME_";
    public static final int BUFFER_SIZE = 11000;
    private byte[] buffer = new byte[11000];
    private EthernetPacket ethernet;
    private Ipv4Packet ipv4;
    private Ipv6Packet ipv6;
    private ARPPacket arp;
    private ProtocolLayer currentLayer3;
    private TCPPacket ipv4_tcp;
    private UDPPacket ipv4_udp;
    private TCPPacket ipv6_tcp;
    private UDPPacket ipv6_udp;
    private ProtocolLayer currentLayer4;
    private static final int DEFAULT_FRAME_SIZE = 1024;
    private static final String SCOUTING_PAYLOAD = "BYTEBLOWER SCOUTING FRAME";
    private static final int PRIVATE_UDP_SOURCE_PORT = 63480;
    private static final int PRIVATE_UDP_DESTINATION_PORT = 63481;
    public static final int LAYER_4_PROTOCOL_TCP = 0;
    public static final int LAYER_4_PROTOCOL_UDP = 1;
    public static final int LAYER_4_PROTOCOL_NOT_SUPPORTED = 2;
    public static final int LAYER_4_PROTOCOL_UNKNOWN = 3;

    public FrameController(Frame frame) {
        super(frame);
        this.createLayers();
        this.update();
    }

    private void createLayers() {
        this.ethernet = new EthernetPacket();
        this.ipv4 = new Ipv4Packet((ProtocolLayer)this.ethernet);
        this.ipv6 = new Ipv6Packet((ProtocolLayer)this.ethernet);
        this.arp = new ARPPacket((ProtocolLayer)this.ethernet);
        this.ipv4_tcp = new TCPPacket((ProtocolLayer)this.ipv4);
        this.ipv4_udp = new UDPPacket((ProtocolLayer)this.ipv4);
        this.ipv6_tcp = new TCPPacket((ProtocolLayer)this.ipv6);
        this.ipv6_udp = new UDPPacket((ProtocolLayer)this.ipv6);
    }

    private static final Frame create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createFrame();
    }

    protected static final Frame create(ByteBlowerProject byteblowerProject, String referenceFrameName) {
        String newFrameName;
        Frame newFrame = FrameController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newFrame, (String)(newFrameName = referenceFrameName))) {
            newFrameName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newFrame, (String)newFrameName, (String)newFramePrefix);
        }
        newFrame.setName(newFrameName);
        FrameController.initializeFrame_Ipv4_UDP(newFrame);
        return newFrame;
    }

    public boolean isContained() {
        Frame myFrame = (Frame)this.getObject();
        return myFrame != null && myFrame.eContainer() != null;
    }

    public final CommandWithStringReference setIncrementedName(Frame selectedFrame, List<String> takenNames) {
        String newName = OldNamingTools.getIncrementedName((String)selectedFrame.getName(), takenNames);
        Command newCommand = this.createSetNameCommand(newName);
        return new CommandWithStringReference(newCommand, newName);
    }

    private Command setBytesHexString(String bytesHexString) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__BYTES_HEX_STRING, bytesHexString);
    }

    public Command setL2AutoDestMac(Boolean l2AutoDestMac) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L2_AUTO_DEST_MAC, l2AutoDestMac);
    }

    public Command setL2AutoSourceMac(Boolean l2AutoSourceMac) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L2_AUTO_SOURCE_MAC, l2AutoSourceMac);
    }

    public Command setL3AutoArpSHA(Boolean l3AutoArpSHA) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_ARP_SHA, l3AutoArpSHA);
    }

    public Command setL3AutoArpTHA(Boolean l3AutoArpTHA) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_ARP_THA, l3AutoArpTHA);
    }

    public Command setL3AutoArpSPA(Boolean l3AutoArpSPA) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_ARP_SPA, l3AutoArpSPA);
    }

    public Command setL3AutoArpTPA(Boolean l3AutoArpTPA) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_ARP_TPA, l3AutoArpTPA);
    }

    public Command setL3AutoIpv6PayloadLength(Boolean l3AutoIpv6PayloadLength) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_IPV6_PAYLOAD_LENGTH, l3AutoIpv6PayloadLength);
    }

    public Command setL3AutoIpv6Source(Boolean l3AutoIpv6Source) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_IPV6_SOURCE, l3AutoIpv6Source);
    }

    public Command setL3AutoIpv6Destination(Boolean l3AutoIpv6Destination) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_IPV6_DESTINATION, l3AutoIpv6Destination);
    }

    public Command setL4AutoTotLen(Boolean l4AutoTotLen) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_TOT_LEN, l4AutoTotLen);
    }

    public Command setL4AutoUdpChecksum(Boolean l4AutoUdpChecksum) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_UDP_CHECKSUM, l4AutoUdpChecksum);
    }

    public Command setL3AutoHeaderCheck() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_HEADER_CHECK);
    }

    public Command setIPv4AutoTotLen() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_TOT_LEN);
    }

    public Command setL3AutoIpv6PayloadLength() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_IPV6_PAYLOAD_LENGTH);
    }

    public Command setL4AutoTcpChecksum() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_TCP_CHECKSUM);
    }

    public Command setL4AutoTotLen() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_TOT_LEN);
    }

    public Command setL4AutoUdpChecksum() {
        return this.setAutomaticField(ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_UDP_CHECKSUM);
    }

    private Command setAutomaticField(EAttribute eAttribute) {
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        Command setCommand = this.checkAndCreateSetCommand((EStructuralFeature)eAttribute, Boolean.TRUE);
        if (setCommand != null) {
            compoundController.appendCommand(setCommand);
            Frame tempFrame = (Frame)EcoreUtil.copy((EObject)this.getFrame());
            Command tempSetCommand = SetCommand.create((EditingDomain)editingDomain, (Object)tempFrame, (Object)eAttribute, (Object)Boolean.TRUE);
            tempSetCommand.execute();
            FrameController tempController = ControllerFactory.create(tempFrame);
            Command command = tempController.updateAutomaticFields();
            if (command != null) {
                command.execute();
                String newHexBytes = tempFrame.getBytesHexString();
                compoundController.appendCommand(this.setBytesHexString(newHexBytes));
            }
        }
        return compoundController.unwrap();
    }

    public Command setL4AutoTcpChecksum(Boolean l4AutoTcpChecksum) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L4_AUTO_TCP_CHECKSUM, l4AutoTcpChecksum);
    }

    public void update() {
        String hexString = this.getFrame().getBytesHexString();
        if (hexString != null) {
            this.update(hexString);
        }
    }

    private void update(String hexBytes) {
        this.resetEthernet(hexBytes);
        this.updateLayers();
    }

    private void updateLayers() {
        this.updateLayer3();
        this.updateLayer4();
    }

    private void updateLayer3() {
        ProtocolField ethernetPayload = this.ethernet.getPayload();
        switch (this.ethernet.getType()) {
            case 2048: {
                this.currentLayer3 = this.ipv4;
                break;
            }
            case 34525: {
                this.currentLayer3 = this.ipv6;
                break;
            }
            case 2054: {
                this.currentLayer3 = this.arp;
                break;
            }
            default: {
                this.currentLayer3 = null;
                return;
            }
        }
        int size = ethernetPayload.dump(this.buffer, 0);
        this.currentLayer3.set(size, this.buffer, 0);
        this.ethernet.setPayload((ProtocolField)this.currentLayer3);
    }

    private void updateLayer4() {
        if (this.currentLayer3 == this.ipv4) {
            ProtocolField ipv4Payload = this.ipv4.getPayload();
            switch (this.ipv4.getProtocol()) {
                case 6: {
                    this.currentLayer4 = this.ipv4_tcp;
                    break;
                }
                case 17: {
                    this.currentLayer4 = this.ipv4_udp;
                    break;
                }
                default: {
                    return;
                }
            }
            int size = ipv4Payload.dump(this.buffer, 0);
            this.currentLayer4.set(size, this.buffer, 0);
            this.ipv4.setPayload((ProtocolField)this.currentLayer4);
        } else if (this.currentLayer3 == this.ipv6) {
            ProtocolField ipv6Payload = this.ipv6.getPayload();
            switch (this.ipv6.getNextHeader()) {
                case 6: {
                    this.currentLayer4 = this.ipv6_tcp;
                    break;
                }
                case 17: {
                    this.currentLayer4 = this.ipv6_udp;
                    break;
                }
                default: {
                    return;
                }
            }
            int size = ipv6Payload.dump(this.buffer, 0);
            this.currentLayer4.set(size, this.buffer, 0);
            this.ipv6.setPayload((ProtocolField)this.currentLayer4);
        } else {
            return;
        }
    }

    private void resetEthernet(String hexBytes) {
        int frameByteSize = hexBytes.length() / 2;
        byte[] bytes = this.getBytes(hexBytes);
        this.ethernet.set(frameByteSize * 8, bytes, 0);
    }

    public byte[] getBytes() {
        return this.getBytes(this.getFrame().getBytesHexString());
    }

    private byte[] getBytes(String bytesHexString) {
        int size = 0;
        if (bytesHexString != null) {
            size = bytesHexString.length() / 2;
        }
        byte[] bts = new byte[size];
        try {
            int i = 0;
            while (i < size) {
                String byteString = bytesHexString.substring(2 * i, 2 * i + 2);
                bts[i] = (byte)Integer.parseInt(byteString, 16);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("FRAME GETBYTES ERROR : " + e.getMessage());
        }
        return bts;
    }

    public ARPPacket getArp() {
        return this.arp;
    }

    public EthernetPacket getEthernet() {
        return this.ethernet;
    }

    public Ipv4Packet getIpv4() {
        return this.ipv4;
    }

    public Ipv6Packet getIpv6() {
        return this.ipv6;
    }

    public UDPPacket getCurrentUdp() {
        if (this.currentLayer4 instanceof UDPPacket) {
            return (UDPPacket)this.currentLayer4;
        }
        return null;
    }

    public TCPPacket getCurrentTcp() {
        if (this.currentLayer4 instanceof TCPPacket) {
            return (TCPPacket)this.currentLayer4;
        }
        return null;
    }

    private Command updateAutomaticFields() {
        Frame frame = this.getFrame();
        if (this.ethernet == null || frame == null) {
            return null;
        }
        if (this.currentLayer3 == this.ipv4) {
            if (frame.getL3AutoTotLen().booleanValue()) {
                this.ipv4.autoSetLength();
            }
            if (frame.getL3AutoHeaderCheck().booleanValue()) {
                this.ipv4.doCheckSum();
            }
            if (this.currentLayer4 == this.ipv4_tcp) {
                if (frame.getL4AutoTcpChecksum().booleanValue()) {
                    this.ipv4_tcp.doCheckSum();
                }
            } else if (this.currentLayer4 == this.ipv4_udp) {
                if (frame.getL4AutoTotLen().booleanValue()) {
                    this.ipv4_udp.autoSetLength();
                }
                if (frame.getL4AutoUdpChecksum().booleanValue()) {
                    this.ipv4_udp.doCheckSum();
                }
            }
        } else if (this.currentLayer3 == this.ipv6) {
            if (frame.getL3AutoIpv6PayloadLength().booleanValue()) {
                this.ipv6.autoSetPayloadLength();
            }
            if (this.currentLayer4 == this.ipv6_tcp) {
                if (frame.getL4AutoTcpChecksum().booleanValue()) {
                    this.ipv6_tcp.doCheckSum();
                }
            } else if (this.currentLayer4 == this.ipv6_udp) {
                if (frame.getL4AutoTotLen().booleanValue()) {
                    this.ipv6_udp.autoSetLength();
                }
                if (frame.getL4AutoUdpChecksum().booleanValue()) {
                    this.ipv6_udp.doCheckSum();
                }
            }
        }
        return this.dumpEthernetToHex();
    }

    private Command dumpEthernetToHex() {
        int byteSize = this.ethernet.getSize() / 8;
        this.ethernet.dump(this.buffer, 0);
        String correctBytes = Utils.bufferToHexString((byte[])this.buffer, (int)byteSize);
        return this.setBytesHexString(correctBytes);
    }

    public Command updateAllFields() {
        Frame frame = this.getFrame();
        if (this.ethernet == null || frame == null) {
            return null;
        }
        if (this.currentLayer3 == this.ipv4) {
            this.ipv4.autoSetLength();
            this.ipv4.doCheckSum();
            if (this.currentLayer4 == this.ipv4_tcp) {
                this.ipv4_tcp.doCheckSum();
            } else if (this.currentLayer4 == this.ipv4_udp) {
                this.ipv4_udp.autoSetLength();
                this.ipv4_udp.doCheckSum();
            }
        } else if (this.currentLayer3 == this.ipv6) {
            this.ipv6.autoSetPayloadLength();
            if (this.currentLayer4 == this.ipv6_tcp) {
                this.ipv6_tcp.doCheckSum();
            } else if (this.currentLayer4 == this.ipv6_udp) {
                this.ipv6_udp.autoSetLength();
                this.ipv6_udp.doCheckSum();
            }
        }
        int byteSize = this.ethernet.getSize() / 8;
        this.ethernet.dump(this.buffer, 0);
        String correctBytes = Utils.bufferToHexString((byte[])this.buffer, (int)byteSize);
        return this.setBytesHexString(correctBytes);
    }

    public Command setCorrectedHexBytes(String hexBytes) {
        this.update(hexBytes);
        return this.updateAutomaticFields();
    }

    public Command setFrameSize(int size) {
        String newHexBytes = this.changeSize(size);
        return this.setCorrectedHexBytes(newHexBytes);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String getHexBytes() {
        return this.getFrame().getBytesHexString();
    }

    public static void initializeFrame_Ipv4_UDP(Frame frame) {
        frame.setL2AutoDestMac(Boolean.TRUE);
        frame.setL2AutoSourceMac(Boolean.TRUE);
        frame.setL3TosType(FrameL3TosType.TOS_LITERAL);
        frame.setL3AutoTotLen(Boolean.TRUE);
        frame.setL3AutoHeaderCheck(Boolean.TRUE);
        frame.setL3AutoSourceIp(Boolean.TRUE);
        frame.setL3AutoDestIp(Boolean.TRUE);
        frame.setL4AllowPortOverride(Boolean.TRUE);
        frame.setL4AutoTotLen(Boolean.TRUE);
        frame.setL4AutoUdpChecksum(Boolean.TRUE);
        frame.getModifiers().add((Object)UniqueFieldModifierController.create());
        FrameController frameController = ControllerFactory.create(frame);
        EthernetPacket ethernet = frameController.ethernet;
        Ipv4Packet ipv4 = frameController.ipv4;
        UDPPacket ipv4_udp = frameController.ipv4_udp;
        ethernet.setType(2048);
        ethernet.setPayload((ProtocolField)ipv4);
        ipv4.setVersion(4);
        ipv4.setIHL(5);
        ipv4.setId(632);
        ipv4.setFlags("");
        ipv4.setFragmentOffset(0);
        ipv4.setTTL(254);
        ipv4.setProtocol(17);
        ipv4.setSourceAddress("1.1.1.1");
        ipv4.setDestinationAddress("1.1.1.1");
        ipv4.setPayload((ProtocolField)ipv4_udp);
        ipv4_udp.setSource(4096);
        ipv4_udp.setDestination(4096);
        ipv4_udp.setPayload("Excentis ByteBlower Default Payload.");
        frameController.dumpEthernetToHex().execute();
        frameController.setFrameSize(1024).execute();
    }

    private static void initializeFrame_Ipv4_UDP(Frame frame, int size) {
        frame.setL2AutoDestMac(Boolean.TRUE);
        frame.setL2AutoSourceMac(Boolean.TRUE);
        frame.setL3TosType(FrameL3TosType.TOS_LITERAL);
        frame.setL3AutoTotLen(Boolean.TRUE);
        frame.setL3AutoHeaderCheck(Boolean.TRUE);
        frame.setL3AutoSourceIp(Boolean.TRUE);
        frame.setL3AutoDestIp(Boolean.TRUE);
        frame.setL4AllowPortOverride(Boolean.TRUE);
        frame.setL4AutoTotLen(Boolean.TRUE);
        frame.setL4AutoUdpChecksum(Boolean.TRUE);
        frame.getModifiers().add((Object)UniqueFieldModifierController.create());
        FrameController frameController = ControllerFactory.create(frame);
        EthernetPacket ethernet = frameController.ethernet;
        Ipv4Packet ipv4 = frameController.ipv4;
        UDPPacket ipv4_udp = frameController.ipv4_udp;
        ethernet.setType(2048);
        ethernet.setPayload((ProtocolField)ipv4);
        ipv4.setVersion(4);
        ipv4.setIHL(5);
        ipv4.setId(632);
        ipv4.setFlags("");
        ipv4.setFragmentOffset(0);
        ipv4.setTTL(254);
        ipv4.setProtocol(17);
        ipv4.setSourceAddress("1.1.1.1");
        ipv4.setDestinationAddress("1.1.1.1");
        ipv4.setPayload((ProtocolField)ipv4_udp);
        ipv4_udp.setSource(4096);
        ipv4_udp.setDestination(4096);
        ipv4_udp.setPayload("Excentis ByteBlower Default Payload.");
        frameController.dumpEthernetToHex().execute();
        frameController.setFrameSize(size).execute();
    }

    private static void initializeFrame_Ipv6_UDP(Frame frame) {
        frame.setL2AutoDestMac(Boolean.TRUE);
        frame.setL2AutoSourceMac(Boolean.TRUE);
        frame.setL3AutoIpv6PayloadLength(Boolean.TRUE);
        frame.setL3AutoIpv6Source(Boolean.TRUE);
        frame.setL3AutoIpv6Destination(Boolean.TRUE);
        frame.setL4AutoTotLen(Boolean.TRUE);
        frame.setL4AutoUdpChecksum(Boolean.TRUE);
        FrameController frameController = ControllerFactory.create(frame);
        EthernetPacket ethernet = frameController.ethernet;
        Ipv6Packet ipv6 = frameController.ipv6;
        UDPPacket ipv6_udp = frameController.ipv6_udp;
        ethernet.setType(34525);
        ethernet.setPayload((ProtocolField)ipv6);
        ipv6.setVersion(6);
        ipv6.setTrafficClass(0);
        ipv6.setFlowLabel(0);
        ipv6.setNextHeader(17);
        ipv6.setHopLimit(255);
        ipv6.setPayload((ProtocolField)ipv6_udp);
        ipv6_udp.setPayload("Excentis ByteBlower Default Payload.");
        frameController.dumpEthernetToHex().execute();
        frameController.setFrameSize(1024).execute();
    }

    private static void initializeFrame_Ipv6_UDP(Frame frame, int size) {
        frame.setL2AutoDestMac(Boolean.TRUE);
        frame.setL2AutoSourceMac(Boolean.TRUE);
        frame.setL3AutoIpv6PayloadLength(Boolean.TRUE);
        frame.setL3AutoIpv6Source(Boolean.TRUE);
        frame.setL3AutoIpv6Destination(Boolean.TRUE);
        frame.setL4AutoTotLen(Boolean.TRUE);
        frame.setL4AutoUdpChecksum(Boolean.TRUE);
        FrameController frameController = ControllerFactory.create(frame);
        EthernetPacket ethernet = frameController.ethernet;
        Ipv6Packet ipv6 = frameController.ipv6;
        UDPPacket ipv6_udp = frameController.ipv6_udp;
        ethernet.setType(34525);
        ethernet.setPayload((ProtocolField)ipv6);
        ipv6.setVersion(6);
        ipv6.setTrafficClass(0);
        ipv6.setFlowLabel(0);
        ipv6.setNextHeader(17);
        ipv6.setHopLimit(255);
        ipv6.setPayload((ProtocolField)ipv6_udp);
        ipv6_udp.setPayload("Excentis ByteBlower Default Payload.");
        frameController.dumpEthernetToHex().execute();
        frameController.setFrameSize(size).execute();
    }

    public Frame getFrame() {
        return (Frame)this.getObject();
    }

    private String changeSize(int newSize) {
        String newHexString;
        int size = this.getSize();
        String hexString = this.getFrame().getBytesHexString();
        if (newSize < size) {
            newHexString = hexString.substring(0, newSize * 2);
        } else {
            newHexString = size > 0 ? hexString : "";
            while (size < newSize) {
                newHexString = String.valueOf(newHexString) + "00";
                ++size;
            }
        }
        return newHexString;
    }

    public int getSize() {
        String myBytesHexString = this.getFrame().getBytesHexString();
        return myBytesHexString == null ? 0 : myBytesHexString.length() / 2;
    }

    public int getEthernetBitSize(ThroughputType throughputType) {
        int byteSize = this.getSize();
        switch (throughputType.getValue()) {
            case 1: {
                byteSize += 4;
                break;
            }
            case 2: {
                byteSize += 24;
                break;
            }
        }
        return byteSize * 8;
    }

    public Command setEthernetDA(String destMac) {
        this.ethernet.setDA(destMac);
        return this.updateAutomaticFields();
    }

    public Command setEthernetSA(String sourceMac) {
        this.ethernet.setSA(sourceMac);
        return this.updateAutomaticFields();
    }

    public Command setL2Type(int newType) {
        int oldType = this.ethernet.getType();
        CompoundCommandController compound = CompoundCommandController.createInstance();
        this.ethernet.setType(newType);
        this.updateLayers();
        if (oldType == 2048 && newType == 34525) {
            this.setL2Type_Ipv4ToIPv6(compound);
        } else if (oldType == 34525 && newType == 2048) {
            this.setL2Type_Ipv6ToIPv4(compound);
        }
        compound.appendCommand(this.updateAutomaticFields());
        return compound.unwrap();
    }

    private void setL2Type_Ipv6ToIPv4(CompoundCommandController compound) {
        int version = this.ipv6.getVersion();
        this.ipv4.setVersion(version == 6 ? 4 : version);
        this.ipv4.setTOS(this.ipv6.getTrafficClass());
        this.ipv4.setId(this.ipv6.getFlowLabel());
        this.ipv4.setProtocol(this.ipv6.getNextHeader());
        this.updateLayers();
        this.ipv4.setTTL(this.ipv6.getHopLimit());
        this.ipv4.setIHL(5);
        this.ipv4.setFragmentOffset(0);
        Frame frame = this.getFrame();
        if (frame.getL3AutoIpv6PayloadLength().booleanValue()) {
            compound.appendCommand(this.setIPv4AutoTotLen());
        } else {
            this.ipv4.setLen(this.ipv6.getPayloadLength());
        }
        boolean autoDestinationIPv6 = frame.getL3AutoIpv6Destination();
        compound.appendCommand(this.setIPv4AutoDestIp(autoDestinationIPv6));
        boolean autoSourceIPv6 = frame.getL3AutoIpv6Source();
        compound.appendCommand(this.setIPv4AutoSourceIp(autoSourceIPv6));
        int payloadByteSize = this.ipv6.getPayload().getSize() / 8 + 20;
        byte[] ipv6Buffer = new byte[payloadByteSize];
        this.ipv6.getPayload().dump(ipv6Buffer, 0);
        this.ipv4.getPayload().set(payloadByteSize * 8, ipv6Buffer, 0);
    }

    private void setL2Type_Ipv4ToIPv6(CompoundCommandController compound) {
        this.ipv6.setNextHeader(this.ipv4.getProtocol());
        this.updateLayers();
        int version = this.ipv4.getVersion();
        this.ipv6.setVersion(version == 4 ? 6 : version);
        this.ipv6.setTrafficClass(this.ipv4.getTOS());
        this.ipv6.setFlowLabel(this.ipv4.getId());
        this.ipv6.setHopLimit(this.ipv4.getTTL());
        Frame frame = this.getFrame();
        if (frame.getL3AutoTotLen().booleanValue()) {
            compound.appendCommand(this.setL3AutoIpv6PayloadLength());
        } else {
            this.ipv6.setPayloadLength(this.ipv4.getLen());
        }
        boolean autoSourceIPv4 = frame.getL3AutoSourceIp();
        boolean autoDestinationIPv4 = frame.getL3AutoDestIp();
        compound.appendCommand(this.setL3AutoIpv6Destination(autoDestinationIPv4));
        compound.appendCommand(this.setL3AutoIpv6Source(autoSourceIPv4));
        int payloadByteSize = this.ipv4.getPayload().getSize() / 8;
        byte[] ipv4Buffer = new byte[payloadByteSize];
        this.ipv4.getPayload().dump(ipv4Buffer, 0);
        this.ipv6.getPayload().set((payloadByteSize - 20) * 8, ipv4Buffer, 0);
    }

    public Command setIpv4Protocol(int value) {
        this.ipv4.setProtocol(value);
        this.updateLayer4();
        return this.updateAutomaticFields();
    }

    public Command setIpv6NextHeader(int nextHeader) {
        this.ipv6.setNextHeader(nextHeader);
        this.updateLayer4();
        return this.updateAutomaticFields();
    }

    public Command setUdpSource(int intSpn) {
        UDPPacket udp = this.getCurrentUdp();
        udp.setSource(intSpn);
        return this.updateAutomaticFields();
    }

    public Command setUdpDestination(int intDpn) {
        UDPPacket udp = this.getCurrentUdp();
        udp.setDestination(intDpn);
        return this.updateAutomaticFields();
    }

    public Command setUdpLength(int inttotlen) {
        UDPPacket udp = this.getCurrentUdp();
        udp.setLength(inttotlen);
        return this.updateAutomaticFields();
    }

    public Command setUdpCheckSum(int intcheck) {
        UDPPacket udp = this.getCurrentUdp();
        udp.setCheckSum(intcheck);
        return this.updateAutomaticFields();
    }

    public Command setArpHardType(int inttype) {
        this.arp.setHardType(inttype);
        return this.updateAutomaticFields();
    }

    public Command setArpProType(int inttype) {
        this.arp.setProType(inttype);
        return this.updateAutomaticFields();
    }

    public Command setArpHardLen(int inttype) {
        this.arp.setHardLen(inttype);
        return this.updateAutomaticFields();
    }

    public Command setArpProLen(int inttype) {
        this.arp.setProLen(inttype);
        return this.updateAutomaticFields();
    }

    public Command setArpOperation(int inttype) {
        this.arp.setOperation(inttype);
        return this.updateAutomaticFields();
    }

    public Command setArpSHA(String sha) {
        this.arp.setSHA(sha);
        return this.updateAutomaticFields();
    }

    public Command setArpTHA(String tha) {
        this.arp.setTHA(tha);
        return this.updateAutomaticFields();
    }

    public Command setArpSPA(String spa) {
        this.arp.setSPA(spa);
        return this.updateAutomaticFields();
    }

    public Command setArpTPA(String tpa) {
        this.arp.setTPA(tpa);
        return this.updateAutomaticFields();
    }

    public Command setIpv6Version(int value) {
        this.ipv6.setVersion(value);
        return this.updateAutomaticFields();
    }

    public Command setIpv6TrafficClass(int value) {
        this.ipv6.setTrafficClass(value);
        return this.updateAutomaticFields();
    }

    public Command setIpv6FlowLabel(int value) {
        this.ipv6.setFlowLabel(value);
        return this.updateAutomaticFields();
    }

    public Command setIpv6PayloadLength(int value) {
        this.ipv6.setPayloadLength(value);
        return this.updateAutomaticFields();
    }

    public Command setIpv6HopLimit(int value) {
        this.ipv6.setHopLimit(value);
        return this.updateAutomaticFields();
    }

    public Command setIpv6SourceAddress(String address) {
        this.ipv6.setSourceAddress(address);
        return this.updateAutomaticFields();
    }

    public Command setIpv6DestinationAddress(String address) {
        this.ipv6.setDestinationAddress(address);
        return this.updateAutomaticFields();
    }

    public Command setIPv4Version(int value) {
        this.ipv4.setVersion(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4IHL(int value) {
        this.ipv4.setIHL(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4Len(int value) {
        this.ipv4.setLen(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4Id(int value) {
        this.ipv4.setId(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4FragmentOffset(int value) {
        this.ipv4.setFragmentOffset(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4TTL(int value) {
        this.ipv4.setTTL(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4CheckSum(int value) {
        this.ipv4.setCheckSum(value);
        return this.updateAutomaticFields();
    }

    public Command setIPv4SourceAddress(String address) {
        this.ipv4.setSourceAddress(address);
        return this.updateAutomaticFields();
    }

    public Command setIPv4DestinationAddress(String address) {
        this.ipv4.setDestinationAddress(address);
        return this.updateAutomaticFields();
    }

    public Command setIPv4TosType(FrameL3TosType l3TosType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_TOS_TYPE, l3TosType);
    }

    public Command setIPv4AutoTotLen(Boolean l3AutoTotLen) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_TOT_LEN, l3AutoTotLen);
    }

    public Command setIPv4AutoHeaderCheck(Boolean l3AutoHeaderCheck) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_HEADER_CHECK, l3AutoHeaderCheck);
    }

    public Command setIPv4AutoSourceIp(Boolean l3AutoSourceIp) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_SOURCE_IP, l3AutoSourceIp);
    }

    public Command setIPv4AutoDestIp(Boolean l3AutoDestIp) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__L3_AUTO_DEST_IP, l3AutoDestIp);
    }

    public Command setIPv4Flags(String flags) {
        this.ipv4.resetFlags("Reserved|DNF|MF");
        this.ipv4.setFlags(flags);
        return this.updateAutomaticFields();
    }

    public Command updateTosFlag(int bit, boolean set) {
        int tos = this.ipv4.getTOS();
        BitSet bitset = new BitSet(8);
        int i = 0;
        while (i < 8) {
            if ((tos >> i & 1) == 1) {
                bitset.set(i);
            }
            ++i;
        }
        bitset.set(bit, set);
        int result = 0;
        int add = 1;
        int i2 = 0;
        while (i2 < 8) {
            add = 1 << i2;
            if (bitset.get(i2)) {
                result += add;
            }
            ++i2;
        }
        this.ipv4.setTOS(result);
        return this.updateAutomaticFields();
    }

    public Command setTcpFlag(String flag, boolean set) {
        TCPPacket tcp = this.getCurrentTcp();
        FlagsField flags = tcp.getFlagsField();
        if (set) {
            flags.set(flag);
        } else {
            flags.reset(flag);
        }
        tcp.setFlags(flags.toString());
        return this.updateAutomaticFields();
    }

    public Command setTcpSource(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setSource(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpDestination(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setDestination(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpSequence(long value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setSequence(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpACK(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setACK((long)value);
        return this.updateAutomaticFields();
    }

    public Command setTcpDataOffset(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setDataOffset(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpReserved(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setReserved(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpWindow(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setWindow(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpCheckSum(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setCheckSum(value);
        return this.updateAutomaticFields();
    }

    public Command setTcpUrgent(int value) {
        TCPPacket tcp = this.getCurrentTcp();
        tcp.setUrgent(value);
        return this.updateAutomaticFields();
    }

    private Command createAddModifier(FrameModifier ... modifier) {
        Frame myFrame = (Frame)this.getObject();
        if (myFrame != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__MODIFIERS, Arrays.asList(modifier));
        }
        return null;
    }

    private Command createRemoveModifier(FrameModifier ... modifier) {
        Frame myFrame = (Frame)this.getObject();
        if (myFrame != null) {
            return this.createRemoveCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FRAME__MODIFIERS, Arrays.asList(modifier));
        }
        return null;
    }

    private String createScoutingFrame(boolean doIPv4, String sourceMacAddress, String destinationMacAddress, String sourceIpAddress, String destinationIpAddress, List<Vlan> vlans) {
        Frame scoutingFrame = this.getFrame();
        if (doIPv4) {
            FrameController.initializeFrame_Ipv4_UDP(scoutingFrame);
        } else {
            FrameController.initializeFrame_Ipv6_UDP(scoutingFrame);
        }
        this.update(scoutingFrame.getBytesHexString());
        this.ethernet.setSA(sourceMacAddress);
        if (scoutingFrame.getL2AutoDestMac().booleanValue()) {
            this.ethernet.setDA(destinationMacAddress);
        }
        if (doIPv4) {
            this.ipv4.setSourceAddress(sourceIpAddress);
            this.ipv4.setDestinationAddress(destinationIpAddress);
        } else {
            this.ipv6.setSourceAddress(sourceIpAddress);
            this.ipv6.setDestinationAddress(destinationIpAddress);
        }
        UDPPacket udp = this.getCurrentUdp();
        udp.setPayload(SCOUTING_PAYLOAD);
        udp.setSource(63480);
        udp.setDestination(63481);
        this.updateAutomaticFields().execute();
        this.addVlans(vlans);
        int byteSize = this.ethernet.getSize() / 8;
        byte[] buffer = new byte[byteSize];
        this.ethernet.dump(buffer, 0);
        String hexBytes = Utils.bufferToHexString((byte[])buffer, (int)buffer.length);
        scoutingFrame.setBytesHexString(hexBytes);
        return hexBytes;
    }

    public String createIPv4ScoutingFrame(String sourceMacAddress, String destinationMacAddress, String sourceIpAddress, String destinationIpAddress, List<Vlan> vlans, int srcUDP, int dstUdp, int size) {
        Frame scoutingFrame = this.getFrame();
        FrameController.initializeFrame_Ipv4_UDP(scoutingFrame, size);
        this.update(scoutingFrame.getBytesHexString());
        this.ethernet.setSA(sourceMacAddress);
        if (scoutingFrame.getL2AutoDestMac().booleanValue()) {
            this.ethernet.setDA(destinationMacAddress);
        }
        this.ipv4.setSourceAddress(sourceIpAddress);
        this.ipv4.setDestinationAddress(destinationIpAddress);
        UDPPacket udp = this.getCurrentUdp();
        udp.setSource(srcUDP);
        udp.setDestination(dstUdp);
        this.updateAutomaticFields().execute();
        this.addVlans(vlans);
        int byteSize = this.ethernet.getSize() / 8;
        byte[] buffer = new byte[byteSize];
        this.ethernet.dump(buffer, 0);
        String hexBytes = Utils.bufferToHexString((byte[])buffer, (int)buffer.length);
        scoutingFrame.setBytesHexString(hexBytes);
        return hexBytes;
    }

    public String createIPv6ScoutingFrame(String sourceMacAddress, String destinationMacAddress, String sourceIpAddress, String destinationIpAddress, List<Vlan> vlans, int srcUDP, int dstUdp, int size) {
        Frame scoutingFrame = this.getFrame();
        FrameController.initializeFrame_Ipv6_UDP(scoutingFrame, size);
        this.update(scoutingFrame.getBytesHexString());
        this.ethernet.setSA(sourceMacAddress);
        if (scoutingFrame.getL2AutoDestMac().booleanValue()) {
            this.ethernet.setDA(destinationMacAddress);
        }
        this.ipv6.setSourceAddress(sourceIpAddress);
        this.ipv6.setDestinationAddress(destinationIpAddress);
        UDPPacket udp = this.getCurrentUdp();
        udp.setSource(srcUDP);
        udp.setDestination(dstUdp);
        this.updateAutomaticFields().execute();
        this.addVlans(vlans);
        int byteSize = this.ethernet.getSize() / 8;
        byte[] buffer = new byte[byteSize];
        this.ethernet.dump(buffer, 0);
        String hexBytes = Utils.bufferToHexString((byte[])buffer, (int)buffer.length);
        scoutingFrame.setBytesHexString(hexBytes);
        return hexBytes;
    }

    private void addVlans(List<Vlan> vlans) {
        ListIterator<Vlan> innerToOut = vlans.listIterator(vlans.size());
        while (innerToOut.hasPrevious()) {
            Vlan vlan = innerToOut.previous();
            VlanPacket vlanPacket = new VlanPacket((ProtocolLayer)this.ethernet);
            vlanPacket.setProtocol((int)((short)this.ethernet.getType()));
            vlanPacket.setPayload(this.ethernet.getPayload());
            vlanPacket.setVID(vlan.getVlanId());
            vlanPacket.setPCP(vlan.getPriorityCodePoint());
            vlanPacket.setDE(vlan.isDropEligible());
            this.ethernet.setType(vlan.getProtocolId());
            this.ethernet.setPayload((ProtocolField)vlanPacket);
        }
    }

    public int getCurrentLayer4Type() {
        int type = this.ethernet.getType();
        switch (type) {
            case 2048: {
                switch (this.ipv4.getProtocol()) {
                    case 6: {
                        return 0;
                    }
                    case 17: {
                        return 1;
                    }
                }
                return 2;
            }
            case 34525: {
                switch (this.ipv6.getNextHeader()) {
                    case 6: {
                        return 0;
                    }
                    case 17: {
                        return 1;
                    }
                }
                return 2;
            }
        }
        return 3;
    }

    public int getL3Type() {
        return this.ethernet.getType();
    }

    public int getL4Type() {
        switch (this.getL3Type()) {
            case 2048: {
                return this.ipv4.getProtocol();
            }
            case 34525: {
                return this.ipv6.getNextHeader();
            }
        }
        return -1;
    }

    private FrameReader getReader() {
        return new FrameReaderImpl(this.getFrame());
    }

    public int getByteSize(ThroughputType throughputType) {
        return this.getReader().getByteSize(throughputType);
    }

    public FrameReader.Layer3Type getLayer3Type() {
        return this.getReader().getLayer3Type();
    }

    public FrameReader.Layer4Type getLayer4Type() {
        return this.getReader().getLayer4Type();
    }

    public int getBitSize(ThroughputType throughputType) {
        return this.getReader().getBitSize(throughputType);
    }

    public FrameL3Type getEthernetType() {
        return this.getReader().getEthernetType();
    }

    public Command makeUdpPayloadUnique(short uniqueifier) {
        int shortsize = 4;
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(uniqueifier);
        byte[] result = b.array();
        UDPPacket udp = this.getCurrentUdp();
        ProtocolField payload = udp.getPayload();
        int payloadsize = payload.getSize();
        byte[] payloadBytes = new byte[payloadsize];
        payload.dump(payloadBytes, 0);
        int i = 0;
        while (i < 4) {
            payloadBytes[i] = result[i];
            ++i;
        }
        payload.set(payloadsize, payloadBytes, 0);
        return this.updateAutomaticFields();
    }

    public String createIPv6ScoutingFrame(String srcMacAddress, String dstMacAddress, String srcIpAddress, String dstIpAddress, List<Vlan> vlans) {
        return this.createScoutingFrame(false, srcMacAddress, dstMacAddress, srcIpAddress, dstIpAddress, vlans);
    }

    public String createIPv4ScoutingFrame(String srcMacAddress, String dstMacAddress, String srcIpAddress, String dstIpAddress, List<Vlan> vlans) {
        return this.createScoutingFrame(true, srcMacAddress, dstMacAddress, srcIpAddress, dstIpAddress, vlans);
    }

    public Command unsetFrameModifier() {
        FrameFieldModifier modifier = this.getFrameFieldModifier();
        return this.createRemoveModifier(new FrameModifier[]{modifier});
    }

    public boolean hasFrameModifiers() {
        return this.getReader().hasFrameModifiers();
    }

    public FrameFieldModifier getFrameFieldModifier() {
        return this.getReader().getFrameFieldModifier();
    }

    public EList<FrameModifier> getModifiers() {
        return this.getReader().getModifiers();
    }

    public CommandWithFrameModifierReference setFrameModifierIncremental() {
        IncrementalFieldModifier modifier = IncrementalFieldModifierController.create();
        return new CommandWithFrameModifierReference(this.createAddModifier(new FrameModifier[]{modifier}), (FrameFieldModifier)modifier);
    }

    public CommandWithFrameModifierReference setFrameModifierRandom() {
        RandomFieldModifier modifier = RandomFieldModifierController.create();
        return new CommandWithFrameModifierReference(this.createAddModifier(new FrameModifier[]{modifier}), (FrameFieldModifier)modifier);
    }

    public CommandWithFrameModifierReference setFrameModifierUnique() {
        UniqueFieldModifier modifier = UniqueFieldModifierController.create();
        return new CommandWithFrameModifierReference(this.createAddModifier(new FrameModifier[]{modifier}), (FrameFieldModifier)modifier);
    }

    public Byte getTosByte() {
        return this.getReader().getTosByte();
    }

    public final class CommandWithFrameModifierReference
    extends CommandWithReference<FrameFieldModifier> {
        private CommandWithFrameModifierReference(Command command, FrameFieldModifier reference) {
            super(command, (Object)reference);
        }

        public FrameFieldModifierController<?> getController() {
            return ControllerFactory.create((FrameFieldModifier)this.getCommandReference());
        }
    }
}

