/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.ByteCollectionController;
import com.excentis.products.byteblower.object.control.ByteController;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;

public final class Ipv4AddressController
extends IpAddressController<Ipv4Address> {
    private final String typeName;
    private static String ipv4_Part = "(\\d|[0-9]\\d|[0-1]\\d\\d|2[0-4]\\d|25[0-5])";
    private static String netmask_Part = "(0|[12]|1[29]|128|192|2[245]|224|24[08]|25[245])";
    private static String netmask_Part_Complete = "(128|192|224|24[08]|25[245]|0)";
    private static String ipv4_InputPattern = "^(" + ipv4_Part + ")?\\.?" + "(" + ipv4_Part + ")?\\.?" + "(" + ipv4_Part + ")?\\.?" + "(" + ipv4_Part + ")?\\.?" + "$";
    private static String ipv4_Pattern = "^" + ipv4_Part + "\\." + ipv4_Part + "\\." + ipv4_Part + "\\." + ipv4_Part + "$";
    private static String ipv4_Pattern_ForNetmask = "^" + netmask_Part_Complete + "\\." + netmask_Part_Complete + "\\." + netmask_Part_Complete + "\\." + netmask_Part_Complete + "$";

    private Ipv4AddressController(Ipv4Address myIpv4Address, String myTypeName) {
        super(myIpv4Address);
        this.typeName = myTypeName;
    }

    Ipv4AddressController(Ipv4Address ipv4Address) {
        this(ipv4Address, "IPv4 Address");
    }

    @Override
    protected final int getNetworkAddressSize() {
        return 4;
    }

    @Override
    public final void setAddress(String address) throws NumberFormatException {
        this.setAddress(address, '.', true);
    }

    protected static Ipv4Address create() {
        Ipv4Address ipv4Address = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv4Address();
        EList ipv4AddressBytes = ipv4Address.getBytes();
        int j = 0;
        while (j < 4) {
            ipv4AddressBytes.add((Object)0);
            ++j;
        }
        return ipv4Address;
    }

    protected static Ipv4Address createNetmask() {
        Ipv4Address ipv4Address = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv4Address();
        EList ipv4AddressBytes = ipv4Address.getBytes();
        int j = 1;
        while (j < 4) {
            ipv4AddressBytes.add((Object)ByteController.getByte((String)"255"));
            ++j;
        }
        ipv4AddressBytes.add((Object)0);
        return ipv4Address;
    }

    protected static Ipv4Address createBroadcast() {
        Ipv4Address ipv4Address = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv4Address();
        EList ipv4AddressBytes = ipv4Address.getBytes();
        int j = 0;
        while (j < 4) {
            ipv4AddressBytes.add((Object)ByteController.getByte((String)"255"));
            ++j;
        }
        return ipv4Address;
    }

    protected static Ipv4Address createEmptyIpv4Address() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv4Address();
    }

    public static Ipv4Address createFromString(String string) {
        if (Ipv4AddressController.isValid(string)) {
            Ipv4Address ipv4 = Ipv4AddressController.createEmptyIpv4Address();
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(ipv4);
            ipv4AddressController.setAddress(string);
            return ipv4;
        }
        return null;
    }

    public static NetworkAddressBytes createBytesFromString(String string) throws IllegalArgumentException {
        if (Ipv4AddressController.isValid(string)) {
            NetworkAddressBytes newByteList = new NetworkAddressBytes();
            ByteCollectionController byteCollectionController = new ByteCollectionController((List)((Object)newByteList));
            byteCollectionController.fromByteString(string, '.', true, 4);
            return newByteList;
        }
        throw new IllegalArgumentException("Failed to parse IPv4 address from String.");
    }

    public static boolean isValidPartialInput(String string) {
        return Pattern.matches(ipv4_InputPattern, string);
    }

    public static boolean isValid(String string) {
        return Pattern.matches(ipv4_Pattern, string);
    }

    public static boolean isValidNonZero(String string) {
        if (Pattern.matches(ipv4_Pattern, string)) {
            String nodotsnozeros = string.replaceAll("0", "");
            return (nodotsnozeros = nodotsnozeros.replaceAll("\\.", "")).length() != 0;
        }
        return false;
    }

    public static boolean isValidNetmask(String string) {
        if (!Pattern.matches(ipv4_Pattern_ForNetmask, string)) {
            return false;
        }
        String[] bytes = string.split("\\.");
        if (bytes.length != 4) {
            return false;
        }
        String bitMask = "";
        int i = 0;
        while (i < 4) {
            String byto = bytes[i];
            Integer integer = Integer.valueOf(byto);
            int val = integer;
            String bits = Integer.toBinaryString(val);
            while (bits.length() != 8) {
                bits = String.valueOf(bits) + "0";
            }
            if (bits.length() != 8) {
                return false;
            }
            bitMask = String.valueOf(bitMask) + bits;
            ++i;
        }
        int lastOneBit = bitMask.length() - 1;
        while (lastOneBit > 0 && bitMask.charAt(lastOneBit) == '0') {
            --lastOneBit;
        }
        return lastOneBit >= 0 && bitMask.indexOf("0") > lastOneBit;
    }

    public static boolean isValidNetmaskPartialInput(String string) {
        return Pattern.matches(ipv4_InputPattern, string);
    }

    public static boolean isValid(NetworkAddressBytes networkAddressBytes) {
        return networkAddressBytes.size() == 4;
    }

    @Override
    public boolean isValidValue(NetworkAddressBytes networkAddressBytes) {
        Ipv4Address myIpv4Address = (Ipv4Address)this.getObject();
        return myIpv4Address != null && networkAddressBytes.size() == 4;
    }

    public static void setAddress(Ipv4Address ipv4Address, String address) {
        Ipv4AddressController controller = ControllerFactory.create(ipv4Address);
        controller.setAddress(address);
    }

    public boolean isValidNetmask() {
        return Ipv4AddressController.isValidNetmask(this.getAddress());
    }

    @Override
    public String getMulticastMacAddressString() {
        return this.getReader().getMulticastMacAddressString();
    }

    private Ipv4AddressReader getReader() {
        return ReaderFactory.create((Ipv4Address)((Ipv4Address)this.getObject()));
    }
}

