/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.NetworkAddress;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.NetworkAddressController;
import com.excentis.products.byteblower.model.reader.Ipv6AddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.object.control.ByteCollectionController;
import com.excentis.products.byteblower.object.control.ByteController;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class Ipv6AddressController
extends IpAddressController<Ipv6Address> {
    private final String typeName;
    private static final BigInteger maxIpv6 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
    private static final EList<Byte> allZeros = new BasicEList(16);
    private static final String regexp_hex_block = "[0-9A-Fa-f]{1,4}";
    private static final String regexp_hex_block_input = "[0-9A-Fa-f]{1,8}";

    static {
        int i = 0;
        while (i < 16) {
            allZeros.add((Object)0);
            ++i;
        }
    }

    private Ipv6AddressController(Ipv6Address myIpv6Address, String myTypeName) {
        super(myIpv6Address);
        this.typeName = myTypeName;
    }

    Ipv6AddressController(Ipv6Address myIpv6Address) {
        this(myIpv6Address, "IPv6 Address");
    }

    @Override
    protected final int getNetworkAddressSize() {
        return 16;
    }

    @Override
    public final void setAddress(String newAddress) throws NumberFormatException {
        Ipv6Address myIpv6Address = (Ipv6Address)this.getObject();
        if (myIpv6Address != null) {
            NetworkAddressBytes newBytes = Ipv6AddressController.getBytes(newAddress);
            EList bytes = myIpv6Address.getBytes();
            bytes.clear();
            bytes.addAll((Collection)((Object)newBytes));
        }
    }

    @Override
    public final NetworkAddressController.CommandWithNetworkAddressReference setDecrementedAddress(Ipv6Address referenceNetworkAddress) {
        Ipv6Address decrementIpv6Address = (Ipv6Address)EByteBlowercoreUtil.copy((EObject)referenceNetworkAddress);
        ByteCollectionController byteCollectionController = new ByteCollectionController((List)decrementIpv6Address.getBytes());
        BigInteger val = byteCollectionController.toBigInteger();
        val = val.equals(BigInteger.ZERO) ? maxIpv6 : val.subtract(BigInteger.ONE);
        byteCollectionController.fromBigInteger(val);
        Command command = this.setAddressCommand((Collection<Byte>)decrementIpv6Address.getBytes());
        return new NetworkAddressController.CommandWithNetworkAddressReference((NetworkAddressController)this, command, (NetworkAddress)decrementIpv6Address);
    }

    @Override
    public final NetworkAddressController.CommandWithNetworkAddressReference setIncrementedAddress(Ipv6Address referenceNetworkAddress) {
        Ipv6Address incrementNetworkAddress = (Ipv6Address)EByteBlowercoreUtil.copy((EObject)referenceNetworkAddress);
        ByteCollectionController byteCollectionController = new ByteCollectionController((List)incrementNetworkAddress.getBytes());
        BigInteger val = byteCollectionController.toBigInteger();
        val = val.equals(maxIpv6) ? BigInteger.ZERO : val.add(BigInteger.ONE);
        byteCollectionController.fromBigInteger(val);
        Command command = this.setAddressCommand((Collection<Byte>)incrementNetworkAddress.getBytes());
        return new NetworkAddressController.CommandWithNetworkAddressReference((NetworkAddressController)this, command, (NetworkAddress)incrementNetworkAddress);
    }

    protected static Ipv6Address create() {
        Ipv6Address ipv6Address = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv6Address();
        ipv6Address.getBytes().addAll(allZeros);
        return ipv6Address;
    }

    protected static Ipv6Address createEmptyIpv6Address() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv6Address();
    }

    public static NetworkAddressBytes createBytesFromString(String string) throws IllegalArgumentException {
        if (Ipv6AddressController.isValid(string)) {
            return Ipv6AddressController.getBytes(string);
        }
        throw new IllegalArgumentException("Failed to parse IPv6 address from String.");
    }

    private static final NetworkAddressBytes getBytes(String address) {
        int i;
        String addr;
        NetworkAddressBytes networkAddressBytes;
        block9: {
            networkAddressBytes = new NetworkAddressBytes();
            if (!Ipv6AddressController.isValid(address, true)) {
                return null;
            }
            address = address.replaceAll("::", ":Z:");
            String[] addresParts = address.split(":");
            int nofParts = addresParts.length;
            addr = "";
            i = 0;
            while (i < nofParts) {
                String part = addresParts[i];
                if (part.equals("Z")) {
                    part = "";
                    int j = nofParts;
                    while (j <= 8) {
                        part = String.valueOf(part) + "0000";
                        ++j;
                    }
                }
                while (part.length() < 4) {
                    part = "0" + part;
                }
                addr = String.valueOf(addr) + part;
                ++i;
            }
            if (addr.length() == 32) break block9;
            return null;
        }
        try {
            i = 0;
            while (i < 32) {
                String hexByte = addr.substring(i, i + 2);
                Byte newByte = ByteController.toByte((String)hexByte);
                networkAddressBytes.add(newByte);
                i += 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return networkAddressBytes;
    }

    public static final boolean isValid(String address, boolean allowZero, boolean allowRedundantZeros) {
        int length = address.length();
        if (length == 0) {
            return false;
        }
        if (!allowRedundantZeros && length != 39) {
            return false;
        }
        if (address.indexOf(":::") != -1) {
            return false;
        }
        String zeros = "Z";
        String temp = address.replaceAll("::", ":Z:");
        int lastPos = temp.length() - 1;
        if (temp.indexOf(":") == 0 && temp.indexOf(":Z") != 0 || temp.lastIndexOf(":") == lastPos && temp.lastIndexOf("Z:") != lastPos - 1) {
            return false;
        }
        String[] hexBlocks = temp.split(":");
        int zeroFillerCount = 0;
        int valueCount = 0;
        boolean onlyZeros = true;
        int i = 0;
        while (i < hexBlocks.length) {
            String hexBlock = hexBlocks[i];
            if (hexBlock.length() != 0) {
                if (hexBlock.equals("Z")) {
                    ++zeroFillerCount;
                } else if (Pattern.matches(regexp_hex_block, hexBlock)) {
                    if (Integer.valueOf(hexBlock, 16) != 0) {
                        onlyZeros = false;
                    }
                    ++valueCount;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (onlyZeros && !allowZero) {
            return false;
        }
        if (valueCount > 8) {
            return false;
        }
        if (valueCount == 8 && zeroFillerCount != 0) {
            return false;
        }
        return valueCount >= 8 || zeroFillerCount == 1;
    }

    private static final boolean isValid(String address, boolean allowZero) {
        return Ipv6AddressController.isValid(address, allowZero, true);
    }

    public static final boolean isValid(String address) {
        return Ipv6AddressController.isValid(address, false);
    }

    public static final boolean isValidPartialInput(String address) {
        int len = address.length();
        if (len == 0) {
            return true;
        }
        if (len > 39) {
            return false;
        }
        String zeros = "Z";
        String temp = address.replaceAll("::", ":Z:");
        String[] hexBlocks = temp.split(":");
        int zeroCount = 0;
        int valueCount = 0;
        int i = 0;
        while (i < hexBlocks.length) {
            String hexBlock = hexBlocks[i];
            if (hexBlock.length() != 0) {
                if (hexBlock.equals("Z")) {
                    ++zeroCount;
                } else if (Pattern.matches(regexp_hex_block_input, hexBlock)) {
                    ++valueCount;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (valueCount > 8) {
            return false;
        }
        return valueCount != 8 || zeroCount == 0;
    }

    public static boolean isValid(NetworkAddressBytes networkAddressBytes) {
        return networkAddressBytes.size() == 16;
    }

    @Override
    public boolean isValidValue(NetworkAddressBytes networkAddressBytes) {
        Ipv6Address myIpv6Address = (Ipv6Address)this.getObject();
        return myIpv6Address != null && networkAddressBytes.size() == 16;
    }

    public static boolean isValidInput(String address) {
        int len = address.length();
        if (len == 0) {
            return true;
        }
        if (len > 39) {
            return false;
        }
        String zeros = "Z";
        String temp = address.replaceAll("::", ":Z:");
        String[] hexBlocks = temp.split(":");
        int zeroCount = 0;
        int valueCount = 0;
        int i = 0;
        while (i < hexBlocks.length) {
            String hexBlock = hexBlocks[i];
            if (hexBlock.length() != 0) {
                if (hexBlock.equals("Z")) {
                    ++zeroCount;
                } else if (Pattern.matches(regexp_hex_block_input, hexBlock)) {
                    ++valueCount;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (valueCount > 8) {
            return false;
        }
        return valueCount != 8 || zeroCount == 0;
    }

    @Override
    public String getMulticastMacAddressString() {
        return this.getReader().getMulticastMacAddressString();
    }

    private Ipv6AddressReader getReader() {
        return ReaderFactory.create((Ipv6Address)((Ipv6Address)this.getObject()));
    }
}

