/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.PortForwardingProtocol;
import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.PortMappingController;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.PortForwardingReader;
import com.excentis.products.byteblower.model.reader.PortMappingReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class PortForwardingController
extends EByteBlowerObjectController<PortForwarding>
implements PortForwardingReader {
    private static final String newPortForwardingPrefix = "PORT_FORWARDING_";
    private PortForwardingReader reader;

    PortForwardingController(PortForwarding myPortForwarding) {
        super(myPortForwarding);
    }

    private static final PortForwarding create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createPortForwarding();
    }

    protected static final PortForwarding create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newName;
        PortForwarding newPortForwarding = PortForwardingController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newPortForwarding, (String)(newName = referenceName))) {
            newName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newPortForwarding, (String)newName, (String)newPortForwardingPrefix);
        }
        newPortForwarding.setName(newName);
        Ipv4Address ipv4Address = Ipv4AddressController.create();
        newPortForwarding.setManualPublicIpv4(ipv4Address);
        return newPortForwarding;
    }

    public boolean isContained() {
        PortForwarding myPortForwarding = (PortForwarding)this.getObject();
        return myPortForwarding != null && myPortForwarding.eContainer() != null;
    }

    public final Object[] copyPortMapping(Collection<PortMapping> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (PortMapping object : objects) {
            PortMapping copy = (PortMapping)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        PortMapping[] array = (PortMapping[])copiedObjects.toArray((Object[])new PortMapping[objects.size()]);
        return new Object[]{array};
    }

    private final Command createAddCommand(PortMapping portMappings) {
        PortForwarding myPortForwarding = (PortForwarding)this.getObject();
        if (myPortForwarding != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMappings);
        }
        return null;
    }

    private final Command createAddCommand(Collection<PortMapping> portMappings) {
        PortForwarding myPortForwarding = (PortForwarding)this.getObject();
        if (myPortForwarding != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMappings);
        }
        return null;
    }

    private final Command createAddCommand(PortMapping portMapping, int index) {
        PortForwarding myPortForwarding = (PortForwarding)this.getObject();
        if (myPortForwarding != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMapping, index);
        }
        return null;
    }

    private final Command createAddCommand(Collection<PortMapping> portMappings, int index) {
        PortForwarding myPortForwarding = (PortForwarding)this.getObject();
        if (myPortForwarding != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMappings, index);
        }
        return null;
    }

    public final CommandWithPortMappingListReference addPortMapping() {
        return this.addPortMappings(1);
    }

    private final CommandWithPortMappingListReference addPortMappings(int amount) {
        return this.addPortMappings(amount, -1);
    }

    public final CommandWithPortMappingListReference addPortMappings(int amount, int index) {
        if (amount > 0) {
            PortForwarding myPortForwarding = (PortForwarding)this.getObject();
            CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
            if (myPortForwarding != null) {
                UniqueEList controllers = new UniqueEList();
                if (amount == 1) {
                    PortMapping newObject = PortMappingController.create();
                    controllers.add((Object)ControllerFactory.create(newObject));
                    compoundCommandController.appendCommand(index == -1 ? this.createAddCommand(newObject) : this.createAddCommand(newObject, index));
                } else {
                    UniqueEList newObjects = new UniqueEList();
                    int i = 0;
                    while (i < amount) {
                        PortMapping newObject = PortMappingController.create();
                        newObjects.add((Object)newObject);
                        controllers.add((Object)ControllerFactory.create(newObject));
                        ++i;
                    }
                    compoundCommandController.appendCommand(index == -1 ? this.createAddCommand((Collection<PortMapping>)newObjects) : this.createAddCommand((Collection<PortMapping>)newObjects, index));
                }
                return new CommandWithPortMappingListReference(compoundCommandController.unwrap(), (List<PortMappingController>)controllers);
            }
        }
        return null;
    }

    private PortForwardingReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PortForwarding)((PortForwarding)this.getObject()));
        }
        return this.reader;
    }

    public EList<PortMapping> getPortMappings() {
        return this.getReader().getPortMappings();
    }

    public final CommandWithPortMappingListReference pastePortMapping(PortMapping[] copiedObjects, int pastePos) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        CompoundCommand referenceSetCompound = new CompoundCommand();
        BasicEList pasteControllers = new BasicEList();
        BasicEList pastedObjects = new BasicEList();
        if (copiedObjects != null) {
            PortMapping[] portMappingArray = copiedObjects;
            int n = copiedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                PortMapping copiedObject = portMappingArray[n2];
                PortMapping portMapping = (PortMapping)this.duplicate(referenceSetCompound, (EByteBlowerObject)copiedObject);
                if (portMapping != null) {
                    PortMappingController portMappingController = ControllerFactory.create(portMapping);
                    pastedObjects.add((Object)portMapping);
                    pasteControllers.add((Object)portMappingController);
                }
                ++n2;
            }
            compound.appendCommand(this.createAddCommand((Collection<PortMapping>)pastedObjects, pastePos));
            compound.appendCommand((Command)referenceSetCompound);
        }
        return new CommandWithPortMappingListReference(compound.unwrap(), (List<PortMappingController>)pasteControllers);
    }

    public String getAutomaticDiscoveryString() {
        return this.getReader().getAutomaticDiscoveryString();
    }

    public boolean isAutomaticPublicIpv4() {
        return this.getReader().isAutomaticPublicIpv4();
    }

    public String getAutomaticDiscoveryProbePortString() {
        return this.getReader().getAutomaticDiscoveryProbePortString();
    }

    public String getAutomaticDiscoveryProbeProtocolString() {
        return this.getReader().getAutomaticDiscoveryProbeProtocolString();
    }

    public String getManualPublicIpv4AddressString() {
        return this.getReader().getManualPublicIpv4AddressString();
    }

    public final Command setManualPublicIpAddress(NetworkAddressBytes ipv4Address) {
        PortForwarding portForwarding = (PortForwarding)this.getObject();
        Ipv4AddressController ipAddressController = ControllerFactory.create(portForwarding.getManualPublicIpv4());
        if (((IpAddressController)ipAddressController).isValidValue(ipv4Address)) {
            return ipAddressController.setAddress(ipv4Address);
        }
        return null;
    }

    public Command setAutomaticDiscoveryProtocol(PortForwardingProtocol protocol) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__AUTOMATIC_PUBLIC_IPV4_PROBE_PROTOCOL, protocol);
    }

    public Ipv4AddressReader getManualPublicIpv4AddressReader() {
        return this.getReader().getManualPublicIpv4AddressReader();
    }

    public Ipv4Address getManualPublicIpv4Address() {
        return this.getReader().getManualPublicIpv4Address();
    }

    public boolean hasValidManualIp() {
        return this.getReader().hasValidManualIp();
    }

    @Override
    public void createStatuses() {
        if (!this.isAutomaticPublicIpv4() && !this.hasValidManualIp()) {
            this.addErrorStatus("IP address is invalid (" + this.getManualPublicIpv4AddressString() + ")");
        }
        boolean privateError = false;
        boolean publicError = false;
        for (PortMapping portMapping : this.getPortMappings()) {
            PortMappingReader reader = ReaderFactory.create((PortMapping)portMapping);
            if (!privateError && reader.isPrivatePortOverlapping()) {
                privateError = true;
                this.addErrorStatus("Overlapping private port numbers");
            }
            if (!publicError && reader.isPublicPortOverlapping()) {
                publicError = true;
                this.addErrorStatus("Overlapping public port numbers");
            }
            if (publicError && privateError) break;
        }
    }

    public final class CommandWithPortMappingListReference
    extends CommandWithListReference<PortMappingController> {
        private CommandWithPortMappingListReference(Command myCommand, List<PortMappingController> reference) {
            super(myCommand, reference);
        }
    }
}

